/*
 * Decompiled with CFR 0.152.
 */
package net.interfax.rest.client.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.interfax.rest.client.InterFAX;
import net.interfax.rest.client.config.ClientConfig;
import net.interfax.rest.client.config.ConfigLoader;
import net.interfax.rest.client.domain.APIResponse;
import net.interfax.rest.client.domain.DocumentUploadSessionOptions;
import net.interfax.rest.client.domain.GetFaxListOptions;
import net.interfax.rest.client.domain.GetInboundFaxListOptions;
import net.interfax.rest.client.domain.GetUploadedDocumentsListOptions;
import net.interfax.rest.client.domain.InboundFaxStructure;
import net.interfax.rest.client.domain.InboundFaxesEmailsStructure;
import net.interfax.rest.client.domain.OutboundFaxStructure;
import net.interfax.rest.client.domain.SearchFaxOptions;
import net.interfax.rest.client.domain.SendFaxOptions;
import net.interfax.rest.client.domain.UploadedDocumentStatus;
import net.interfax.rest.client.exception.UnsuccessfulStatusCodeException;
import net.interfax.rest.client.impl.AbstractInterFAXClient;
import net.interfax.rest.client.impl.JerseyRequestExecutor;
import net.interfax.rest.client.util.ArrayUtil;
import org.apache.tika.Tika;
import org.apache.tika.io.IOUtils;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInterFAXClient
extends AbstractInterFAXClient
implements InterFAX {
    private Client client;
    private Tika tika;
    private static final Logger log = LoggerFactory.getLogger(DefaultInterFAXClient.class);

    public DefaultInterFAXClient(String username, String password) {
        this.username = username;
        this.password = password;
        this.initializeClient(username, password);
    }

    public DefaultInterFAXClient() {
        this.initialiseCredentials();
        this.initializeClient(this.username, this.password);
    }

    @Override
    public APIResponse sendFax(String faxNumber, File fileToSendAsFax) throws IOException, URISyntaxException {
        return this.sendFax(faxNumber, fileToSendAsFax, Optional.empty());
    }

    @Override
    public APIResponse sendFax(String faxNumber, File fileToSendAsFax, Optional<SendFaxOptions> options) throws IOException, URISyntaxException {
        String contentType = this.tika.detect(fileToSendAsFax);
        URI uri = this.getSendFaxUri(faxNumber, options);
        return this.executePostRequest(uri, target -> target.request().header("Content-Type", (Object)contentType).post(Entity.entity((Object)fileToSendAsFax, (String)contentType)));
    }

    @Override
    public APIResponse sendFax(String faxNumber, File[] filesToSendAsFax) throws IOException, URISyntaxException {
        return this.sendFax(faxNumber, filesToSendAsFax, Optional.empty());
    }

    @Override
    public APIResponse sendFax(String faxNumber, InputStream[] streamsToSendAsFax, String[] fileNames) throws IOException, URISyntaxException {
        return this.sendFax(faxNumber, streamsToSendAsFax, fileNames, Optional.empty());
    }

    @Override
    public APIResponse sendFax(String faxNumber, File[] filesToSendAsFax, Optional<SendFaxOptions> options) throws IOException, URISyntaxException {
        MultiPart multiPart = new MultiPart();
        int count = 1;
        for (File file : filesToSendAsFax) {
            String contentType = this.tika.detect(file);
            String entityName = "file" + count++;
            FileDataBodyPart fileDataBodyPart = new FileDataBodyPart(entityName, file, MediaType.valueOf((String)contentType));
            multiPart.bodyPart((BodyPart)fileDataBodyPart);
        }
        return this.sendMultiPartFax(faxNumber, multiPart, options);
    }

    @Override
    public APIResponse sendFax(String faxNumber, InputStream[] streamsToSendAsFax, String[] mediaTypes, Optional<SendFaxOptions> options) throws IOException, URISyntaxException {
        if (streamsToSendAsFax.length != mediaTypes.length) {
            throw new IllegalArgumentException("Stream and file name arrays do not have the same length");
        }
        MultiPart multiPart = new MultiPart();
        for (int i = 0; i < streamsToSendAsFax.length; ++i) {
            String entityName = "file" + i;
            StreamDataBodyPart streamDataBodyPart = new StreamDataBodyPart(entityName, streamsToSendAsFax[i], entityName, MediaType.valueOf((String)mediaTypes[i]));
            multiPart.bodyPart((BodyPart)streamDataBodyPart);
        }
        return this.sendMultiPartFax(faxNumber, multiPart, options);
    }

    @Override
    public APIResponse sendFax(String faxNumber, String urlOfDoc) throws URISyntaxException {
        return this.sendFax(faxNumber, urlOfDoc, Optional.empty());
    }

    @Override
    public APIResponse sendFax(String faxNumber, String urlOfDoc, Optional<SendFaxOptions> options) throws URISyntaxException {
        URI uri = this.getSendFaxUri(faxNumber, options);
        return this.executePostRequest(uri, target -> target.request().header("Content-Location", (Object)urlOfDoc).header("Content-Length", (Object)0).post(null));
    }

    @Override
    public APIResponse resendFax(String id, Optional<String> faxNumber) {
        UriBuilder outboundFaxesResendUriBuilder = UriBuilder.fromPath((String)String.format(this.outboundFaxesResendEndpoint, id)).scheme(this.scheme).host(this.hostname).port(this.port);
        faxNumber.ifPresent(x -> outboundFaxesResendUriBuilder.queryParam("faxNumber", new Object[]{x}));
        URI uri = outboundFaxesResendUriBuilder.build(new Object[0]);
        return this.executePostRequest(uri, target -> target.request().header("Content-Length", (Object)0).post(null));
    }

    @Override
    public APIResponse hideFax(String id) {
        String endpoint = String.format(this.outboundFaxesHideEndpoint, id);
        URI uri = UriBuilder.fromPath((String)endpoint).scheme(this.scheme).host(this.hostname).port(this.port).build(new Object[0]);
        return this.executePostRequest(uri, target -> target.request().header("Content-Length", (Object)0).post(null));
    }

    @Override
    public OutboundFaxStructure[] getFaxList() throws UnsuccessfulStatusCodeException {
        return this.getFaxList(Optional.empty());
    }

    @Override
    public OutboundFaxStructure[] getFaxList(Optional<GetFaxListOptions> options) throws UnsuccessfulStatusCodeException {
        UriBuilder outboundFaxesUriBuilder = UriBuilder.fromPath((String)this.outboundFaxesEndpoint).host(this.hostname).scheme(this.scheme).port(this.port);
        if (options.isPresent()) {
            GetFaxListOptions reqOptions = options.orElse(null);
            reqOptions.getLastId().ifPresent(x -> outboundFaxesUriBuilder.queryParam("lastId", new Object[]{x}));
            reqOptions.getLimit().ifPresent(x -> outboundFaxesUriBuilder.queryParam("limit", new Object[]{x}));
            reqOptions.getSortOrder().ifPresent(x -> outboundFaxesUriBuilder.queryParam("sortOrder", new Object[]{x}));
            reqOptions.getUserId().ifPresent(x -> outboundFaxesUriBuilder.queryParam("userId", new Object[]{x}));
        }
        return (OutboundFaxStructure[])this.executeGetRequest(outboundFaxesUriBuilder.build(new Object[0]), OutboundFaxStructure[].class, target -> target.request().get());
    }

    @Override
    public OutboundFaxStructure[] getCompletedFaxList(String[] ids) throws UnsuccessfulStatusCodeException {
        URI outboundFaxesCompletedUri = UriBuilder.fromPath((String)this.outboundFaxesCompletedEndpoint).host(this.hostname).scheme(this.scheme).port(this.port).queryParam("ids", new Object[]{this.getCsvIds(ids)}).build(new Object[0]);
        return (OutboundFaxStructure[])this.executeGetRequest(outboundFaxesCompletedUri, OutboundFaxStructure[].class, target -> target.request().get());
    }

    @Override
    public OutboundFaxStructure getOutboundFaxRecord(String id) throws UnsuccessfulStatusCodeException {
        URI outboundFaxesRecordUri = UriBuilder.fromUri((String)String.format(this.outboundFaxesRecordEndpoint, id)).scheme(this.scheme).host(this.hostname).port(this.port).build(new Object[0]);
        return (OutboundFaxStructure)this.executeGetRequest(outboundFaxesRecordUri, OutboundFaxStructure.class, target -> target.request().get());
    }

    @Override
    public byte[] getOutboundFaxImage(String id) throws UnsuccessfulStatusCodeException {
        return this.getFaxImage(String.format(this.outboundFaxImageEndpoint, id));
    }

    @Override
    public APIResponse cancelFax(String id) {
        URI uri = UriBuilder.fromPath((String)String.format(this.outboundFaxesCancelEndpoint, id)).host(this.hostname).scheme(this.scheme).port(this.port).build(new Object[0]);
        return this.executePostRequest(uri, target -> target.request().header("Content-Length", (Object)0).post(null));
    }

    @Override
    public OutboundFaxStructure[] searchFaxList() throws UnsuccessfulStatusCodeException {
        URI uri = UriBuilder.fromUri((String)this.outboundSearchEndpoint).scheme(this.scheme).host(this.hostname).port(this.port).build(new Object[0]);
        return (OutboundFaxStructure[])this.executeGetRequest(uri, OutboundFaxStructure[].class, target -> target.request().get());
    }

    @Override
    public OutboundFaxStructure[] searchFaxList(Optional<SearchFaxOptions> options) throws UnsuccessfulStatusCodeException {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.outboundSearchEndpoint).scheme(this.scheme).host(this.hostname).port(this.port);
        if (options.isPresent()) {
            options.get().getIds().ifPresent(x -> uriBuilder.queryParam("ids", new Object[]{x}));
            options.get().getReference().ifPresent(x -> uriBuilder.queryParam("reference", new Object[]{x}));
            options.get().getDateFrom().ifPresent(x -> uriBuilder.queryParam("dateFrom", new Object[]{x}));
            options.get().getDateTo().ifPresent(x -> uriBuilder.queryParam("dateTo", new Object[]{x}));
            options.get().getStatus().ifPresent(x -> uriBuilder.queryParam("status", new Object[]{x}));
            options.get().getUserId().ifPresent(x -> uriBuilder.queryParam("userId", new Object[]{x}));
            options.get().getFaxNumber().ifPresent(x -> uriBuilder.queryParam("faxNumber", new Object[]{x}));
            options.get().getLimit().ifPresent(x -> uriBuilder.queryParam("limit", new Object[]{x}));
            options.get().getOffset().ifPresent(x -> uriBuilder.queryParam("offset", new Object[]{x}));
        }
        return (OutboundFaxStructure[])this.executeGetRequest(uriBuilder.build(new Object[0]), OutboundFaxStructure[].class, target -> target.request().get());
    }

    @Override
    public APIResponse uploadDocument(File fileToUpload) {
        return this.uploadDocument(fileToUpload, Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public APIResponse uploadDocument(File fileToUpload, Optional<DocumentUploadSessionOptions> options) {
        Response response = null;
        APIResponse apiResponse = new APIResponse();
        try {
            URI outboundDocumentsUri = this.getOutboundDocumentsUri(fileToUpload, options);
            WebTarget target = this.client.target(outboundDocumentsUri);
            response = target.request().header("Content-Length", (Object)0).post(null);
            apiResponse = new APIResponse();
            apiResponse.setStatusCode(response.getStatus());
            this.copyHeadersToAPIResponse(response, apiResponse);
            if (response.hasEntity()) {
                apiResponse.setResponseBody((String)response.readEntity(String.class));
            }
            if (apiResponse.getStatusCode() == Response.Status.CREATED.getStatusCode()) {
                String uploadChunkToDocumentEndpoint = URI.create(apiResponse.getHeaders().get("Location").get(0).toString()).getPath();
                FileInputStream inputStream = new FileInputStream(fileToUpload);
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                int chunkSize = 0x100000;
                byte[][] chunks = ArrayUtil.chunkArray(bytes, chunkSize);
                int bytesUploaded = 0;
                APIResponse chunkUploadResponses = new APIResponse();
                for (int i = 0; i < chunks.length; ++i) {
                    boolean lastChunk = false;
                    if (i == chunks.length - 1) {
                        lastChunk = true;
                    }
                    chunkUploadResponses = this.uploadChunk(uploadChunkToDocumentEndpoint, chunks[i], bytesUploaded, bytesUploaded + chunks[i].length - 1, lastChunk);
                    bytesUploaded += chunks[i].length;
                }
                apiResponse.setStatusCode(chunkUploadResponses.getStatusCode());
            }
            this.close(response);
        }
        catch (Exception e) {
            log.error("Exception occurred while uplading document", (Throwable)e);
            apiResponse.setStatusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        finally {
            this.close(response);
        }
        return apiResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public APIResponse uploadChunk(String uploadChunkToDocumentEndpoint, byte[] bytesToUpload, int startByteRange, int endByteRange, boolean lastChunk) {
        Response response = null;
        APIResponse apiResponse = new APIResponse();
        try {
            int expectedResponseCode;
            URI uploadChunkToDocumentUri = UriBuilder.fromPath((String)uploadChunkToDocumentEndpoint).scheme(this.scheme).host(this.hostname).port(this.port).build(new Object[0]);
            WebTarget target = this.client.target(uploadChunkToDocumentUri);
            response = target.request().header("Range", (Object)("bytes=" + startByteRange + "-" + endByteRange)).post(Entity.entity((Object)bytesToUpload, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
            int n = expectedResponseCode = lastChunk ? Response.Status.OK.getStatusCode() : Response.Status.ACCEPTED.getStatusCode();
            if (response.getStatus() != expectedResponseCode) {
                throw new Exception("Unexpected response code when uploading chunk" + response.getStatus() + "\r\n Endpoint" + uploadChunkToDocumentEndpoint + "\r\n LastChunk: " + lastChunk + "\r\n endByteRange: " + endByteRange);
            }
            log.info("chunk uploaded at {}; totalByesUploaded = {}; lastChunk = {}", new Object[]{uploadChunkToDocumentEndpoint, endByteRange, lastChunk});
            apiResponse.setStatusCode(response.getStatus());
            this.copyHeadersToAPIResponse(response, apiResponse);
            this.close(response);
        }
        catch (Exception e) {
            log.error("Exception occurred while uploading chunk", (Throwable)e);
            apiResponse.setStatusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        finally {
            this.close(response);
        }
        return apiResponse;
    }

    @Override
    public UploadedDocumentStatus[] getUploadedDocumentsList() throws UnsuccessfulStatusCodeException {
        return this.getUploadedDocumentsList(Optional.empty());
    }

    @Override
    public UploadedDocumentStatus[] getUploadedDocumentsList(Optional<GetUploadedDocumentsListOptions> options) throws UnsuccessfulStatusCodeException {
        URI outboundDocumentsUriToGetDocumentsList = this.getUploadedDocumentListUri(options);
        return (UploadedDocumentStatus[])this.executeGetRequest(outboundDocumentsUriToGetDocumentsList, UploadedDocumentStatus[].class, target -> target.request().get());
    }

    @Override
    public UploadedDocumentStatus getUploadedDocumentStatus(String documentId) throws UnsuccessfulStatusCodeException {
        URI outboundDocumentUri = UriBuilder.fromPath((String)(this.outboundDocumentsEndpoint + "/" + documentId)).scheme(this.scheme).host(this.hostname).port(this.port).build(new Object[0]);
        return (UploadedDocumentStatus)this.executeGetRequest(outboundDocumentUri, UploadedDocumentStatus.class, target -> target.request().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public APIResponse cancelDocumentUploadSession(String documentId) {
        Response response = null;
        APIResponse apiResponse = new APIResponse();
        try {
            URI outboundDocumentUri = UriBuilder.fromPath((String)(this.outboundDocumentsEndpoint + "/" + documentId)).scheme(this.scheme).host(this.hostname).port(this.port).build(new Object[0]);
            WebTarget target = this.client.target(outboundDocumentUri);
            response = target.request().delete();
            apiResponse.setStatusCode(response.getStatus());
            apiResponse.setResponseBody((String)response.readEntity(String.class));
            this.copyHeadersToAPIResponse(response, apiResponse);
            this.close(response);
        }
        catch (Exception e) {
            log.error("Exception occurred while cancelling doc upload session", (Throwable)e);
        }
        finally {
            this.close(response);
        }
        return apiResponse;
    }

    @Override
    public Double getAccountCredits() throws UnsuccessfulStatusCodeException {
        URI uri = UriBuilder.fromPath((String)this.accountsBalanceEndpoint).scheme(this.scheme).host(this.hostname).port(this.port).build(new Object[0]);
        return (Double)this.executeGetRequest(uri, Double.class, target -> target.request().get());
    }

    @Override
    public InboundFaxStructure[] getInboundFaxList() throws UnsuccessfulStatusCodeException {
        return this.getInboundFaxList(Optional.empty());
    }

    @Override
    public InboundFaxStructure[] getInboundFaxList(Optional<GetInboundFaxListOptions> options) throws UnsuccessfulStatusCodeException {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.inboundFaxesEndpoint).scheme(this.scheme).host(this.hostname).port(this.port);
        if (options.isPresent()) {
            options.get().getAllUsers().ifPresent(x -> uriBuilder.queryParam("allUsers", new Object[]{x}));
            options.get().getLastId().ifPresent(x -> uriBuilder.queryParam("lastId", new Object[]{x}));
            options.get().getLimit().ifPresent(x -> uriBuilder.queryParam("limit", new Object[]{x}));
            options.get().getUnreadOnly().ifPresent(x -> uriBuilder.queryParam("unreadOnly", new Object[]{x}));
        }
        return (InboundFaxStructure[])this.executeGetRequest(uriBuilder.build(new Object[0]), InboundFaxStructure[].class, t -> t.request().get());
    }

    @Override
    public InboundFaxStructure getInboundFaxRecord(String id) throws UnsuccessfulStatusCodeException {
        String path = this.inboundFaxesEndpoint + "/" + id;
        URI uri = UriBuilder.fromPath((String)path).scheme(this.scheme).host(this.hostname).port(this.port).build(new Object[0]);
        return (InboundFaxStructure)this.executeGetRequest(uri, InboundFaxStructure.class, t -> t.request().get());
    }

    @Override
    public byte[] getInboundFaxImage(long id) throws UnsuccessfulStatusCodeException {
        return this.getFaxImage(String.format(this.inboundFaxesImageEndpoint, id));
    }

    @Override
    public InboundFaxesEmailsStructure getInboundFaxForwardingEmails(String id) throws UnsuccessfulStatusCodeException {
        String path = String.format(this.inboundFaxesEmailsEndpoint, id);
        URI uri = UriBuilder.fromPath((String)path).scheme(this.scheme).host(this.hostname).port(this.port).build(new Object[0]);
        return (InboundFaxesEmailsStructure)this.executeGetRequest(uri, InboundFaxesEmailsStructure.class, t -> t.request().get());
    }

    @Override
    public APIResponse markInboundFax(String id, Optional<Boolean> unread) {
        String path = String.format(this.inboundFaxesMarkEndpoint, id);
        UriBuilder uriBuilder = UriBuilder.fromPath((String)path).scheme(this.scheme).host(this.hostname).port(this.port);
        unread.ifPresent(x -> uriBuilder.queryParam("unread", new Object[]{x}));
        return this.executePostRequest(uriBuilder.build(new Object[0]), t -> t.request().header("Content-Length", (Object)0).post(null));
    }

    @Override
    public APIResponse resendInboundFax(String id, Optional<String> email) {
        String path = String.format(this.inboundFaxesResendEndpoint, id);
        UriBuilder uriBuilder = UriBuilder.fromPath((String)path).scheme(this.scheme).host(this.hostname).port(this.port);
        email.ifPresent(x -> uriBuilder.queryParam("email", new Object[]{x}));
        return this.executePostRequest(uriBuilder.build(new Object[0]), t -> t.request().header("Content-Length", (Object)0).post(null));
    }

    @Override
    public void closeClient() {
        this.client.close();
    }

    private APIResponse sendMultiPartFax(String faxNumber, MultiPart multiPart, Optional<SendFaxOptions> options) throws URISyntaxException {
        URI uri = this.getSendFaxUri(faxNumber, options);
        return this.executePostRequest(uri, target -> target.request().header("Content-Type", (Object)"multipart/mixed").post(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIResponse executePostRequest(URI uri, JerseyRequestExecutor executor) {
        Response response = null;
        APIResponse apiResponse = new APIResponse();
        try {
            WebTarget target = this.client.target(uri);
            response = executor.readyTheTargetAndExecute(target);
            apiResponse.setStatusCode(response.getStatus());
            this.copyHeadersToAPIResponse(response, apiResponse);
            if (response.hasEntity()) {
                apiResponse.setResponseBody((String)response.readEntity(String.class));
            }
            this.close(response);
        }
        catch (Exception e) {
            try {
                log.error("Exception occurred while executing request", (Throwable)e);
                apiResponse.setStatusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                if (response != null && response.hasEntity()) {
                    apiResponse.setResponseBody((String)response.readEntity(String.class));
                }
                this.close(response);
            }
            catch (Throwable throwable) {
                this.close(response);
                throw throwable;
            }
        }
        return apiResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeGetRequest(URI uri, Class responseEntityClass, JerseyRequestExecutor executor) throws UnsuccessfulStatusCodeException {
        Response response = null;
        Object responseEntity = null;
        try {
            WebTarget target = this.client.target(uri);
            response = executor.readyTheTargetAndExecute(target);
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                responseEntity = response.readEntity(responseEntityClass);
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String responseBody = null;
                if (response.hasEntity()) {
                    responseBody = (String)response.readEntity(String.class);
                }
                throw new UnsuccessfulStatusCodeException(response.getStatus(), responseBody);
            }
            this.close(response);
        }
        catch (Throwable throwable) {
            this.close(response);
            throw throwable;
        }
        return responseEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getFaxImage(String path) throws UnsuccessfulStatusCodeException {
        Response response = null;
        byte[] responseBytes = null;
        try {
            URI uri = UriBuilder.fromPath((String)path).host(this.hostname).scheme(this.scheme).port(this.port).build(new Object[0]);
            response = this.client.target(uri).request().get();
            if (response.getStatus() != 200) {
                String responseBody = null;
                if (response.hasEntity()) {
                    responseBody = (String)response.readEntity(String.class);
                }
                throw new UnsuccessfulStatusCodeException("Unsuccessful response from API", response.getStatus(), responseBody);
            }
            InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
            responseBytes = IOUtils.toByteArray((InputStream)inputStream);
            inputStream.close();
            this.close(response);
        }
        catch (IOException e) {
            log.error("Exception occurred while getting fax image", (Throwable)e);
        }
        finally {
            this.close(response);
        }
        return responseBytes;
    }

    private void copyHeadersToAPIResponse(Response response, APIResponse apiResponse) {
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        response.getHeaders().forEach(headers::put);
        apiResponse.setHeaders(headers);
    }

    private String getCsvIds(String[] ids) {
        return Arrays.stream(ids).reduce((x, y) -> x + "," + y).orElse("");
    }

    private void close(Response response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Exception e) {
                log.error("Failed to close response, may cause a connection leak", (Throwable)e);
            }
        }
    }

    private void initializeClient(String username, String password) {
        HttpAuthenticationFeature httpAuthenticationFeature = HttpAuthenticationFeature.basic((String)username, (String)password);
        ClientConfig clientConfig = new ConfigLoader<ClientConfig>(ClientConfig.class, "interfax-api-config.yaml").getTestConfig();
        this.client = ClientBuilder.newClient();
        this.client.register((Object)httpAuthenticationFeature);
        this.client.register(MultiPartFeature.class);
        this.client.register((Object)RequestEntityProcessing.CHUNKED);
        this.client.register(JacksonFeature.class);
        this.scheme = clientConfig.getInterFAX().getScheme();
        this.hostname = clientConfig.getInterFAX().getHostname();
        this.port = clientConfig.getInterFAX().getPort();
        this.readConfigAndInitializeEndpoints(clientConfig);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        this.tika = new Tika();
    }
}

