/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.embedded;

import iot.jcypher.database.embedded.AbstractEmbeddedDBAccess;
import iot.jcypher.database.internal.DBUtil;
import iot.jcypher.query.result.JcError;
import iot.jcypher.transaction.internal.AbstractTransaction;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Transaction;

public class ETransactionImpl
extends AbstractTransaction {
    private Transaction transaction;

    public ETransactionImpl(AbstractEmbeddedDBAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public List<JcError> close() {
        List<JcError> errors;
        if (this.isClosed()) {
            throw new RuntimeException("transaction has already been closed");
        }
        if (!this.isMyThread()) {
            throw new RuntimeException("close() must be called from within the same thread which created this transaction");
        }
        AbstractEmbeddedDBAccess edba = this.getEDBAccess();
        edba.removeTx();
        if (this.transaction != null) {
            Transaction tx = this.getTransaction();
            if (this.failed) {
                tx.failure();
            } else {
                tx.success();
            }
            Throwable dbException = null;
            try {
                tx.close();
            }
            catch (Throwable e) {
                dbException = e;
            }
            errors = DBUtil.buildErrorList(null, dbException);
        } else {
            errors = new ArrayList<JcError>();
        }
        if (errors.size() > 0) {
            this.failure();
        }
        this.setClosed();
        return errors;
    }

    public Transaction getTransaction() {
        if (this.transaction == null) {
            AbstractEmbeddedDBAccess edba = this.getEDBAccess();
            this.transaction = edba.getGraphDB().beginTx();
        }
        return this.transaction;
    }

    private AbstractEmbeddedDBAccess getEDBAccess() {
        return (AbstractEmbeddedDBAccess)this.getDBAccess();
    }
}

