/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.embedded;

import iot.jcypher.database.DBType;
import iot.jcypher.database.embedded.AbstractEmbeddedDBAccess;
import java.io.File;
import java.util.Properties;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;

public class EmbeddedDBAccess
extends AbstractEmbeddedDBAccess {
    @Override
    public void initialize(Properties properties) {
        this.properties = properties;
        if (this.properties.getProperty("database_dir") == null) {
            throw new RuntimeException("missing property: 'database_dir' in database configuration");
        }
    }

    @Override
    public DBType getDBType() {
        return DBType.EMBEDDED;
    }

    @Override
    protected GraphDatabaseService createGraphDB() {
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(new File(this.properties.getProperty("database_dir")));
        if (this.properties.getProperty("pagecache_memory") != null) {
            builder.setConfig(GraphDatabaseSettings.pagecache_memory, "pagecache_memory");
        }
        if (this.properties.getProperty("string_block_size") != null) {
            builder.setConfig(GraphDatabaseSettings.string_block_size, "array_block_size");
        }
        if (this.properties.getProperty("string_block_size") != null) {
            builder.setConfig(GraphDatabaseSettings.array_block_size, "array_block_size");
        }
        return builder.newGraphDatabase();
    }
}

