/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.internal;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrRelation;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.factories.clause.DO;
import iot.jcypher.query.factories.clause.MATCH;
import iot.jcypher.query.factories.clause.OPTIONAL_MATCH;
import iot.jcypher.query.factories.clause.RETURN;
import iot.jcypher.query.factories.clause.SEPARATE;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.result.JcResultException;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcRelation;
import iot.jcypher.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;

public class DBUtil {
    public static List<JcError> clearDatabase(IDBAccess dbAccess) {
        JcNode n = new JcNode("n");
        JcRelation r = new JcRelation("r");
        IClause[] clauses = new IClause[]{MATCH.node(n), OPTIONAL_MATCH.node(n).relation(r).node(), DO.DELETE(n), DO.DELETE(r)};
        JcQuery query = new JcQuery();
        query.setClauses(clauses);
        JcQueryResult result = dbAccess.execute(query);
        List<JcError> errors = Util.collectErrors(result);
        return errors;
    }

    public static boolean isDatabaseEmpty(IDBAccess dbAccess) {
        JcNode n = new JcNode("n");
        JcRelation r = new JcRelation("r");
        JcQuery query = new JcQuery();
        query.setClauses(new IClause[]{MATCH.node(n), SEPARATE.nextClause(), MATCH.node().relation(r).node(), RETURN.ALL()});
        JcQueryResult result = dbAccess.execute(query);
        if (result.hasErrors()) {
            List<JcError> errors = Util.collectErrors(result);
            throw new JcResultException(errors);
        }
        List<GrNode> nodes = result.resultOf(n);
        List<GrRelation> relations = result.resultOf(r);
        return nodes.size() == 0 && relations.size() == 0;
    }

    public static String getStacktrace(Throwable exception) {
        String ret;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bo);
        exception.printStackTrace(ps);
        ps.flush();
        try {
            ret = bo.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ps.close();
        return ret;
    }

    public static List<JcError> buildErrorList(Response response, Throwable exception) {
        ArrayList<JcError> errors = new ArrayList<JcError>();
        if (exception == null) {
            Response.StatusType status;
            if (response != null && (status = response.getStatusInfo()) != null && status.getStatusCode() >= 400) {
                String code = String.valueOf(status.getStatusCode());
                String msg = status.getReasonPhrase();
                errors.add(new JcError(code, msg, null));
            }
        } else {
            String typ = exception.getClass().getSimpleName();
            String msg = exception.getLocalizedMessage();
            errors.add(new JcError(typ, msg, DBUtil.getStacktrace(exception)));
        }
        return errors;
    }
}

