/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.remote;

import iot.jcypher.database.DBType;
import iot.jcypher.database.internal.DBUtil;
import iot.jcypher.database.internal.IDBAccessInit;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.result.JcError;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractRemoteDBAccess
implements IDBAccessInit {
    protected Thread shutdownHook;
    protected Properties properties;

    @Override
    public JcQueryResult execute(JcQuery query) {
        ArrayList<JcQuery> qList = new ArrayList<JcQuery>();
        qList.add(query);
        List<JcQueryResult> qrList = this.execute(qList);
        return qrList.get(0);
    }

    @Override
    public List<JcError> clearDatabase() {
        return DBUtil.clearDatabase(this);
    }

    @Override
    public boolean isDatabaseEmpty() {
        return DBUtil.isDatabaseEmpty(this);
    }

    @Override
    public DBType getDBType() {
        return DBType.REMOTE;
    }

    @Override
    public void close() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    @Override
    public void initialize(Properties properties) {
        this.properties = properties;
        if (this.properties.getProperty("server_root_uri") == null) {
            throw new RuntimeException("missing property: 'server_root_uri' in database configuration");
        }
    }
}

