/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.remote;

import iot.jcypher.database.internal.DBUtil;
import iot.jcypher.database.remote.AbstractRemoteDBAccess;
import iot.jcypher.database.remote.BoltTransactionImpl;
import iot.jcypher.database.util.QParamsUtil;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.writer.CypherWriter;
import iot.jcypher.query.writer.QueryParam;
import iot.jcypher.query.writer.WriterContext;
import iot.jcypher.transaction.ITransaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;

public class BoltDBAccess
extends AbstractRemoteDBAccess {
    private static final String pathPrefix = "://";
    private static final String bolt = "bolt";
    private ThreadLocal<BoltTransactionImpl> transaction = new ThreadLocal();
    private AuthToken authToken;
    private Driver driver;
    private Session session;

    public BoltDBAccess() {
        this.shutdownHook = BoltDBAccess.registerShutdownHook(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JcQueryResult> execute(List<JcQuery> queries) {
        ArrayList<Statement> statements = new ArrayList<Statement>(queries.size());
        for (JcQuery query : queries) {
            WriterContext context = new WriterContext();
            QueryParam.setExtractParams(query.isExtractParams(), context);
            CypherWriter.toCypherExpression(query, context);
            String cypher = context.buffer.toString();
            Map<String, Object> paramsMap = QParamsUtil.createQueryParams(context);
            statements.add(new Statement(cypher, paramsMap));
        }
        BoltTransactionImpl btx = this.transaction.get();
        Transaction tx = btx != null ? btx.getTransaction() : this.getSession().beginTransaction();
        Throwable dbException = null;
        ArrayList<JcQueryResult> ret = new ArrayList<JcQueryResult>(queries.size());
        try {
            for (Statement statement : statements) {
                StatementResult result = statement.parameterMap != null ? tx.run(statement.cypher, statement.parameterMap) : tx.run(statement.cypher);
                ret.add(new JcQueryResult(result, this));
            }
            if (btx == null) {
                tx.success();
            }
        }
        catch (Throwable e) {
            dbException = e;
            if (btx != null) {
                btx.failure();
            }
            tx.failure();
        }
        finally {
            if (btx == null && tx != null) {
                try {
                    tx.close();
                }
                catch (Throwable e1) {
                    dbException = e1;
                }
            }
        }
        if (dbException != null) {
            String typ = dbException.getClass().getSimpleName();
            String msg = dbException.getLocalizedMessage();
            JcError err = new JcError(typ, msg, DBUtil.getStacktrace(dbException));
            if (ret.size() < queries.size()) {
                for (int i = ret.size(); i < queries.size(); ++i) {
                    JcQueryResult res = new JcQueryResult(null, this);
                    res.getDBErrors().add(err);
                    ret.add(res);
                }
            } else {
                JcQueryResult res = (JcQueryResult)ret.get(ret.size() - 1);
                res.getDBErrors().add(err);
            }
        }
        return ret;
    }

    @Override
    public ITransaction beginTX() {
        BoltTransactionImpl tx = this.transaction.get();
        if (tx == null) {
            tx = new BoltTransactionImpl(this);
            this.transaction.set(tx);
        }
        return tx;
    }

    @Override
    public ITransaction getTX() {
        return this.transaction.get();
    }

    @Override
    public void setAuth(String userId, String password) {
        if (userId != null && password != null) {
            this.authToken = AuthTokens.basic((String)userId, (String)password);
        }
    }

    @Override
    public void setAuth(AuthToken authToken) {
        this.authToken = authToken;
    }

    void removeTx() {
        this.transaction.remove();
    }

    private Driver getDriver() {
        if (this.driver == null) {
            String uri = this.properties.getProperty("server_root_uri");
            this.driver = this.authToken != null ? GraphDatabase.driver((String)uri, (AuthToken)this.authToken) : GraphDatabase.driver((String)uri);
        }
        return this.driver;
    }

    public synchronized Session getSession() {
        if (this.session == null) {
            this.session = this.getDriver().session();
        }
        return this.session;
    }

    public static boolean isBoltProtocol(String uri) {
        int idx;
        boolean ret = false;
        if (uri != null && (idx = uri.indexOf(pathPrefix)) > 0) {
            String prot = uri.substring(0, idx);
            ret = bolt.equalsIgnoreCase(prot);
        }
        return ret;
    }

    private static Thread registerShutdownHook(final BoltDBAccess bda) {
        Thread hook = new Thread(){

            @Override
            public void run() {
                try {
                    if (bda.session != null) {
                        bda.session.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (bda.driver != null) {
                        bda.driver.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
        return hook;
    }

    private static class Statement {
        private String cypher;
        private Map<String, Object> parameterMap;

        private Statement(String cypher, Map<String, Object> parameterMap) {
            this.cypher = cypher;
            this.parameterMap = parameterMap;
        }
    }
}

