/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.remote;

import iot.jcypher.database.internal.DBUtil;
import iot.jcypher.database.remote.AbstractRemoteDBAccess;
import iot.jcypher.database.remote.RTransactionImpl;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.writer.ContextAccess;
import iot.jcypher.query.writer.JSONWriter;
import iot.jcypher.query.writer.WriterContext;
import iot.jcypher.transaction.ITransaction;
import iot.jcypher.util.Base64CD;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Value;

public class RemoteDBAccess
extends AbstractRemoteDBAccess {
    private static final String transactionalURLPostfix = "db/data/transaction/commit";
    private static final String locationHeader = "Location";
    static final String authHeader = "Authorization";
    private static final String authBasic = "Basic";
    private ThreadLocal<RTransactionImpl> transaction = new ThreadLocal();
    private String auth;
    private Client restClient;
    private WebTarget transactionalTarget;
    private Invocation.Builder invocationBuilder;

    @Override
    public List<JcQueryResult> execute(List<JcQuery> queries) {
        WriterContext context = new WriterContext();
        ContextAccess.getResultDataContents(context).add("rest");
        ContextAccess.getResultDataContents(context).add("graph");
        JSONWriter.toJSON(queries, context);
        String json = context.buffer.toString();
        Response response = null;
        Throwable exception = null;
        RTransactionImpl tx = null;
        tx = this.transaction.get();
        Invocation.Builder iBuilder = tx != null ? tx.getInvocationBuilder() : this.getInvocationBuilder();
        try {
            response = iBuilder.post(Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        }
        catch (Throwable e) {
            exception = e;
            tx = null;
        }
        if (tx != null) {
            String txLocation = response.getHeaderString(locationHeader);
            tx.setTxLocation(txLocation);
        }
        JsonObject jsonResult = null;
        Response.StatusType status = null;
        if (exception == null) {
            status = response.getStatusInfo();
            String result = (String)response.readEntity(String.class);
            if (result != null && result.length() > 0) {
                StringReader sr = new StringReader(result);
                JsonReader reader = Json.createReader((Reader)sr);
                jsonResult = reader.readObject();
            }
        }
        ArrayList<JcQueryResult> ret = new ArrayList<JcQueryResult>(queries.size());
        for (int i = 0; i < queries.size(); ++i) {
            String msg;
            JcQueryResult qr = new JcQueryResult(jsonResult, i, this);
            ret.add(qr);
            if (exception != null) {
                String typ = exception.getClass().getSimpleName();
                msg = exception.getLocalizedMessage();
                qr.addGeneralError(new JcError(typ, msg, DBUtil.getStacktrace(exception)));
                continue;
            }
            if (status == null || status.getStatusCode() < 400) continue;
            String code = String.valueOf(status.getStatusCode());
            msg = status.getReasonPhrase();
            qr.addGeneralError(new JcError(code, msg, null));
        }
        return ret;
    }

    @Override
    public ITransaction beginTX() {
        RTransactionImpl tx = this.transaction.get();
        if (tx == null) {
            tx = new RTransactionImpl(this);
            this.transaction.set(tx);
        }
        return tx;
    }

    @Override
    public ITransaction getTX() {
        return this.transaction.get();
    }

    @Override
    public synchronized void close() {
        super.close();
        if (this.restClient != null) {
            this.restClient.close();
            this.restClient = null;
        }
        this.transactionalTarget = null;
        this.invocationBuilder = null;
    }

    @Override
    public void setAuth(String userId, String password) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(userId);
            sb.append(':');
            sb.append(password);
            byte[] bytes = sb.toString().getBytes("UTF-8");
            sb = new StringBuilder();
            sb.append(authBasic);
            sb.append(' ');
            sb.append(new String(Base64CD.encode(bytes)));
            this.auth = sb.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAuth(AuthToken authToken) {
        Map map;
        Value scheme;
        if (authToken instanceof InternalAuthToken && (scheme = (Value)(map = ((InternalAuthToken)authToken).toMap()).get("scheme")) != null && "basic".equals(scheme.asString())) {
            String pw;
            String uid = map.get("principal") != null ? ((Value)map.get("principal")).asString() : null;
            String string = pw = map.get("credentials") != null ? ((Value)map.get("credentials")).asString() : null;
            if (uid != null && pw != null) {
                this.setAuth(uid, pw);
            }
        }
    }

    public String getAuth() {
        return this.auth;
    }

    synchronized Client getRestClient() {
        if (this.restClient == null) {
            this.restClient = ClientBuilder.newClient();
            this.shutdownHook = RemoteDBAccess.registerShutdownHook(this.restClient);
        }
        return this.restClient;
    }

    String getServerRootUri() {
        return this.properties.getProperty("server_root_uri");
    }

    void removeTx() {
        this.transaction.remove();
    }

    private synchronized WebTarget getTransactionalTarget() {
        if (this.transactionalTarget == null) {
            WebTarget serverRootTarget = this.getRestClient().target(this.properties.getProperty("server_root_uri"));
            this.transactionalTarget = serverRootTarget.path(transactionalURLPostfix);
        }
        return this.transactionalTarget;
    }

    private synchronized Invocation.Builder getInvocationBuilder() {
        if (this.invocationBuilder == null) {
            this.invocationBuilder = this.getTransactionalTarget().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            if (this.auth != null) {
                this.invocationBuilder = this.invocationBuilder.header(authHeader, (Object)this.auth);
            }
        }
        return this.invocationBuilder;
    }

    private static Thread registerShutdownHook(final Client client) {
        Thread hook = new Thread(){

            @Override
            public void run() {
                try {
                    client.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
        return hook;
    }
}

