/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.domain.DomainAccessFactory;
import iot.jcypher.domain.IDomainAccess;
import iot.jcypher.domain.IGenericDomainAccess;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrProperty;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.factories.clause.MATCH;
import iot.jcypher.query.factories.clause.RETURN;
import iot.jcypher.query.factories.clause.START;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.result.JcResultException;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.util.Util;
import java.util.ArrayList;
import java.util.List;

public class DomainInformation {
    private static final String DomainInfoNodeLabel = "DomainInfo";
    private static final String DomainInfoNameProperty = "name";
    private static final String DomainInfoLabel2ClassProperty = "label2ClassMap";
    private IDBAccess dbAccess;
    private String domainName;
    private Long infoNodeId;
    private IDomainAccess domainAccess;

    private DomainInformation(IDBAccess dbAccess, String domainName) {
        this.dbAccess = dbAccess;
        this.domainName = domainName;
    }

    public static List<String> availableDomains(IDBAccess dbAccess) {
        List<GrNode> resultList = DomainInformation.loadAllDomainInfoNodes(dbAccess);
        ArrayList<String> domains = new ArrayList<String>();
        for (GrNode rNode : resultList) {
            domains.add(rNode.getProperty(DomainInfoNameProperty).getValue().toString());
        }
        return domains;
    }

    public static DomainInformation forDomain(IDBAccess dbAccess, String domainName) {
        return new DomainInformation(dbAccess, domainName);
    }

    public List<DomainObjectType> getDomainObjectTypes() {
        ArrayList<DomainObjectType> resultList = new ArrayList<DomainObjectType>();
        GrNode infoNode = this.loadDomainInfoNode();
        GrProperty prop = infoNode.getProperty(DomainInfoLabel2ClassProperty);
        if (prop != null) {
            List val = (List)prop.getValue();
            for (String str : val) {
                String[] c2l = str.split("=");
                resultList.add(new DomainObjectType(c2l[1], c2l[0]));
            }
        }
        return resultList;
    }

    public List<String> getDomainObjectTypeNames() {
        List<DomainObjectType> types = this.getDomainObjectTypes();
        ArrayList<String> typeNames = new ArrayList<String>(types.size());
        for (DomainObjectType typ : types) {
            typeNames.add(typ.getTypeName());
        }
        return typeNames;
    }

    public List<Class<?>> getRawTypes(List<DomainObjectType> types) {
        ArrayList resultList = new ArrayList();
        for (DomainObjectType type : types) {
            resultList.add(type.getType());
        }
        return resultList;
    }

    public IDomainAccess getDomainAccess() {
        if (this.domainAccess == null) {
            this.domainAccess = DomainAccessFactory.createDomainAccess(this.dbAccess, this.domainName);
        }
        return this.domainAccess;
    }

    public IGenericDomainAccess getGenericDomainAccess() {
        return this.getDomainAccess().getGenericDomainAccess();
    }

    private GrNode loadDomainInfoNode() {
        GrNode infoNode = null;
        if (this.infoNodeId == null) {
            List<GrNode> resultList = DomainInformation.loadAllDomainInfoNodes(this.dbAccess);
            for (GrNode rNode : resultList) {
                if (!this.domainName.equals(rNode.getProperty(DomainInfoNameProperty).getValue().toString())) continue;
                infoNode = rNode;
                this.infoNodeId = new Long(rNode.getId());
            }
        } else {
            JcNode n = new JcNode("n");
            JcQuery query = new JcQuery();
            query.setClauses(new IClause[]{START.node(n).byId(this.infoNodeId), RETURN.value(n)});
            JcQueryResult result = this.dbAccess.execute(query);
            List<JcError> errors = Util.collectErrors(result);
            if (errors.size() > 0) {
                throw new JcResultException(errors);
            }
            List<GrNode> resultList = result.resultOf(n);
            infoNode = resultList.get(0);
        }
        return infoNode;
    }

    private static List<GrNode> loadAllDomainInfoNodes(IDBAccess dbAccess) {
        JcNode n = new JcNode("n");
        JcQuery query = new JcQuery();
        query.setClauses(new IClause[]{MATCH.node(n).label(DomainInfoNodeLabel), RETURN.value(n)});
        JcQueryResult result = dbAccess.execute(query);
        List<JcError> errors = Util.collectErrors(result);
        if (errors.size() > 0) {
            throw new JcResultException(errors);
        }
        return result.resultOf(n);
    }

    public class DomainObjectType {
        private String typeName;
        private String nodeLabel;
        private Class<?> type;

        private DomainObjectType(String typeName, String nodeLabel) {
            this.typeName = typeName;
            this.nodeLabel = nodeLabel;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getNodeLabel() {
            return this.nodeLabel;
        }

        public Class<?> getType() {
            if (this.type == null) {
                try {
                    this.type = Class.forName(this.typeName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.type;
        }

        public String toString() {
            return "DomainObjectType [typeName=" + this.typeName + "]";
        }
    }
}

