/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.genericmodel;

import iot.jcypher.domain.genericmodel.DOType;
import iot.jcypher.domain.genericmodel.internal.DomainModel;
import java.lang.reflect.Field;
import java.util.List;

public class DOField {
    public static String COMPONENTTYPE_Object = "java.lang.Object";
    public static String LIST_TYPE = "java.util.List";
    private String name;
    private String typeName;
    private String componentTypeName;
    private boolean buidInType;
    private DOType ownerType;
    private Field field;

    DOField(String name, String typeName, boolean isList, DOType ownerType) {
        this.name = name;
        this.typeName = isList ? LIST_TYPE : typeName;
        this.buidInType = DomainModel.isBuildIn(this.typeName);
        this.ownerType = ownerType;
        if (isList) {
            this.componentTypeName = typeName != null ? typeName : COMPONENTTYPE_Object;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getComponentTypeName() {
        return this.componentTypeName;
    }

    public boolean isBuidInType() {
        return this.buidInType;
    }

    public boolean isListOrArray() {
        return this.field.getType().isArray() || List.class.isAssignableFrom(this.field.getType());
    }

    void setComponentTypeName(String componentTypeName) {
        this.componentTypeName = componentTypeName;
    }

    void setValue(Object target, Object value) {
        try {
            this.getField().set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    Object getValue(Object target) {
        try {
            return this.getField().get(target);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public String asString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(this.name);
        sb.append(" : ");
        sb.append(this.typeName);
        sb.append(" (buildIn: ");
        sb.append(this.buidInType);
        sb.append(')');
        if (this.componentTypeName != null) {
            sb.append('[');
            sb.append(this.componentTypeName);
            sb.append(']');
        }
        return sb.toString();
    }

    private Field getField() {
        if (this.field == null) {
            try {
                Class<?> rawType = this.ownerType.getRawType();
                this.field = rawType.getDeclaredField(this.name);
                this.field.setAccessible(true);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return this.field;
    }
}

