/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.internal;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.domain.IDomainAccess;
import iot.jcypher.domain.IDomainAccessFactory;
import iot.jcypher.domain.IGenericDomainAccess;
import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.domain.internal.DomainAccessSync;

public class DomainAccessFactoryImpl
implements IDomainAccessFactory {
    private SyncType syncType;

    public DomainAccessFactoryImpl(SyncType st) {
        this.syncType = st;
    }

    @Override
    public IDomainAccess createDomainAccess(IDBAccess dbAccess, String domainName) {
        if (this.syncType == SyncType.NONE) {
            return new DomainAccess(dbAccess, domainName, IDomainAccess.DomainLabelUse.AUTO);
        }
        return new DomainAccessSync(dbAccess, domainName, IDomainAccess.DomainLabelUse.AUTO, this.syncType);
    }

    @Override
    public IDomainAccess createDomainAccess(IDBAccess dbAccess, String domainName, IDomainAccess.DomainLabelUse domainLabelUse) {
        if (this.syncType == SyncType.NONE) {
            return new DomainAccess(dbAccess, domainName, domainLabelUse);
        }
        return new DomainAccessSync(dbAccess, domainName, domainLabelUse, this.syncType);
    }

    @Override
    public IGenericDomainAccess createGenericDomainAccess(IDBAccess dbAccess, String domainName) {
        if (this.syncType == SyncType.NONE) {
            return new DomainAccess(dbAccess, domainName, IDomainAccess.DomainLabelUse.AUTO).getGenericDomainAccess();
        }
        return new DomainAccessSync(dbAccess, domainName, IDomainAccess.DomainLabelUse.AUTO, this.syncType).getGenericDomainAccess();
    }

    @Override
    public IGenericDomainAccess createGenericDomainAccess(IDBAccess dbAccess, String domainName, IDomainAccess.DomainLabelUse domainLabelUse) {
        if (this.syncType == SyncType.NONE) {
            return new DomainAccess(dbAccess, domainName, domainLabelUse).getGenericDomainAccess();
        }
        return new DomainAccessSync(dbAccess, domainName, domainLabelUse, this.syncType).getGenericDomainAccess();
    }

    public static enum SyncType {
        NONE,
        SYNCHRONIZED;

    }
}

