/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping;

import iot.jcypher.domain.genericmodel.internal.DomainModel;
import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.domain.mapping.ArraySurrogateField;
import iot.jcypher.domain.mapping.DirectField;
import iot.jcypher.domain.mapping.FieldMapping;
import iot.jcypher.domain.mapping.IField;
import iot.jcypher.domain.mapping.ListFieldMapping;
import iot.jcypher.domain.mapping.MappingUtil;
import iot.jcypher.domain.mapping.NodeLabelMapping;
import iot.jcypher.domain.mapping.ObjectMapping;
import iot.jcypher.domain.mapping.SimpleObjectMapping;
import iot.jcypher.domain.mapping.ValueAndTypeMapping;
import iot.jcypher.domain.mapping.surrogate.Array;
import iot.jcypher.domain.mapping.surrogate.Collection;
import iot.jcypher.domain.mapping.surrogate.Map;
import iot.jcypher.domain.mapping.surrogate.MapEntry;
import iot.jcypher.domain.mapping.surrogate.SurrogateField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class DefaultObjectMappingCreator {
    private static final String ValueField = "value";

    public static ObjectMapping createObjectMapping(Class<?> toMap, DomainModel dm) {
        SimpleObjectMapping objectMapping = new SimpleObjectMapping();
        NodeLabelMapping labelMapping = DefaultObjectMappingCreator.createLabelMapping(toMap);
        objectMapping.setNodeLabelMapping(labelMapping);
        Class<?> clazz = toMap;
        while (!Object.class.equals(clazz)) {
            dm.addType(clazz);
            DefaultObjectMappingCreator.addFieldMappings(objectMapping, clazz);
            clazz = clazz.getSuperclass();
        }
        return objectMapping;
    }

    private static void addFieldMappings(SimpleObjectMapping objectMapping, Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Modifier.isTransient(fields[i].getModifiers())) continue;
            FieldMapping.FieldKind fieldKind = FieldMapping.getFieldKind(fields[i].getType());
            IField field = fieldKind == FieldMapping.FieldKind.MAP && !fields[i].getDeclaringClass().equals(Map.class) ? new SurrogateField(fields[i]) : (fieldKind == FieldMapping.FieldKind.COLLECTION && !fields[i].getDeclaringClass().equals(Collection.class) ? new SurrogateField(fields[i]) : (fieldKind == FieldMapping.FieldKind.ARRAY && !fields[i].getDeclaringClass().equals(Array.class) ? new SurrogateField(fields[i]) : (clazz.equals(Array.class) ? new ArraySurrogateField(fields[i]) : new DirectField(fields[i]))));
            FieldMapping fieldMapping = clazz.equals(MapEntry.class) && fields[i].getName().equals(ValueField) ? new ValueAndTypeMapping(field) : (clazz.equals(Collection.class) && fields[i].getName().equals("c_content") ? new ListFieldMapping(field) : (clazz.equals(Array.class) ? new ListFieldMapping(field) : new FieldMapping(field)));
            objectMapping.addFieldMapping(fieldMapping);
        }
    }

    public static NodeLabelMapping createLabelMapping(Class<?> toMap) {
        DomainAccess.InternalDomainAccess dAccess = MappingUtil.internalDomainAccess.get();
        String label = dAccess.getLabelForClass(toMap);
        if (label == null) {
            String fullName = toMap.getName();
            StringBuilder sb = new StringBuilder();
            int idx = fullName.length() - 1;
            do {
                char c;
                if (sb.length() > 0 && idx >= 0) {
                    sb.insert(0, '_');
                    --idx;
                }
                while (idx >= 0 && (c = fullName.charAt(idx)) != '.') {
                    sb.insert(0, c);
                    --idx;
                }
            } while (dAccess.existsLabel(label = sb.toString()));
        }
        NodeLabelMapping labelMapping = new NodeLabelMapping(label);
        return labelMapping;
    }
}

