/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping;

import iot.jcypher.domain.ResolutionDepth;
import iot.jcypher.domain.genericmodel.DomainObject;
import iot.jcypher.domain.mapping.surrogate.InnerClassSurrogate;
import iot.jcypher.domain.mapping.surrogate.SurrogateState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class DomainState {
    private Map<Object, LoadInfo> object2IdMap = new HashMap<Object, LoadInfo>();
    private Map<IRelation, RelationLoadInfo> relation2IdMap = new HashMap<IRelation, RelationLoadInfo>();
    private Map<Long, Object> id2ObjectMap = new HashMap<Long, Object>();
    private Map<Object, List<IRelation>> object2RelationsMap = new HashMap<Object, List<IRelation>>();
    private Map<SourceField2TargetKey, List<KeyedRelation>> objectField2KeyedRelationsMap = new HashMap<SourceField2TargetKey, List<KeyedRelation>>();
    private Map<SourceFieldKey, List<KeyedRelation>> multiRelationsMap = new HashMap<SourceFieldKey, List<KeyedRelation>>();
    private SurrogateState surrogateState = new SurrogateState();

    public DomainState createCopy() {
        DomainState ret = new DomainState();
        for (Map.Entry<Object, LoadInfo> entry : this.object2IdMap.entrySet()) {
            ret.object2IdMap.put(entry.getKey(), entry.getValue().createCopy());
        }
        IdentityHashMap<IRelation, IRelation> copiedRels = new IdentityHashMap<IRelation, IRelation>();
        for (Map.Entry<IRelation, RelationLoadInfo> entry : this.relation2IdMap.entrySet()) {
            ret.relation2IdMap.put(this.copyRelation(entry.getKey(), copiedRels), entry.getValue().createCopy());
        }
        for (Map.Entry<Long, Object> entry : this.id2ObjectMap.entrySet()) {
            ret.id2ObjectMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, List<IRelation>> entry : this.object2RelationsMap.entrySet()) {
            ret.object2RelationsMap.put(entry.getKey(), this.copyRelationsList(entry.getValue(), copiedRels));
        }
        IdentityHashMap<SourceField2TargetKey, SourceField2TargetKey> copiedSftks = new IdentityHashMap<SourceField2TargetKey, SourceField2TargetKey>();
        for (Map.Entry<SourceField2TargetKey, List<KeyedRelation>> entry : this.objectField2KeyedRelationsMap.entrySet()) {
            ret.objectField2KeyedRelationsMap.put(this.copySftks(entry.getKey(), copiedSftks), this.copyRelationsList(entry.getValue(), copiedRels));
        }
        IdentityHashMap<SourceFieldKey, SourceFieldKey> copiedSfks = new IdentityHashMap<SourceFieldKey, SourceFieldKey>();
        for (Map.Entry<SourceFieldKey, List<KeyedRelation>> entry : this.multiRelationsMap.entrySet()) {
            ret.multiRelationsMap.put(this.copySfks(entry.getKey(), copiedSfks), this.copyRelationsList(entry.getValue(), copiedRels));
        }
        ret.surrogateState = this.surrogateState.createCopy(copiedRels, ret);
        return ret;
    }

    private SourceFieldKey copySfks(SourceFieldKey toCopy, Map<SourceFieldKey, SourceFieldKey> copiedSfks) {
        SourceFieldKey ret = copiedSfks.get(toCopy);
        if (ret == null) {
            ret = new SourceFieldKey(toCopy.getSource(), toCopy.getFieldName());
            copiedSfks.put(toCopy, ret);
        }
        return ret;
    }

    private SourceField2TargetKey copySftks(SourceField2TargetKey toCopy, Map<SourceField2TargetKey, SourceField2TargetKey> copiedSftks) {
        SourceField2TargetKey ret = copiedSftks.get(toCopy);
        if (ret == null) {
            SourceFieldKey sfk = toCopy.getSourceFieldKey();
            ret = new SourceField2TargetKey(sfk.getSource(), sfk.getFieldName(), toCopy.getTarget());
            copiedSftks.put(toCopy, ret);
        }
        return ret;
    }

    private <T extends IRelation> T copyRelation(T toCopy, Map<IRelation, IRelation> copiedRels) {
        IRelation crel = copiedRels.get(toCopy);
        if (crel == null) {
            crel = toCopy.createCopy(this);
            copiedRels.put(toCopy, crel);
        }
        return (T)crel;
    }

    private <T extends IRelation> List<T> copyRelationsList(List<T> toCopy, Map<IRelation, IRelation> copiedRels) {
        ArrayList<IRelation> ret = null;
        if (toCopy != null) {
            ret = new ArrayList<IRelation>();
            for (IRelation rel : toCopy) {
                ret.add(this.copyRelation(rel, copiedRels));
            }
        }
        return ret;
    }

    private void addTo_Object2IdMap(Object key, Long value, int version, ResolutionDepth resolutionDepth) {
        LoadInfo loadInfo = new LoadInfo();
        loadInfo.id = value;
        loadInfo.version = version;
        loadInfo.resolutionDepth = resolutionDepth;
        this.object2IdMap.put(key, loadInfo);
    }

    public ResolutionDepth getResolutionDepth(Object key) {
        LoadInfo loadInfo = this.object2IdMap.get(key);
        if (loadInfo != null) {
            return loadInfo.resolutionDepth;
        }
        return null;
    }

    public Long getIdFrom_Object2IdMap(Object key) {
        LoadInfo loadInfo = this.object2IdMap.get(key);
        if (loadInfo != null) {
            return loadInfo.id;
        }
        return null;
    }

    public LoadInfo getLoadInfoFrom_Object2IdMap(Object key) {
        return this.object2IdMap.get(key);
    }

    public void add_Id2Relation(IRelation relat, Long id, int version) {
        RelationLoadInfo rli = new RelationLoadInfo();
        rli.id = id;
        rli.version = version;
        this.add_Info2Relation(relat, rli);
    }

    public void add_Info2Relation(IRelation relat, RelationLoadInfo rli) {
        if (!relat.isDeferred()) {
            IRelation toPut = relat;
            if (relat instanceof KeyedRelationToChange) {
                SourceFieldKey fieldKey;
                KeyedRelation oldOne = ((KeyedRelationToChange)relat).existingOne;
                this.relation2IdMap.remove(oldOne);
                SourceField2TargetKey key = new SourceField2TargetKey(oldOne.getStart(), oldOne.getType(), oldOne.getEnd());
                List<KeyedRelation> rels = this.objectField2KeyedRelationsMap.get(key);
                if (rels != null) {
                    rels.remove(oldOne);
                }
                if ((rels = this.multiRelationsMap.get(fieldKey = key.getSourceFieldKey())) != null) {
                    rels.remove(oldOne);
                }
                KeyedRelation newOne = ((KeyedRelationToChange)relat).getNewOne();
                toPut = newOne;
            }
            this.relation2IdMap.put(toPut, rli);
            if (toPut instanceof KeyedRelation) {
                SourceFieldKey fieldKey;
                SourceField2TargetKey key = new SourceField2TargetKey(toPut.getStart(), toPut.getType(), toPut.getEnd());
                List<KeyedRelation> rels = this.objectField2KeyedRelationsMap.get(key);
                if (rels == null) {
                    rels = new ArrayList<KeyedRelation>();
                    this.objectField2KeyedRelationsMap.put(key, rels);
                }
                if (!rels.contains(toPut)) {
                    rels.add((KeyedRelation)toPut);
                }
                if ((rels = this.multiRelationsMap.get(fieldKey = key.getSourceFieldKey())) == null) {
                    rels = new ArrayList<KeyedRelation>();
                    this.multiRelationsMap.put(fieldKey, rels);
                }
                if (!rels.contains(toPut)) {
                    rels.add((KeyedRelation)toPut);
                }
            } else {
                List<IRelation> rels = this.object2RelationsMap.get(toPut.getStart());
                if (rels == null) {
                    rels = new ArrayList<IRelation>();
                    this.object2RelationsMap.put(toPut.getStart(), rels);
                }
                if (!rels.contains(toPut)) {
                    rels.add(toPut);
                }
            }
        } else {
            relat.setDomainState(this);
            relat.setId(rli.id);
        }
    }

    public RelationLoadInfo getFrom_Relation2IdMap(IRelation relat) {
        IRelation key = relat instanceof KeyedRelationToChange ? ((KeyedRelationToChange)relat).existingOne : relat;
        return this.relation2IdMap.get(key);
    }

    public void addTo_Id2ObjectMap(Object obj, Long id) {
        this.id2ObjectMap.put(id, obj);
    }

    public void add_Id2Object(Object obj, Long id, int version, ResolutionDepth resolutionDepth) {
        this.addTo_Id2ObjectMap(obj, id);
        this.addTo_Object2IdMap(obj, id, version, resolutionDepth);
    }

    public void replace_Id2Object(Object old, Object obj, Long id) {
        this.addTo_Id2ObjectMap(obj, id);
        LoadInfo li = this.object2IdMap.remove(old);
        this.addTo_Object2IdMap(obj, id, li.version, li.resolutionDepth);
    }

    public boolean existsRelation(IRelation relat) {
        List<IRelation> rels = this.object2RelationsMap.get(relat.getStart());
        if (rels != null) {
            for (IRelation r : rels) {
                if (!r.equals(relat)) continue;
                return true;
            }
        }
        return false;
    }

    public List<KeyedRelation> getKeyedRelations(SourceField2TargetKey key) {
        return this.objectField2KeyedRelationsMap.get(key);
    }

    public List<KeyedRelation> getKeyedRelations(SourceFieldKey key) {
        return this.multiRelationsMap.get(key);
    }

    public IRelation findRelation(Object start, String type) {
        List<IRelation> rels = this.object2RelationsMap.get(start);
        if (rels != null) {
            for (IRelation r : rels) {
                if (!r.getType().equals(type)) continue;
                return r;
            }
        }
        return null;
    }

    public void removeRelation(IRelation relat) {
        if (relat instanceof KeyedRelation) {
            SourceFieldKey fieldKey;
            SourceField2TargetKey key = new SourceField2TargetKey(relat.getStart(), relat.getType(), relat.getEnd());
            List<KeyedRelation> rels = this.objectField2KeyedRelationsMap.get(key);
            if (rels != null) {
                rels.remove(relat);
            }
            if ((rels = this.multiRelationsMap.get(fieldKey = key.getSourceFieldKey())) != null) {
                rels.remove(relat);
            }
        } else {
            List<IRelation> rels = this.object2RelationsMap.get(relat.getStart());
            if (rels != null) {
                rels.remove(relat);
            }
        }
        this.relation2IdMap.remove(relat);
    }

    public Object getFrom_Id2ObjectMap(Long id) {
        return this.id2ObjectMap.get(id);
    }

    public SurrogateState getSurrogateState() {
        return this.surrogateState;
    }

    public static class LoadInfo {
        private Long id;
        private int version;
        private ResolutionDepth resolutionDepth;
        private DomainObject domainObject;

        private LoadInfo createCopy() {
            LoadInfo ret = new LoadInfo();
            ret.id = this.id;
            ret.version = this.version;
            ret.resolutionDepth = this.resolutionDepth;
            ret.domainObject = this.domainObject;
            return ret;
        }

        public Long getId() {
            return this.id;
        }

        public int getVersion() {
            return this.version;
        }

        public ResolutionDepth getResolutionDepth() {
            return this.resolutionDepth;
        }

        public LoadInfo setResolutionDepth(ResolutionDepth resolutionDepth) {
            this.resolutionDepth = resolutionDepth;
            return this;
        }

        public void setVersion(int v) {
            this.version = v;
        }

        public DomainObject getDomainObject() {
            return this.domainObject;
        }

        public void setDomainObject(DomainObject domainObject) {
            this.domainObject = domainObject;
        }
    }

    public static class RelationLoadInfo {
        private Long id;
        private int version;

        private RelationLoadInfo createCopy() {
            RelationLoadInfo ret = new RelationLoadInfo();
            ret.id = this.id;
            ret.version = this.version;
            return ret;
        }

        public Long getId() {
            return this.id;
        }

        public int getVersion() {
            return this.version;
        }
    }

    public static class SourceFieldKey {
        private Object source;
        private String fieldName;

        public SourceFieldKey(Object src, String fieldName) {
            this.source = src;
            this.fieldName = fieldName;
        }

        public Object getSource() {
            return this.source;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceFieldKey other = (SourceFieldKey)obj;
            if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }
    }

    public static class SourceField2TargetKey {
        private Object source;
        private String fieldName;
        private Object target;

        public SourceField2TargetKey(Object src, String fieldName, Object target) {
            this.source = src;
            this.fieldName = fieldName;
            this.target = target;
        }

        public SourceField2TargetKey(SourceFieldKey sfk, Object target) {
            this.source = sfk.getSource();
            this.fieldName = sfk.getFieldName();
            this.target = target;
        }

        public Object getTarget() {
            return this.target;
        }

        public SourceFieldKey getSourceFieldKey() {
            return new SourceFieldKey(this.source, this.fieldName);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceField2TargetKey other = (SourceField2TargetKey)obj;
            if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            return !(this.target == null ? other.target != null : !this.target.equals(other.target));
        }
    }

    public static class KeyedRelationToChange
    implements IRelation {
        private KeyedRelation existingOne;
        private KeyedRelation newOne;

        public KeyedRelationToChange(KeyedRelation existingOne, KeyedRelation newOne) {
            this.existingOne = existingOne;
            this.newOne = newOne;
        }

        @Override
        public IRelation createCopy(DomainState ds) {
            KeyedRelationToChange ret = new KeyedRelationToChange((KeyedRelation)this.existingOne.createCopy(ds), (KeyedRelation)this.newOne.createCopy(ds));
            return ret;
        }

        @Override
        public String getType() {
            return this.existingOne.getType();
        }

        @Override
        public Object getStart() {
            return this.existingOne.getStart();
        }

        @Override
        public Object getEnd() {
            return this.existingOne.getEnd();
        }

        @Override
        public boolean isDeferred() {
            return this.newOne.isDeferred() || this.existingOne.isDeferred();
        }

        @Override
        public void setDomainState(DomainState domainState) {
            if (this.newOne.isDeferred()) {
                this.newOne.setDomainState(domainState);
            }
            if (this.existingOne.isDeferred()) {
                this.existingOne.setDomainState(domainState);
            }
        }

        @Override
        public void setId(long id) {
            if (this.newOne.isDeferred()) {
                this.newOne.setId(id);
            }
            if (this.existingOne.isDeferred()) {
                this.existingOne.setId(id);
            }
        }

        public KeyedRelation getNewOne() {
            return this.newOne;
        }
    }

    public static class KeyedRelation
    extends Relation {
        private Object key;
        private Object value;

        public KeyedRelation(String type, Object key, Object start, Object end) {
            super(type, start, end);
            this.key = key;
        }

        @Override
        public IRelation createCopy(DomainState ds) {
            KeyedRelation ret = new KeyedRelation(this.getType(), this.key, this.getStart(), this.getEnd());
            ret.setDomainState(ds);
            ret.setId(this.getId());
            return ret;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            KeyedRelation other = (KeyedRelation)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        public String toString() {
            return "KeyedRelation [key=" + this.key + ", getType()=" + this.getType() + ", getStart()=" + this.getStart() + ", getEnd()=" + this.getEnd() + "]";
        }
    }

    public static class Relation
    implements IRelation {
        private String type;
        private Object start;
        private Object end;
        private DomainState domainState;
        private long id;

        public Relation(String type, Object start, Object end) {
            this.type = type;
            Object strt = start;
            if (start instanceof InnerClassSurrogate) {
                Object ro = ((InnerClassSurrogate)start).getRealObject();
                if (ro == null) {
                    ((InnerClassSurrogate)start).addRelationUpdate(new RelationUpdate(true));
                } else {
                    strt = ro;
                }
            }
            this.start = strt;
            Object nd = end;
            if (end instanceof InnerClassSurrogate) {
                Object ro = ((InnerClassSurrogate)end).getRealObject();
                if (ro == null) {
                    ((InnerClassSurrogate)end).addRelationUpdate(new RelationUpdate(false));
                } else {
                    nd = ro;
                }
            }
            this.end = nd;
        }

        @Override
        public IRelation createCopy(DomainState ds) {
            Relation ret = new Relation(this.type, this.start, this.end);
            ret.domainState = ds;
            ret.id = this.id;
            return ret;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Object getStart() {
            return this.start;
        }

        @Override
        public Object getEnd() {
            return this.end;
        }

        @Override
        public boolean isDeferred() {
            return this.start instanceof InnerClassSurrogate || this.end instanceof InnerClassSurrogate;
        }

        @Override
        public void setDomainState(DomainState domainState) {
            this.domainState = domainState;
        }

        @Override
        public void setId(long id) {
            this.id = id;
        }

        protected long getId() {
            return this.id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
            result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Relation other = (Relation)obj;
            if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
                return false;
            }
            if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "Relation [type=" + this.type + ", start=" + this.start + ", end=" + this.end + "]";
        }

        public class RelationUpdate {
            private boolean start;

            private RelationUpdate(boolean start) {
                this.start = start;
            }

            public void updateWith(Object startOrEnd) {
                int v;
                RelationLoadInfo rli = Relation.this.domainState.getFrom_Relation2IdMap(Relation.this);
                int n = v = rli != null ? rli.getVersion() : -1;
                if (this.start) {
                    Relation.this.start = startOrEnd;
                } else {
                    Relation.this.end = startOrEnd;
                }
                Relation.this.domainState.add_Id2Relation(Relation.this, Relation.this.id, v);
            }
        }
    }

    public static interface IRelation {
        public String getType();

        public Object getStart();

        public Object getEnd();

        public void setDomainState(DomainState var1);

        public void setId(long var1);

        public IRelation createCopy(DomainState var1);

        public boolean isDeferred();
    }
}

