/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping;

import iot.jcypher.domain.mapping.CompoundObjectType;
import iot.jcypher.domain.mapping.IField;
import iot.jcypher.domain.mapping.MappingUtil;
import iot.jcypher.domain.mapping.surrogate.Collection;
import iot.jcypher.domain.mapping.surrogate.InnerClassSurrogate;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrProperty;
import java.util.Map;

public class FieldMapping {
    public static final String ClassFieldSeparator = "|";
    private static final transient String InnerRefField = "this$";
    private IField field;
    private String fieldName;
    protected String propertyName;
    private String classFieldName;

    public FieldMapping(IField field) {
        this(field, field.getName());
    }

    public FieldMapping(IField field, String propertyName) {
        this.field = field;
        this.field.setAccessible(true);
        this.propertyName = propertyName;
    }

    public boolean isInnerClassRefField() {
        return this.getFieldName().startsWith(InnerRefField);
    }

    public void mapPropertyFromField(Object domainObject, GrNode rNode) {
        this.intMapPropertyFromField(domainObject, rNode);
    }

    protected Object intMapPropertyFromField(Object domainObject, GrNode rNode) {
        Object ret = null;
        try {
            this.prepare(domainObject);
            if (this.getObjectNeedingRelation(domainObject) == null) {
                Object value;
                ret = value = this.field.get(domainObject);
                Object mappedValue = MappingUtil.convertToProperty(value);
                GrProperty prop = rNode.getProperty(this.propertyName);
                if (mappedValue != null) {
                    boolean propModified = false;
                    if (prop != null) {
                        Object propValue = MappingUtil.convertFromProperty(prop.getValue(), mappedValue.getClass(), this.getComponentType(rNode), this.getConcreteFieldType());
                        if (!propValue.equals(mappedValue)) {
                            prop.setValue(mappedValue);
                            propModified = true;
                        }
                    } else {
                        rNode.addProperty(this.propertyName, mappedValue);
                        propModified = true;
                    }
                    if (propModified) {
                        this.storeSimpleListComponentType(value, rNode);
                    }
                } else if (prop != null) {
                    prop.setValue(null);
                }
            } else {
                GrProperty prop;
                boolean clearAdditional = false;
                if (java.util.Collection.class.isAssignableFrom(this.getFieldType()) || this.getFieldType().isArray()) {
                    prop = rNode.getProperty(this.propertyName);
                    if (prop != null) {
                        prop.setValue(null);
                    }
                    clearAdditional = true;
                }
                if (Map.class.isAssignableFrom(this.getFieldType())) {
                    prop = rNode.getProperty(this.propertyName);
                    if (prop != null) {
                        prop.setValue(null);
                    }
                    clearAdditional = true;
                }
                if (clearAdditional) {
                    this.clearAdditionalProperties(rNode);
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    protected void clearAdditionalProperties(GrNode rNode) {
    }

    public boolean mapPropertyToField(Object domainObject, GrNode rNode) {
        boolean hasProperty = false;
        if (domainObject instanceof InnerClassSurrogate) {
            hasProperty = ((InnerClassSurrogate)domainObject).addPropertyChild(this, domainObject, rNode);
        } else {
            try {
                this.prepare(domainObject);
                Object value = this.field.get(domainObject);
                GrProperty prop = rNode.getProperty(this.propertyName);
                if (prop != null) {
                    Class<?> typ;
                    hasProperty = true;
                    Object propValue = prop.getValue();
                    if (propValue != null && !(propValue = MappingUtil.convertFromProperty(propValue, typ = this.getFieldTypeInt(rNode), this.getComponentType(rNode), this.getConcreteFieldType())).equals(value)) {
                        this.field.set(domainObject, this.convertFieldValue(propValue, domainObject));
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return hasProperty;
    }

    protected Object convertFieldValue(Object val, Object domainObject) {
        Object ret = val;
        if (domainObject instanceof Collection) {
            Collection surrColl = (Collection)domainObject;
            if (this.getFieldName().equals("collType") && surrColl.getContent() != null && val != null) {
                surrColl.setContent((java.util.Collection<Object>)MappingUtil.convertCollection(surrColl.getContent(), val.toString()));
            } else if (this.getFieldName().equals("c_content") && surrColl.getCollType() != null && val != null) {
                ret = MappingUtil.convertCollection((java.util.Collection)val, surrColl.getCollType());
            }
        }
        return ret;
    }

    public void setFieldValue(Object domainObject, Object value) {
        if (domainObject instanceof InnerClassSurrogate) {
            ((InnerClassSurrogate)domainObject).addChild(this, value);
        } else if (value instanceof InnerClassSurrogate) {
            ((InnerClassSurrogate)value).addParent(this, domainObject);
        } else {
            try {
                this.prepare(domainObject);
                this.field.set(domainObject, value);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Object getFieldValue(Object domainObject) {
        try {
            this.prepare(domainObject);
            return this.field.get(domainObject);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Object getObjectNeedingRelation(Object domainObject) {
        Object value = null;
        try {
            this.prepare(domainObject);
            value = this.field.get(domainObject);
            if (value != null && value.getClass().isAnonymousClass()) {
                value = null;
            }
            if (value != null) {
                if (MappingUtil.isSimpleType(value.getClass())) {
                    value = null;
                } else {
                    Map map;
                    Class<?> fieldType = this.field.getType();
                    Object elem = null;
                    boolean testCollOrArray = false;
                    if (java.util.Collection.class.isAssignableFrom(fieldType)) {
                        testCollOrArray = true;
                        java.util.Collection coll = (java.util.Collection)fieldType.cast(value);
                        if (coll.size() > 0) {
                            elem = coll.iterator().next();
                        }
                    }
                    if (fieldType.isArray()) {
                        if (fieldType.getComponentType().isPrimitive()) {
                            value = null;
                        } else {
                            testCollOrArray = true;
                            Object[] array = (Object[])fieldType.cast(value);
                            if (array.length > 0) {
                                elem = array[0];
                            }
                        }
                    }
                    if (testCollOrArray) {
                        if (elem != null) {
                            Class<?> type = elem.getClass();
                            if (MappingUtil.isSimpleType(type)) {
                                value = null;
                            }
                        } else {
                            value = null;
                        }
                    }
                    if (Map.class.isAssignableFrom(fieldType) && (map = (Map)fieldType.cast(value)).isEmpty()) {
                        value = null;
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    public boolean needsRelationOrProperty() {
        return this.field.getType().equals(Object.class) || this.getFieldKind() == FieldKind.MAP || this.getFieldKind() == FieldKind.COLLECTION || this.getFieldKind() == FieldKind.ARRAY;
    }

    public boolean needsRelation() {
        boolean needRelation;
        boolean bl = needRelation = !MappingUtil.mapsToProperty(this.field.getType());
        if (needRelation) {
            String classField = this.getClassFieldName();
            CompoundObjectType cType = MappingUtil.internalDomainAccess.get().getConcreteFieldType(classField);
            if (cType != null && cType.getCType() == CompoundObjectType.CType.SIMPLE) {
                return false;
            }
            if (java.util.Collection.class.isAssignableFrom(this.field.getType()) || this.field.getType().isArray()) {
                cType = MappingUtil.internalDomainAccess.get().getFieldComponentType(classField);
                needRelation = cType != null ? cType.getCType() != CompoundObjectType.CType.SIMPLE : true;
            }
        }
        return needRelation;
    }

    protected void storeSimpleListComponentType(Object value, GrNode rNode) {
    }

    protected Class<?> getComponentType(GrNode rNode) {
        Class<?> compType;
        if (this.getFieldType().isArray() && (compType = this.getFieldType().getComponentType()).isPrimitive()) {
            return compType;
        }
        return null;
    }

    private Class<?> getConcreteFieldType() {
        if (this.getFieldKind() == FieldKind.MAP) {
            String classField = this.getClassFieldName();
            CompoundObjectType cType = MappingUtil.internalDomainAccess.get().getConcreteFieldType(classField);
            if (cType != null) {
                return cType.getType();
            }
        }
        return null;
    }

    public String getPropertyOrRelationName() {
        return this.propertyName;
    }

    public IField getField() {
        return this.field;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    protected Class<?> getFieldTypeInt(GrNode rNode) {
        return this.field.getType();
    }

    public String getFieldName() {
        if (this.fieldName == null) {
            this.fieldName = this.field.getName();
        }
        return this.fieldName;
    }

    private void prepare(Object domainObject) throws NoSuchFieldException, SecurityException {
        if (this.fieldName == null) {
            this.fieldName = this.field.getName();
        }
    }

    public String getClassFieldName() {
        if (this.classFieldName == null) {
            this.classFieldName = this.createClassFieldName();
        }
        return this.classFieldName;
    }

    private String createClassFieldName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field.getDeclaringClass().getName());
        sb.append(ClassFieldSeparator);
        sb.append(this.getFieldName());
        return sb.toString();
    }

    public FieldKind getFieldKind() {
        Class<?> typ = this.field.getType();
        return FieldMapping.getFieldKind(typ);
    }

    public static FieldKind getFieldKind(Class<?> typ) {
        return java.util.Collection.class.isAssignableFrom(typ) ? FieldKind.COLLECTION : (Map.class.isAssignableFrom(typ) ? FieldKind.MAP : (typ.isArray() && !typ.getComponentType().isPrimitive() ? FieldKind.ARRAY : FieldKind.SINGLE));
    }

    protected String getDOClassFieldName() {
        if (this.classFieldName == null) {
            this.classFieldName = this.createClassFieldName();
        }
        return this.classFieldName;
    }

    protected String getDOPropertyOrRelationName() {
        return this.propertyName;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldMapping)) {
            return false;
        }
        FieldMapping other = (FieldMapping)obj;
        return !(this.field == null ? other.getField() != null : !this.field.equals(other.getField()));
    }

    protected Class<?> getTypeFromProperty(GrNode rNode, String propertyName) {
        GrProperty typeProp = rNode.getProperty(propertyName);
        Class<?> clazz = null;
        if (typeProp != null) {
            try {
                clazz = MappingUtil.internalDomainAccess.get().getClassForName(typeProp.getValue().toString());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return clazz;
    }

    public static enum FieldKind {
        SINGLE,
        COLLECTION,
        ARRAY,
        MAP;

    }
}

