/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping;

import iot.jcypher.domain.mapping.FieldMapping;
import iot.jcypher.domain.mapping.IField;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrProperty;
import java.util.Arrays;
import java.util.Collection;

public class ListFieldMapping
extends FieldMapping {
    private static final String TypePostfix = "Type";

    public ListFieldMapping(IField field, String propertyName) {
        super(field, propertyName);
    }

    public ListFieldMapping(IField field) {
        super(field);
    }

    @Override
    protected void storeSimpleListComponentType(Object value, GrNode rNode) {
        Collection<Object> coll = value instanceof Collection ? (Collection)this.getFieldType().cast(value) : Arrays.asList((Object[])value);
        if (coll.size() > 0) {
            Object elem = coll.iterator().next();
            Class<?> type = elem.getClass();
            String propName = this.getPropertyOrRelationName().concat(TypePostfix);
            GrProperty prop = rNode.getProperty(propName);
            String t_value = type.getName();
            if (prop != null) {
                Object propValue = prop.getValue();
                if (!t_value.equals(propValue)) {
                    prop.setValue(t_value);
                }
            } else {
                rNode.addProperty(propName, t_value);
            }
        }
    }

    @Override
    protected void clearAdditionalProperties(GrNode rNode) {
        String propName = this.getPropertyOrRelationName().concat(TypePostfix);
        GrProperty prop = rNode.getProperty(propName);
        if (prop != null) {
            prop.setValue(null);
        }
    }

    @Override
    protected Class<?> getComponentType(GrNode rNode) {
        String propName = this.getPropertyOrRelationName().concat(TypePostfix);
        Class<?> clazz = this.getTypeFromProperty(rNode, propName);
        return clazz;
    }
}

