/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping;

import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.query.values.JcBoolean;
import iot.jcypher.query.values.JcNumber;
import iot.jcypher.query.values.JcPrimitive;
import iot.jcypher.query.values.JcString;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class MappingUtil {
    public static ThreadLocal<DomainAccess.InternalDomainAccess> internalDomainAccess = new ThreadLocal();
    private static SimpleDateFormat simpleDateFormat;

    public static String dateToString(java.util.Date date) {
        return MappingUtil.getSimpleDateFormat().format(date);
    }

    public static java.util.Date stringToDate(String date, Class<?> dateType) {
        try {
            java.util.Date dat = MappingUtil.getSimpleDateFormat().parse(date);
            if (dateType.equals(Date.class)) {
                return new Date(dat.getTime());
            }
            if (dateType.equals(Time.class)) {
                return new Time(dat.getTime());
            }
            if (dateType.equals(Timestamp.class)) {
                return new Timestamp(dat.getTime());
            }
            return dat;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static long dateToLong(java.util.Date date) {
        return date.getTime();
    }

    public static java.util.Date longToDate(long millis, Class<?> dateType) {
        if (dateType.equals(Date.class)) {
            return new Date(millis);
        }
        if (dateType.equals(Time.class)) {
            return new Time(millis);
        }
        if (dateType.equals(Timestamp.class)) {
            return new Timestamp(millis);
        }
        return new java.util.Date(millis);
    }

    public static boolean mapsToProperty(Class<?> type) {
        return MappingUtil.isSimpleType(type);
    }

    public static boolean isSimpleType(Class<?> type) {
        return type.isPrimitive() || String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || java.util.Date.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type) || type.isArray() && type.getComponentType().isPrimitive();
    }

    public static Object convertToProperty(Object value) {
        if (value != null) {
            if (java.util.Date.class.isAssignableFrom(value.getClass())) {
                return MappingUtil.dateToLong((java.util.Date)value);
            }
            if (Enum.class.isAssignableFrom(value.getClass())) {
                return ((Enum)value).name();
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                if (map.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
            } else if (value instanceof Collection) {
                ArrayList<Object> ret = new ArrayList<Object>();
                Iterator it = ((Collection)value).iterator();
                while (it.hasNext()) {
                    ret.add(MappingUtil.convertToProperty(it.next()));
                }
                return ret;
            }
        }
        return value;
    }

    public static Object convertFromProperty(Object value, Class<?> targetType) {
        return MappingUtil.convertFromProperty(value, targetType, null, null);
    }

    public static <T extends Collection, S extends Collection> T convertCollection(S source, String collType) {
        if (!source.getClass().getName().equals(collType)) {
            try {
                Class<?> collCls = Class.forName(collType);
                Collection coll = (Collection)collCls.newInstance();
                for (Object val : source) {
                    coll.add(val);
                }
                return (T)coll;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        return (T)source;
    }

    public static Object convertFromProperty(Object value, Class<?> targetType, Class<?> componentType, Class<?> concreteFieldType) {
        if (value != null) {
            if (java.util.Date.class.isAssignableFrom(targetType) && value instanceof Number) {
                return MappingUtil.longToDate(((Number)value).longValue(), targetType);
            }
            if (Enum.class.isAssignableFrom(targetType)) {
                Object[] enums = MappingUtil.getEnumValues(targetType);
                for (int i = 0; i < enums.length; ++i) {
                    if (!((Enum)enums[i]).name().equals(value.toString())) continue;
                    return enums[i];
                }
                return value;
            }
            if (Collection.class.isAssignableFrom(targetType)) {
                if (componentType != null) {
                    ArrayList<Object> converted = new ArrayList<Object>();
                    Collection coll = (Collection)value;
                    for (Object elem : coll) {
                        converted.add(MappingUtil.convertFromProperty(elem, componentType, null, null));
                    }
                    try {
                        coll.clear();
                        coll.addAll(converted);
                    }
                    catch (UnsupportedOperationException e) {
                        return converted;
                    }
                }
            } else if (targetType.isArray()) {
                if (componentType != null && value instanceof Collection) {
                    ArrayList<Object> converted = new ArrayList<Object>();
                    Collection coll = (Collection)value;
                    for (Object elem : coll) {
                        converted.add(MappingUtil.convertFromProperty(elem, componentType, null, null));
                    }
                    if (componentType.isPrimitive()) {
                        Object array = Array.newInstance(componentType, coll.size());
                        for (int i = 0; i < converted.size(); ++i) {
                            Array.set(array, i, converted.get(i));
                        }
                        return array;
                    }
                    try {
                        coll.clear();
                        coll.addAll(converted);
                    }
                    catch (UnsupportedOperationException e) {
                        return converted;
                    }
                }
            } else if (Map.class.isAssignableFrom(targetType)) {
                if (concreteFieldType != null) {
                    try {
                        return concreteFieldType.newInstance();
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                if (targetType.equals(value.getClass())) {
                    return value;
                }
                if (targetType.isPrimitive()) {
                    return MappingUtil.convertToPrimitive(value, targetType);
                }
                if (targetType.isAssignableFrom(value.getClass())) {
                    return targetType.cast(value);
                }
                if (Number.class.isAssignableFrom(targetType) && value instanceof Number) {
                    return MappingUtil.convertToDistinctNumber(value, targetType);
                }
            }
        }
        return value;
    }

    public static JcPrimitive fromType(Class<?> type, String name) {
        if (type.equals(String.class)) {
            return new JcString(name);
        }
        if (type.equals(Number.class)) {
            return new JcNumber(name);
        }
        if (type.equals(Boolean.class)) {
            return new JcBoolean(name);
        }
        return null;
    }

    public static Object[] getEnumValues(Class<? extends Enum<?>> clazz) {
        Object[] enums = clazz.getEnumConstants();
        if (enums == null) {
            Method[] mthds = clazz.getDeclaredMethods();
            Method mthd = null;
            for (Method mth : mthds) {
                if (!mth.getName().equals("values")) continue;
                mthd = mth;
                break;
            }
            if (mthd != null) {
                try {
                    enums = (Object[])mthd.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return enums;
    }

    private static Object convertToPrimitive(Object value, Class<?> targetType) {
        if (targetType.equals(Short.TYPE) && value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (targetType.equals(Integer.TYPE) && value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (targetType.equals(Long.TYPE) && value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (targetType.equals(Float.TYPE) && value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (targetType.equals(Double.TYPE) && value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (targetType.equals(Boolean.TYPE) && value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        return value;
    }

    private static Object convertToDistinctNumber(Object value, Class<?> targetType) {
        if (targetType.equals(Short.class)) {
            return ((Number)value).shortValue();
        }
        if (targetType.equals(Integer.class)) {
            return ((Number)value).intValue();
        }
        if (targetType.equals(Long.class)) {
            return ((Number)value).longValue();
        }
        if (targetType.equals(Float.class)) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (targetType.equals(Double.class)) {
            return ((Number)value).doubleValue();
        }
        return value;
    }

    private static SimpleDateFormat getSimpleDateFormat() {
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy-HH:mm:ss:SSS", new Locale("de", "AT"));
        }
        return simpleDateFormat;
    }
}

