/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping.surrogate;

import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.domain.mapping.DomainState;
import iot.jcypher.domain.mapping.FieldMapping;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrProperty;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class InnerClassSurrogate {
    private transient Object realObject;
    private transient Constructor<?> constructor;
    private transient List<InnerClassSurrogate> toConstruct;
    private transient List<DeferredFieldMapping> parents;
    private transient List<DeferredFieldMapping> children;
    private transient List<DeferredPropertyMapping> propertyChildren;
    private transient DomainAccess.IRecursionExit recursionExit;
    private transient int actResolutionDepth;
    private transient DomainAccess.InternalDomainAccess id2ObjectMapper;
    private transient long nodeId;
    private transient List<DomainState.Relation.RelationUpdate> relationUpdates;

    public InnerClassSurrogate(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    private void addToConstruct(InnerClassSurrogate ics) {
        if (this.realObject == null) {
            if (this.toConstruct == null) {
                this.toConstruct = new ArrayList<InnerClassSurrogate>();
            }
            this.toConstruct.add(ics);
        } else {
            ics.constructAndFill(this.realObject);
        }
    }

    private void constructAndFill(Object obj) {
        try {
            this.realObject = this.constructor.newInstance(obj);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.fill();
    }

    public void addChild(FieldMapping fm, Object obj) {
        if (fm.isInnerClassRefField()) {
            if (obj instanceof InnerClassSurrogate) {
                ((InnerClassSurrogate)obj).addToConstruct(this);
            } else {
                this.constructAndFill(obj);
            }
        } else if (this.realObject == null) {
            if (this.children == null) {
                this.children = new ArrayList<DeferredFieldMapping>();
            }
            this.children.add(new DeferredFieldMapping(fm, obj));
        } else {
            fm.setFieldValue(this.realObject, obj);
        }
    }

    private void fill() {
        if (this.children != null) {
            for (DeferredFieldMapping dfm : this.children) {
                dfm.fieldMapping.setFieldValue(this.realObject, dfm.object);
            }
        }
        if (this.propertyChildren != null) {
            for (DeferredPropertyMapping dpm : this.propertyChildren) {
                dpm.fieldMapping.mapPropertyToField(this.realObject, dpm.grNode);
            }
        }
        if (this.parents != null) {
            for (DeferredFieldMapping dfm : this.parents) {
                dfm.fieldMapping.setFieldValue(dfm.object, this.realObject);
            }
        }
        this.id2ObjectMapper.replace_Id2Object(this, this.realObject, this.nodeId);
        if (this.recursionExit != null) {
            this.recursionExit.addRecursionExitObject(this.realObject, this.actResolutionDepth);
        }
        if (this.toConstruct != null) {
            for (InnerClassSurrogate ics : this.toConstruct) {
                ics.constructAndFill(this.realObject);
            }
        }
        if (this.relationUpdates != null) {
            for (DomainState.Relation.RelationUpdate ru : this.relationUpdates) {
                ru.updateWith(this.realObject);
            }
        }
    }

    public boolean addPropertyChild(FieldMapping fm, Object obj, GrNode node) {
        if (!fm.isInnerClassRefField()) {
            if (this.realObject == null) {
                if (this.propertyChildren == null) {
                    this.propertyChildren = new ArrayList<DeferredPropertyMapping>();
                }
                this.propertyChildren.add(new DeferredPropertyMapping(fm, obj, node));
                GrProperty prop = node.getProperty(fm.getPropertyOrRelationName());
                return prop != null;
            }
            return fm.mapPropertyToField(this.realObject, node);
        }
        return false;
    }

    public void addParent(FieldMapping fm, Object obj) {
        if (this.realObject == null) {
            if (this.parents == null) {
                this.parents = new ArrayList<DeferredFieldMapping>();
            }
            this.parents.add(new DeferredFieldMapping(fm, obj));
        } else {
            fm.setFieldValue(obj, this.realObject);
        }
    }

    public Class<?> getRealClass() {
        return this.constructor.getDeclaringClass();
    }

    public Object getRealObject() {
        return this.realObject;
    }

    public void setRecursionExit(DomainAccess.IRecursionExit recursionExit) {
        this.recursionExit = recursionExit;
    }

    public void setActResolutionDepth(int actResolutionDepth) {
        this.actResolutionDepth = actResolutionDepth;
    }

    public void setId2ObjectMapper(DomainAccess.InternalDomainAccess id2ObjectMapper) {
        this.id2ObjectMapper = id2ObjectMapper;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public void addRelationUpdate(DomainState.Relation.RelationUpdate relationUpdate) {
        if (this.realObject == null) {
            if (this.relationUpdates == null) {
                this.relationUpdates = new ArrayList<DomainState.Relation.RelationUpdate>();
            }
            this.relationUpdates.add(relationUpdate);
        } else {
            relationUpdate.updateWith(this.realObject);
        }
    }

    private class DeferredPropertyMapping
    extends DeferredFieldMapping {
        private GrNode grNode;

        private DeferredPropertyMapping(FieldMapping fieldMapping, Object object, GrNode n) {
            super(fieldMapping, object);
            this.grNode = n;
        }
    }

    private class DeferredFieldMapping {
        protected FieldMapping fieldMapping;
        protected Object object;

        private DeferredFieldMapping(FieldMapping fieldMapping, Object object) {
            this.fieldMapping = fieldMapping;
            this.object = object;
        }
    }
}

