/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.mapping.surrogate;

import iot.jcypher.domain.mapping.surrogate.AbstractDeferred;
import iot.jcypher.domain.mapping.surrogate.IEntryUpdater;
import iot.jcypher.domain.mapping.surrogate.Surrogate2ListEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ListEntriesUpdater
extends AbstractDeferred
implements IEntryUpdater {
    private Collection<Object> collection;
    private List<Surrogate2ListEntry> entries;

    public ListEntriesUpdater(Collection<Object> collection) {
        this.collection = collection;
        this.entries = new ArrayList<Surrogate2ListEntry>();
    }

    @Override
    public void performUpdate() {
        Collections.sort(this.entries, new Comparator<Surrogate2ListEntry>(){

            @Override
            public int compare(Surrogate2ListEntry o1, Surrogate2ListEntry o2) {
                int y;
                int x = o1.getIndex();
                return x < (y = o2.getIndex()) ? -1 : (x == y ? 0 : 1);
            }
        });
        for (Surrogate2ListEntry entry : this.entries) {
            if (this.collection instanceof List) {
                ((List)this.collection).add(entry.getIndex(), entry.getSurrogate().getContent());
                continue;
            }
            if (this.collection == null) continue;
            this.collection.add(entry.getSurrogate().getContent());
        }
        this.modifyNextUp();
    }

    public void updateFrom(Surrogate2ListEntry s2ListEntry) {
        this.entries.add(s2ListEntry);
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    @Override
    public Object objectToUpdate() {
        return this.getCollection();
    }

    @Override
    public Object entry2Update() {
        return this;
    }
}

