/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery;

import iot.jcypher.domain.IDomainAccess;
import iot.jcypher.domain.genericmodel.DomainObject;
import iot.jcypher.domain.genericmodel.InternalAccess;
import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.domainquery.CountQueryResult;
import iot.jcypher.domainquery.DomainQueryResult;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.BooleanOperation;
import iot.jcypher.domainquery.api.Collect;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.api.IPredicateOperand1;
import iot.jcypher.domainquery.api.Order;
import iot.jcypher.domainquery.api.Select;
import iot.jcypher.domainquery.api.TerminalResult;
import iot.jcypher.domainquery.api.Traverse;
import iot.jcypher.domainquery.ast.CollectExpression;
import iot.jcypher.domainquery.ast.ConcatenateExpression;
import iot.jcypher.domainquery.ast.FromPreviousQueryExpression;
import iot.jcypher.domainquery.ast.IASTObject;
import iot.jcypher.domainquery.ast.OrderExpression;
import iot.jcypher.domainquery.ast.Parameter;
import iot.jcypher.domainquery.ast.PredicateExpression;
import iot.jcypher.domainquery.ast.SelectExpression;
import iot.jcypher.domainquery.ast.TraversalExpression;
import iot.jcypher.domainquery.ast.UnionExpression;
import iot.jcypher.domainquery.internal.IASTObjectsContainer;
import iot.jcypher.domainquery.internal.QueryExecutor;
import iot.jcypher.domainquery.internal.QueryRecorder;
import iot.jcypher.domainquery.internal.RecordedQuery;
import iot.jcypher.domainquery.internal.ReplayedQueryContext;
import iot.jcypher.query.values.JcProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractDomainQuery {
    protected QueryExecutor queryExecutor;
    private IASTObjectsContainer astObjectsContainer;
    private IntAccess intAccess;

    public AbstractDomainQuery(IDomainAccess domainAccess) {
        this.queryExecutor = new QueryExecutor(domainAccess);
        this.astObjectsContainer = this.queryExecutor;
    }

    void recordQuery(RecordedQuery rq) {
        this.queryExecutor.recordQuery(rq, this);
    }

    void replayQuery(ReplayedQueryContext rqc) {
        this.queryExecutor.replayQuery(rqc);
    }

    <T> DomainObjectMatch<T> createMatchInternal(Class<T> domainObjectType) {
        DomainObjectMatch<T> ret = APIAccess.createDomainObjectMatch(domainObjectType, this.queryExecutor.getDomainObjectMatches().size(), this.queryExecutor.getMappingInfo());
        this.queryExecutor.getDomainObjectMatches().add(ret);
        return ret;
    }

    public <T> DomainObjectMatch<T> createMatchFrom(DomainObjectMatch<T> domainObjectMatch) {
        DomainObjectMatch<Object> match;
        DomainObjectMatch<Object> ret;
        FromPreviousQueryExpression pqe;
        DomainObjectMatch<?> delegate = APIAccess.getDelegate(domainObjectMatch);
        if (delegate != null) {
            DomainObjectMatch<?> newDelegate = APIAccess.createDomainObjectMatch(delegate, this.queryExecutor.getDomainObjectMatches().size(), this.queryExecutor.getMappingInfo());
            this.queryExecutor.getDomainObjectMatches().add(newDelegate);
            pqe = new FromPreviousQueryExpression(newDelegate, delegate);
            ret = APIAccess.createDomainObjectMatch(DomainObject.class, newDelegate);
            match = newDelegate;
        } else {
            ret = APIAccess.createDomainObjectMatch(domainObjectMatch, this.queryExecutor.getDomainObjectMatches().size(), this.queryExecutor.getMappingInfo());
            this.queryExecutor.getDomainObjectMatches().add(ret);
            pqe = new FromPreviousQueryExpression(ret, domainObjectMatch);
            match = ret;
        }
        this.queryExecutor.addAstObject(pqe);
        QueryRecorder.recordAssignment(this, "createMatchFrom", match, QueryRecorder.reference(domainObjectMatch));
        return ret;
    }

    public <T> DomainObjectMatch<T> createMatchFor(T domainObject) {
        DomainObjectMatch<Object> ret;
        ArrayList<DomainObject> source;
        if (domainObject.getClass().equals(DomainObject.class)) {
            source = new ArrayList<DomainObject>();
            source.add((DomainObject)domainObject);
            String typeName = ((DomainObject)domainObject).getDomainObjectType().getName();
            ret = this.createGenMatchForInternal(source, typeName);
        } else {
            source = new ArrayList();
            source.add((DomainObject)domainObject);
            ret = this.createMatchForInternal(source, domainObject.getClass());
        }
        DomainObjectMatch<?> delegate = APIAccess.getDelegate(ret);
        DomainObjectMatch<Object> match = delegate != null ? delegate : ret;
        QueryRecorder.recordAssignment(this, "createMatchFor", match, QueryRecorder.reference(domainObject));
        return ret;
    }

    protected <T> DomainObjectMatch<T> createMatchForInternal(List<T> domainObjects, Class<T> domainObjectType) {
        DomainObjectMatch<T> ret = APIAccess.createDomainObjectMatch(domainObjectType, this.queryExecutor.getDomainObjectMatches().size(), this.queryExecutor.getMappingInfo());
        this.queryExecutor.getDomainObjectMatches().add(ret);
        FromPreviousQueryExpression pqe = new FromPreviousQueryExpression(ret, domainObjects);
        this.queryExecutor.addAstObject(pqe);
        return ret;
    }

    protected DomainObjectMatch<DomainObject> createGenMatchForInternal(List<DomainObject> domainObjects, String domainObjectTypeName) {
        DomainAccess.InternalDomainAccess iAccess = this.queryExecutor.getMappingInfo().getInternalDomainAccess();
        try {
            iAccess.loadDomainInfoIfNeeded();
            ArrayList<Object> dobjs = new ArrayList<Object>();
            for (DomainObject dobj : domainObjects) {
                dobjs.add(InternalAccess.getRawObject(dobj));
            }
            Class<?> clazz = iAccess.getClassForName(domainObjectTypeName);
            DomainObjectMatch delegate = this.createMatchForInternal(dobjs, clazz);
            DomainObjectMatch<DomainObject> ret = APIAccess.createDomainObjectMatch(DomainObject.class, delegate);
            return ret;
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public Parameter parameter(String name) {
        return this.queryExecutor.parameter(name);
    }

    public List<String> getParameterNames() {
        return new ArrayList<String>(this.queryExecutor.getParameterNames());
    }

    public BooleanOperation WHERE(IPredicateOperand1 value) {
        DomainObjectMatch<?> delegate;
        DomainObjectMatch<?> pVal = value;
        if (value instanceof DomainObjectMatch && (delegate = APIAccess.getDelegate(value)) != null) {
            pVal = delegate;
        }
        PredicateExpression pe = new PredicateExpression((IPredicateOperand1)pVal, this.astObjectsContainer);
        this.astObjectsContainer.addAstObject(pe);
        BooleanOperation ret = APIAccess.createBooleanOperation(pe);
        QueryRecorder.recordInvocation(this, "WHERE", ret, QueryRecorder.placeHolder(pVal));
        return ret;
    }

    public TerminalResult OR() {
        ConcatenateExpression ce = new ConcatenateExpression(ConcatenateExpression.Concatenator.OR);
        this.astObjectsContainer.addAstObject(ce);
        TerminalResult ret = APIAccess.createTerminalResult(ce);
        QueryRecorder.recordInvocation(this, "OR", ret, new Object[0]);
        return ret;
    }

    public TerminalResult BR_OPEN() {
        ConcatenateExpression ce = new ConcatenateExpression(ConcatenateExpression.Concatenator.BR_OPEN);
        this.astObjectsContainer.addAstObject(ce);
        TerminalResult ret = APIAccess.createTerminalResult(ce);
        QueryRecorder.recordInvocation(this, "BR_OPEN", ret, new Object[0]);
        return ret;
    }

    public TerminalResult BR_CLOSE() {
        ConcatenateExpression ce = new ConcatenateExpression(ConcatenateExpression.Concatenator.BR_CLOSE);
        this.astObjectsContainer.addAstObject(ce);
        TerminalResult ret = APIAccess.createTerminalResult(ce);
        QueryRecorder.recordInvocation(this, "BR_CLOSE", ret, new Object[0]);
        return ret;
    }

    public Order ORDER(DomainObjectMatch<?> toOrder) {
        DomainObjectMatch<?> delegate = APIAccess.getDelegate(toOrder);
        DomainObjectMatch<?> match = delegate != null ? delegate : toOrder;
        OrderExpression oe = this.queryExecutor.getOrderFor(match);
        Order ret = APIAccess.createOrder(oe);
        QueryRecorder.recordInvocation(this, "ORDER", ret, QueryRecorder.placeHolder(match));
        return ret;
    }

    public Traverse TRAVERSE_FROM(DomainObjectMatch<?> start) {
        DomainObjectMatch<?> delegate = APIAccess.getDelegate(start);
        DomainObjectMatch<?> match = delegate != null ? delegate : start;
        TraversalExpression te = new TraversalExpression(match, this.queryExecutor);
        this.queryExecutor.addAstObject(te);
        Traverse ret = APIAccess.createTraverse(te);
        QueryRecorder.recordInvocation(this, "TRAVERSE_FROM", ret, QueryRecorder.placeHolder(match));
        return ret;
    }

    public <T> Select<T> SELECT_FROM(DomainObjectMatch<T> start) {
        DomainObjectMatch<?> delegate = APIAccess.getDelegate(start);
        DomainObjectMatch<Object> match = delegate != null ? delegate : start;
        SelectExpression<T> se = new SelectExpression<T>(APIAccess.getDomainObjectType(start), match, this.getIntAccess());
        this.queryExecutor.addAstObject(se);
        this.astObjectsContainer = se;
        Select<T> ret = APIAccess.createSelect(se, this.getIntAccess());
        QueryRecorder.recordInvocation(this, "SELECT_FROM", ret, QueryRecorder.placeHolder(match));
        return ret;
    }

    public <T> Select<T> REJECT_FROM(DomainObjectMatch<T> start) {
        DomainObjectMatch<?> delegate = APIAccess.getDelegate(start);
        DomainObjectMatch<Object> match = delegate != null ? delegate : start;
        SelectExpression<T> se = new SelectExpression<T>(APIAccess.getDomainObjectType(start), match, this.getIntAccess(), true);
        this.queryExecutor.addAstObject(se);
        this.astObjectsContainer = se;
        Select<T> ret = APIAccess.createSelect(se, this.getIntAccess());
        QueryRecorder.recordInvocation(this, "REJECT_FROM", ret, QueryRecorder.placeHolder(match));
        return ret;
    }

    public Collect COLLECT(JcProperty attribute) {
        CollectExpression ce = new CollectExpression(attribute, this.getIntAccess());
        Collect coll = APIAccess.createCollect(ce);
        this.queryExecutor.addAstObject(ce);
        QueryRecorder.recordInvocation(this, "COLLECT", coll, QueryRecorder.placeHolder(attribute));
        return coll;
    }

    public <T> DomainObjectMatch<T> UNION(DomainObjectMatch<T> ... set) {
        DomainObjectMatch<Object> match;
        DomainObjectMatch<?> delegate;
        DomainObjectMatch<T> ret = this.union_Intersection(true, set);
        Object[] placeHolders = new Object[set.length];
        for (int i = 0; i < set.length; ++i) {
            delegate = APIAccess.getDelegate(set[i]);
            match = delegate != null ? delegate : set[i];
            placeHolders[i] = QueryRecorder.placeHolder(match);
        }
        delegate = APIAccess.getDelegate(ret);
        match = delegate != null ? delegate : ret;
        QueryRecorder.recordAssignment(this, "UNION", match, placeHolders);
        return ret;
    }

    public <T> DomainObjectMatch<T> INTERSECTION(DomainObjectMatch<T> ... set) {
        DomainObjectMatch<Object> match;
        DomainObjectMatch<?> delegate;
        DomainObjectMatch<T> ret = this.union_Intersection(false, set);
        Object[] placeHolders = new Object[set.length];
        for (int i = 0; i < set.length; ++i) {
            delegate = APIAccess.getDelegate(set[i]);
            match = delegate != null ? delegate : set[i];
            placeHolders[i] = QueryRecorder.placeHolder(match);
        }
        delegate = APIAccess.getDelegate(ret);
        match = delegate != null ? delegate : ret;
        QueryRecorder.recordAssignment(this, "INTERSECTION", match, placeHolders);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainQueryResult execute() {
        DomainQueryResult ret = new DomainQueryResult(this);
        Object so = this.queryExecutor.getMappingInfo().getInternalDomainAccess().getSyncObject();
        if (so != null) {
            Object object = so;
            synchronized (object) {
                this.queryExecutor.execute();
            }
        } else {
            this.queryExecutor.execute();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountQueryResult executeCount() {
        CountQueryResult ret = new CountQueryResult(this);
        Object so = this.queryExecutor.getMappingInfo().getInternalDomainAccess().getSyncObject();
        if (so != null) {
            Object object = so;
            synchronized (object) {
                this.queryExecutor.executeCount();
            }
        } else {
            this.queryExecutor.executeCount();
        }
        return ret;
    }

    public ReplayedQueryContext getReplayedQueryContext() {
        return this.queryExecutor.getReplayedQueryContext();
    }

    public RecordedQuery getRecordedQuery() {
        return this.queryExecutor.getRecordedQuery();
    }

    Map<Object, String> getRecordedQueryObjects() {
        return this.queryExecutor.getRecordedQueryObjects();
    }

    QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> DomainObjectMatch<T> union_Intersection(boolean union, DomainObjectMatch<T> ... set) {
        DomainObjectMatch<Object> ret;
        Boolean br_old = QueryRecorder.blockRecording.get();
        try {
            boolean isGeneric;
            QueryRecorder.blockRecording.set(Boolean.TRUE);
            DomainObjectMatch<T>[] newSet = set;
            boolean bl = isGeneric = set.length > 0 && APIAccess.getDelegate(set[0]) != null;
            if (isGeneric) {
                newSet = new DomainObjectMatch[set.length];
                for (int i = 0; i < set.length; ++i) {
                    DomainObjectMatch<?> delegate = APIAccess.getDelegate(set[i]);
                    newSet[i] = delegate != null ? delegate : set[i];
                }
            }
            DomainObjectMatch<T> newMatch = this.build_union_Intersection(union, newSet);
            ret = isGeneric ? APIAccess.createDomainObjectMatch(DomainObject.class, newMatch) : newMatch;
        }
        finally {
            QueryRecorder.blockRecording.set(br_old);
        }
        return ret;
    }

    private <T> DomainObjectMatch<T> build_union_Intersection(boolean union, DomainObjectMatch<T> ... set) {
        DomainObjectMatch<T> ret = null;
        if (set.length > 0) {
            IASTObject lastOne = null;
            UnionExpression ue = new UnionExpression(union);
            ret = APIAccess.createDomainObjectMatch(APIAccess.getDomainObjectType(set[0]), this.queryExecutor.getDomainObjectMatches().size(), this.queryExecutor.getMappingInfo());
            this.queryExecutor.getDomainObjectMatches().add(ret);
            ue.setResult(ret);
            APIAccess.setUnionExpression(ret, ue);
            int idx = 0;
            if (set.length > 1) {
                this.BR_OPEN();
            }
            for (DomainObjectMatch<T> dom : set) {
                ue.getSources().add(dom);
                if (idx > 0 && union) {
                    this.OR();
                }
                lastOne = APIAccess.getAstObject(this.WHERE(ret).IN(dom));
                ++idx;
            }
            if (set.length > 1) {
                lastOne = APIAccess.getAstObject(this.BR_CLOSE());
            }
            ue.setLastOfUnionBase(lastOne);
        }
        return ret;
    }

    private IntAccess getIntAccess() {
        if (this.intAccess == null) {
            this.intAccess = new IntAccess();
        }
        return this.intAccess;
    }

    public class IntAccess {
        public QueryExecutor getQueryExecutor() {
            return AbstractDomainQuery.this.queryExecutor;
        }

        public AbstractDomainQuery getDomainQuery() {
            return AbstractDomainQuery.this;
        }

        public void resetAstObjectsContainer() {
            AbstractDomainQuery.this.astObjectsContainer = AbstractDomainQuery.this.queryExecutor;
        }
    }
}

