/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery;

import iot.jcypher.domainquery.AbstractDomainQuery;
import iot.jcypher.domainquery.InternalAccess;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.internal.QueryRecorder;
import java.util.List;

public class DomainQueryResult {
    private AbstractDomainQuery domainQuery;

    DomainQueryResult(AbstractDomainQuery domainQuery) {
        this.domainQuery = domainQuery;
    }

    public <T> List<T> resultOf(DomainObjectMatch<T> match) {
        return this.resultOf(match, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> resultOf(DomainObjectMatch<T> match, boolean forceResolve) {
        List<T> ret;
        Object so = InternalAccess.getQueryExecutor(this.domainQuery).getMappingInfo().getInternalDomainAccess().getSyncObject();
        if (so != null) {
            Object object = so;
            synchronized (object) {
                ret = this.intResultOf(match, forceResolve);
            }
        } else {
            ret = this.intResultOf(match, forceResolve);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> intResultOf(DomainObjectMatch<T> match, boolean forceResolve) {
        List<Object> ret;
        block11: {
            try {
                if (forceResolve) {
                    this.domainQuery.getQueryExecutor().getMappingInfo().getInternalDomainAccess().startReResolve();
                }
                if (this.domainQuery.getQueryExecutor().hasBeenReplayed()) {
                    ret = this.domainQuery.getQueryExecutor().loadReplayedResult(match);
                    break block11;
                }
                Boolean br_old = QueryRecorder.blockRecording.get();
                try {
                    QueryRecorder.blockRecording.set(Boolean.TRUE);
                    DomainObjectMatch<?> delegate = APIAccess.getDelegate(match);
                    if (delegate != null) {
                        List<?> dobjs = this.domainQuery.getQueryExecutor().loadResult(delegate);
                        ret = this.domainQuery.getQueryExecutor().getMappingInfo().getInternalDomainAccess().getGenericDomainObjects(dobjs);
                    } else {
                        ret = this.domainQuery.getQueryExecutor().loadResult(match);
                    }
                }
                finally {
                    QueryRecorder.blockRecording.set(br_old);
                }
            }
            finally {
                if (forceResolve) {
                    this.domainQuery.getQueryExecutor().getMappingInfo().getInternalDomainAccess().endReResolve();
                }
            }
        }
        return ret;
    }

    AbstractDomainQuery getDomainQuery() {
        return this.domainQuery;
    }
}

