/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.api;

import iot.jcypher.domain.genericmodel.DomainObject;
import iot.jcypher.domain.internal.DomainAccess;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.APIObject;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.ast.TraversalExpression;
import iot.jcypher.domainquery.internal.QueryRecorder;

public class TraversalStep
extends APIObject {
    TraversalStep(TraversalExpression te) {
        this.astObject = te;
    }

    public TraversalStep FORTH(String attributeName) {
        TraversalExpression te = (TraversalExpression)this.astObject;
        te.step(attributeName, 0);
        TraversalStep ret = new TraversalStep(te);
        QueryRecorder.recordInvocation(this, "FORTH", ret, QueryRecorder.literal(attributeName));
        return ret;
    }

    public TraversalStep BACK(String attributeName) {
        TraversalExpression te = (TraversalExpression)this.astObject;
        te.step(attributeName, 1);
        TraversalStep ret = new TraversalStep(te);
        QueryRecorder.recordInvocation(this, "BACK", ret, QueryRecorder.literal(attributeName));
        return ret;
    }

    public TraversalStep DISTANCE(int minDistance, int maxDistance) {
        TraversalExpression te = (TraversalExpression)this.astObject;
        TraversalExpression.Step step = te.getSteps().get(te.getSteps().size() - 1);
        step.setMinDistance(minDistance);
        step.setMaxDistance(maxDistance);
        QueryRecorder.recordInvocation(this, "DISTANCE", this, QueryRecorder.literal(minDistance), QueryRecorder.literal(maxDistance));
        return this;
    }

    public <T> DomainObjectMatch<T> TO(Class<T> domainObjectType) {
        TraversalExpression te = (TraversalExpression)this.astObject;
        DomainObjectMatch<T> ret = APIAccess.createDomainObjectMatch(domainObjectType, te.getQueryExecutor().getDomainObjectMatches().size(), te.getQueryExecutor().getMappingInfo());
        te.getQueryExecutor().getDomainObjectMatches().add(ret);
        te.setEnd(ret);
        QueryRecorder.recordAssignment(this, "TO", ret, QueryRecorder.literal(domainObjectType.getName()));
        return ret;
    }

    public DomainObjectMatch<DomainObject> TO_GENERIC(String domainObjectTypeName) {
        Boolean br_old = null;
        try {
            TraversalExpression te = (TraversalExpression)this.astObject;
            DomainAccess.InternalDomainAccess iAccess = te.getQueryExecutor().getMappingInfo().getInternalDomainAccess();
            iAccess.loadDomainInfoIfNeeded();
            Class<?> clazz = iAccess.getClassForName(domainObjectTypeName);
            br_old = QueryRecorder.blockRecording.get();
            QueryRecorder.blockRecording.set(Boolean.TRUE);
            DomainObjectMatch<?> delegate = this.TO(clazz);
            QueryRecorder.blockRecording.set(br_old);
            DomainObjectMatch<DomainObject> ret = APIAccess.createDomainObjectMatch(DomainObject.class, delegate);
            QueryRecorder.recordAssignment(this, "TO_GENERIC", delegate, QueryRecorder.literal(domainObjectTypeName));
            DomainObjectMatch<DomainObject> domainObjectMatch = ret;
            if (br_old != null) {
                QueryRecorder.blockRecording.set(br_old);
            }
            return domainObjectMatch;
        }
        catch (Throwable e) {
            try {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (br_old != null) {
                    QueryRecorder.blockRecording.set(br_old);
                }
                throw throwable;
            }
        }
    }
}

