/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.ast;

import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.ast.IASTObject;
import java.util.ArrayList;
import java.util.List;

public class OrderExpression
implements IASTObject {
    private DomainObjectMatch<?> objectMatch;
    private List<OrderBy> orderCriterias;

    public OrderExpression(DomainObjectMatch<?> objectMatch) {
        this.objectMatch = objectMatch;
    }

    public DomainObjectMatch<?> getObjectMatch() {
        return this.objectMatch;
    }

    public List<OrderBy> getOrderCriterias() {
        if (this.orderCriterias == null) {
            this.orderCriterias = new ArrayList<OrderBy>();
        }
        return this.orderCriterias;
    }

    public OrderBy getCreateOrderCriteriaFor(String attributeName) {
        List<OrderBy> ocs = this.getOrderCriterias();
        OrderBy ret = null;
        for (OrderBy ob : ocs) {
            if (!ob.getAttributeName().equals(attributeName)) continue;
            ret = ob;
            break;
        }
        if (ret == null) {
            ret = new OrderBy(attributeName);
            ocs.add(ret);
        }
        return ret;
    }

    public static class OrderBy {
        private String attributeName;
        private int direction;

        public OrderBy(String attributeName) {
            this.attributeName = attributeName;
            this.direction = 0;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public String getAttributeName() {
            return this.attributeName;
        }
    }
}

