/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.ast;

import iot.jcypher.domainquery.AbstractDomainQuery;
import iot.jcypher.domainquery.api.APIAccess;
import iot.jcypher.domainquery.api.DomainObjectMatch;
import iot.jcypher.domainquery.ast.IASTObject;
import iot.jcypher.domainquery.ast.PredicateExpression;
import iot.jcypher.domainquery.ast.UnionExpression;
import iot.jcypher.domainquery.internal.IASTObjectsContainer;
import iot.jcypher.domainquery.internal.QueryExecutor;
import java.util.ArrayList;
import java.util.List;

public class SelectExpression<T>
implements IASTObject,
IASTObjectsContainer {
    private AbstractDomainQuery.IntAccess domainQueryIntAccess;
    private DomainObjectMatch<?> start;
    private Class<T> startType;
    private DomainObjectMatch<?> end;
    private List<IASTObject> astObjects;
    private List<DomainObjectMatch<?>> traversalResults;
    private boolean reject;

    public SelectExpression(Class<T> startType, DomainObjectMatch<?> start, AbstractDomainQuery.IntAccess domainQueryIntAccess) {
        this(startType, start, domainQueryIntAccess, false);
    }

    public SelectExpression(Class<T> startType, DomainObjectMatch<?> start, AbstractDomainQuery.IntAccess domainQueryIntAccess, boolean reject) {
        this.start = start;
        this.startType = startType;
        this.astObjects = new ArrayList<IASTObject>();
        this.domainQueryIntAccess = domainQueryIntAccess;
        this.reject = reject;
    }

    public List<IASTObject> getAstObjects() {
        return this.astObjects;
    }

    @Override
    public void addAstObject(IASTObject astObj) {
        this.astObjectToAdd(astObj);
        this.astObjects.add(astObj);
    }

    public void replaceAstObject(int idx, List<IASTObject> replacements) {
        this.astObjects.addAll(idx, replacements);
        this.astObjects.remove(idx + replacements.size());
        for (IASTObject astObj : replacements) {
            this.astObjectToAdd(astObj);
        }
    }

    public void addAstObjects(List<IASTObject> astObjs) {
        this.astObjects.addAll(astObjs);
        for (IASTObject astObj : astObjs) {
            this.astObjectToAdd(astObj);
        }
    }

    private void astObjectToAdd(IASTObject astObj) {
        DomainObjectMatch<?> dom;
        if (astObj instanceof PredicateExpression && (dom = ((PredicateExpression)astObj).getStartDOM()) != this.start) {
            DomainObjectMatch<?> src;
            UnionExpression ue = APIAccess.getUnionExpression(dom);
            DomainObjectMatch<?> domainObjectMatch = src = ue != null ? ue.getCommonTraversalSource() : APIAccess.getTraversalSource(dom);
            if (src != this.start) {
                throw new RuntimeException("Predicate expressions within a collection expression must express constraints on either the source set or on a set directly derived from the source set by traversal");
            }
            this.addTraversalResult(dom);
        }
    }

    public void addTraversalResult(DomainObjectMatch<?> dom) {
        if (this.traversalResults == null) {
            this.traversalResults = new ArrayList();
        }
        if (!this.traversalResults.contains(dom)) {
            this.traversalResults.add(dom);
        }
    }

    public void setEnd(DomainObjectMatch<?> end) {
        this.end = end;
        if (this.traversalResults != null) {
            for (DomainObjectMatch<?> dom : this.traversalResults) {
                APIAccess.addCollectExpressionOwner(dom, this.end);
            }
        }
    }

    public DomainObjectMatch<?> getEnd() {
        return this.end;
    }

    public DomainObjectMatch<?> getStart() {
        return this.start;
    }

    public Class<T> getStartType() {
        return this.startType;
    }

    public QueryExecutor getQueryExecutor() {
        return this.domainQueryIntAccess.getQueryExecutor();
    }

    public AbstractDomainQuery getDomainQuery() {
        return this.domainQueryIntAccess.getDomainQuery();
    }

    public List<DomainObjectMatch<?>> getTraversalResults() {
        return this.traversalResults;
    }

    public boolean isReject() {
        return this.reject;
    }

    public void resetAstObjectsContainer() {
        this.domainQueryIntAccess.resetAstObjectsContainer();
    }
}

