/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domainquery.internal;

import iot.jcypher.domainquery.internal.JSONConverter;
import iot.jcypher.domainquery.internal.JSONConverterAccess;
import iot.jcypher.domainquery.internal.RecordedQuery;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import javax.json.JsonArray;
import javax.json.JsonString;
import javax.json.JsonValue;

public class ConversionUtil {
    private static final String STRING = "java.lang.String";
    private static final String INTEGER = "java.lang.Integer";
    private static final String SHORT = "java.lang.Short";
    private static final String LONG = "java.lang.Long";
    private static final String FLOAT = "java.lang.Float";
    private static final String DOUBLE = "java.lang.Double";
    private static final String BOOL = "java.lang.Boolean";
    private static final String P_INTEGER = "int";
    private static final String P_SHORT = "short";
    private static final String P_LONG = "long";
    private static final String P_FLOAT = "float";
    private static final String P_DOUBLE = "double";
    private static final String P_BOOL = "boolean";
    private static final String ARRAY = "Array(";

    public static Object fromJSON(String type, JsonValue jsonValue) {
        Object val;
        if (jsonValue instanceof JsonArray) {
            val = ConversionUtil.fromList(type, (JsonArray)jsonValue);
        } else {
            String lVal = ((JsonString)jsonValue).getString();
            val = ConversionUtil.from(type, lVal);
        }
        return val;
    }

    public static Object from(String type, String value) {
        if (STRING.equals(type)) {
            return value;
        }
        if (INTEGER.equals(type)) {
            return Integer.valueOf(value);
        }
        if (SHORT.equals(type)) {
            return Short.valueOf(value);
        }
        if (LONG.equals(type)) {
            return Long.valueOf(value);
        }
        if (FLOAT.equals(type)) {
            return Float.valueOf(value);
        }
        if (DOUBLE.equals(type)) {
            return Double.valueOf(value);
        }
        if (BOOL.equals(type)) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static Object fromList(String type, JsonArray jsonArray) {
        try {
            if (type.startsWith(ARRAY)) {
                String compType = type.substring(type.indexOf(40) + 1);
                compType = compType.substring(0, compType.indexOf(41));
                Class<?> cls = null;
                try {
                    cls = Class.forName(compType);
                }
                catch (ClassNotFoundException ce) {
                    cls = ConversionUtil.getPrimitiveClass(compType);
                }
                int sz = jsonArray.size();
                Object arr = Array.newInstance(cls, sz);
                for (int i = 0; i < sz; ++i) {
                    ConversionUtil.addToArray((JsonValue)jsonArray.get(i), arr, i);
                }
                return arr;
            }
            Class<?> cls = Class.forName(type);
            Collection coll = (Collection)cls.newInstance();
            for (JsonValue jVal : jsonArray) {
                ConversionUtil.addToCollection(jVal, coll);
            }
            return coll;
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getPrimitiveClass(String compType) {
        if (P_INTEGER.equals(compType)) {
            return Integer.TYPE;
        }
        if (P_SHORT.equals(compType)) {
            return Short.TYPE;
        }
        if (P_LONG.equals(compType)) {
            return Long.TYPE;
        }
        if (P_FLOAT.equals(compType)) {
            return Float.TYPE;
        }
        if (P_DOUBLE.equals(compType)) {
            return Double.TYPE;
        }
        if (P_BOOL.equals(compType)) {
            return Boolean.TYPE;
        }
        return null;
    }

    private static void addToCollection(JsonValue jVal, Collection coll) {
        RecordedQuery.Statement statement = ConversionUtil.convertStatement(jVal);
        if (statement instanceof RecordedQuery.Literal) {
            Object val = ((RecordedQuery.Literal)statement).getRawValue();
            coll.add(val);
        }
    }

    private static void addToArray(JsonValue jVal, Object arr, int index) {
        RecordedQuery.Statement statement = ConversionUtil.convertStatement(jVal);
        if (statement instanceof RecordedQuery.Literal) {
            Object val = ((RecordedQuery.Literal)statement).getRawValue();
            Array.set(arr, index, val);
        }
    }

    private static RecordedQuery.Statement convertStatement(JsonValue jVal) {
        RecordedQuery rq = new RecordedQuery(false);
        JSONConverter jc = new JSONConverter();
        ArrayList<RecordedQuery.Statement> statements = new ArrayList<RecordedQuery.Statement>();
        JSONConverterAccess.readStatement(jc, jVal, statements, rq);
        return (RecordedQuery.Statement)statements.get(0);
    }
}

