/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.facade;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.domain.DomainInformation;
import iot.jcypher.query.writer.Format;
import iot.jcypher.query.writer.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class JSONDBFacade {
    private IDBAccess dbAccess;
    private Format prettyFormat;

    public JSONDBFacade(IDBAccess dbAccess) {
        this.dbAccess = dbAccess;
        this.prettyFormat = Format.NONE;
    }

    public String getDomains() {
        JsonGenerator generator;
        StringWriter sw = new StringWriter();
        if (this.prettyFormat != Format.NONE) {
            JsonGeneratorFactory gf = JSONWriter.getPrettyGeneratorFactory();
            generator = gf.createGenerator((Writer)sw);
        } else {
            generator = Json.createGenerator((Writer)sw);
        }
        generator.writeStartArray();
        List<String> doms = DomainInformation.availableDomains(this.dbAccess);
        for (String dom : doms) {
            generator.write(dom);
        }
        generator.writeEnd();
        generator.flush();
        return sw.toString();
    }

    public JSONDBFacade setPrettyFormat(Format prettyFormat) {
        this.prettyFormat = prettyFormat;
        return this;
    }
}

