/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.facade;

import iot.jcypher.domain.IDomainAccess;
import iot.jcypher.domain.IGenericDomainAccess;
import iot.jcypher.domain.genericmodel.DOField;
import iot.jcypher.domain.genericmodel.DOType;
import iot.jcypher.domain.genericmodel.internal.DomainModel;
import iot.jcypher.domain.internal.IIntDomainAccess;
import iot.jcypher.query.writer.Format;
import iot.jcypher.query.writer.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class JSONDomainFacade {
    private IDomainAccess domainAccess;
    private Format prettyFormat;

    public JSONDomainFacade(IDomainAccess domainAccess) {
        this.domainAccess = domainAccess;
        this.prettyFormat = Format.NONE;
    }

    public JSONDomainFacade(IGenericDomainAccess genericDomainAccess) {
        this.domainAccess = genericDomainAccess.getDomainAccess();
        this.prettyFormat = Format.NONE;
    }

    public String getDomainModel() {
        JsonGenerator generator;
        DomainModel model = ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().getDomainModel();
        StringWriter sw = new StringWriter();
        if (this.prettyFormat != Format.NONE) {
            JsonGeneratorFactory gf = JSONWriter.getPrettyGeneratorFactory();
            generator = gf.createGenerator((Writer)sw);
        } else {
            generator = Json.createGenerator((Writer)sw);
        }
        generator.writeStartObject();
        generator.write("domainName", model.getDomainName());
        this.writeModel(model, generator);
        generator.writeEnd();
        generator.flush();
        return sw.toString();
    }

    public String getDomainName() {
        JsonGenerator generator;
        DomainModel model = ((IIntDomainAccess)((Object)this.domainAccess)).getInternalDomainAccess().getDomainModel();
        StringWriter sw = new StringWriter();
        if (this.prettyFormat != Format.NONE) {
            JsonGeneratorFactory gf = JSONWriter.getPrettyGeneratorFactory();
            generator = gf.createGenerator((Writer)sw);
        } else {
            generator = Json.createGenerator((Writer)sw);
        }
        generator.writeStartObject();
        generator.write("domainName", model.getDomainName());
        generator.writeEnd();
        generator.flush();
        return sw.toString();
    }

    public JSONDomainFacade setPrettyFormat(Format prettyFormat) {
        this.prettyFormat = prettyFormat;
        return this;
    }

    private void writeModel(DomainModel model, JsonGenerator generator) {
        List<DOType> doTypes = model.getDOTypes();
        generator.writeStartArray("types");
        for (DOType typ : doTypes) {
            this.writeType(typ, generator);
        }
        generator.writeEnd();
    }

    private void writeType(DOType typ, JsonGenerator generator) {
        List<DOField> flds;
        List<DOType> ifs;
        generator.writeStartObject();
        generator.write("name", typ.getName());
        if (typ.getKind() != null) {
            generator.write("kind", typ.getKind().name());
        }
        if (typ.getSuperType() != null) {
            generator.writeStartArray("extends");
            generator.write(typ.getSuperType().getName());
            generator.writeEnd();
        }
        if (!(ifs = typ.getInterfaces()).isEmpty()) {
            if (typ.getKind() == DOType.Kind.INTERFACE) {
                generator.writeStartArray("extends");
            } else {
                generator.writeStartArray("implements");
            }
            for (DOType intf : ifs) {
                generator.write(intf.getName());
            }
            generator.writeEnd();
        }
        if (!(flds = typ.getDeclaredFields()).isEmpty()) {
            generator.writeStartArray("fields");
            for (DOField f : flds) {
                this.writeField(f, generator);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    private void writeField(DOField f, JsonGenerator generator) {
        generator.writeStartObject();
        generator.write("name", f.getName());
        generator.write("type", f.getTypeName());
        String ct = f.getComponentTypeName();
        if (ct != null) {
            generator.write("componentType", ct);
            generator.write("buildIn", DomainModel.isBuildIn(ct));
        } else {
            generator.write("buildIn", f.isBuidInType());
        }
        generator.writeEnd();
    }
}

