/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.graph;

import iot.jcypher.concurrency.Locking;
import iot.jcypher.database.IDBAccess;
import iot.jcypher.graph.GrNode;
import iot.jcypher.graph.GrRelation;
import iot.jcypher.graph.SyncState;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.result.util.ResultHandler;
import iot.jcypher.transaction.ITransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Graph {
    private ResultHandler resultHandler;
    private SyncState syncState;

    Graph(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public static Graph create(IDBAccess dbAccess) {
        ResultHandler rh = new ResultHandler(dbAccess);
        Graph ret = rh.getGraph();
        ret.setSyncState(SyncState.NEW);
        return ret;
    }

    public Graph setLockingStrategy(Locking locking) {
        this.resultHandler.setLockingStrategy(locking);
        return this;
    }

    public GrNode createNode() {
        return this.resultHandler.getLocalElements().createNode();
    }

    public GrRelation createRelation(String type, GrNode startNode, GrNode endNode) {
        return this.resultHandler.getLocalElements().createRelation(type, startNode, endNode);
    }

    public boolean isModified() {
        if (this.syncState == SyncState.NEW) {
            return !this.resultHandler.getLocalElements().isEmpty();
        }
        return this.syncState != SyncState.SYNC;
    }

    public List<JcError> store() {
        return this.store(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<JcError> store(Map<Long, Integer> elementVersionsMap) {
        List<JcError> ret = null;
        ITransaction txToClose = null;
        try {
            if (this.isModified()) {
                txToClose = this.resultHandler.createLockingTxIfNeeded();
                ret = this.resultHandler.store(elementVersionsMap);
            } else {
                ret = Collections.emptyList();
            }
        }
        finally {
            if (txToClose != null) {
                if (ret == null) {
                    ret = new ArrayList<JcError>();
                }
                ret.addAll(txToClose.close());
            }
        }
        return ret;
    }

    SyncState getSyncState() {
        return this.syncState;
    }

    void setSyncState(SyncState syncState) {
        this.syncState = syncState;
    }

    void setDBAccess(IDBAccess dbAccess) {
        this.resultHandler.setDbAccess(dbAccess);
    }
}

