/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.graph;

import iot.jcypher.graph.SyncState;
import iot.jcypher.graph.internal.ChangeListener;
import java.util.ArrayList;
import java.util.List;

public abstract class PersistableItem {
    private List<ChangeListener> changeListeners;
    protected SyncState syncState;

    public void remove() {
        SyncState oldState = this.syncState;
        this.syncState = this.syncState == SyncState.NEW || this.syncState == SyncState.NEW_REMOVED ? SyncState.NEW_REMOVED : SyncState.REMOVED;
        if (oldState != this.syncState) {
            this.fireChanged(oldState, this.syncState);
        }
    }

    void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    protected void fireChanged(SyncState oldState, SyncState newState) {
        if (this.changeListeners != null) {
            ArrayList<ChangeListener> lstnrs = new ArrayList<ChangeListener>();
            lstnrs.addAll(this.changeListeners);
            for (ChangeListener lstnr : lstnrs) {
                lstnr.changed(this, oldState, newState);
            }
        }
    }

    void notifyState() {
        if (this.changeListeners != null) {
            ArrayList<ChangeListener> lstnrs = new ArrayList<ChangeListener>();
            lstnrs.addAll(this.changeListeners);
            for (ChangeListener lstnr : lstnrs) {
                lstnr.changed(this, this.syncState, this.syncState);
            }
        }
    }

    SyncState getSyncState() {
        return this.syncState;
    }

    void setSyncState(SyncState syncState) {
        this.syncState = syncState;
    }

    abstract void setToSynchronized();
}

