/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.graph;

import iot.jcypher.graph.PersistableItem;
import iot.jcypher.graph.SyncState;
import iot.jcypher.graph.internal.ChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PersistableItemsContainer<T extends PersistableItem> {
    private List<T> elements;
    private List<T> removedElements;
    private ElementChangeListener elementChangeListener;

    abstract SyncState getContainerSyncState();

    abstract void setContainerSyncState(SyncState var1);

    protected abstract void fireContainerChanged(SyncState var1, SyncState var2);

    protected abstract boolean checkContainerForSyncState();

    protected abstract List<T> resolveElements();

    protected abstract boolean containsElement(List<T> var1, T var2);

    List<T> getModifiedElements() {
        ArrayList<PersistableItem> ret = new ArrayList<PersistableItem>();
        if (this.elements != null) {
            for (PersistableItem elem : this.elements) {
                if (elem.getSyncState() == SyncState.SYNC) continue;
                ret.add(elem);
            }
        }
        if (this.removedElements != null) {
            ret.addAll(this.removedElements);
        }
        return ret;
    }

    public List<T> getElements() {
        if (this.elements == null) {
            this.elements = this.resolveElements();
            if (this.elementChangeListener == null) {
                this.elementChangeListener = new ElementChangeListener();
            }
            for (PersistableItem elem : this.elements) {
                elem.addChangeListener(this.elementChangeListener);
            }
        }
        ArrayList<T> list = new ArrayList<T>(this.elements);
        return Collections.unmodifiableList(list);
    }

    public T addElement(T element) {
        this.getElements();
        if (!this.containsElement(this.elements, element)) {
            this.elements.add(element);
            ((PersistableItem)element).addChangeListener(this.elementChangeListener);
            ((PersistableItem)element).notifyState();
            return element;
        }
        throw new RuntimeException(element.toString() + " already exists");
    }

    public boolean checkForSyncState() {
        SyncState st = this.checkForElementStates(SyncState.SYNC);
        if (st == null) {
            return this.removedElements == null || this.removedElements.isEmpty();
        }
        return false;
    }

    private SyncState checkForElementStates(SyncState ... states) {
        if (this.elements != null) {
            for (PersistableItem elem : this.elements) {
                for (SyncState state : states) {
                    if (elem.getSyncState() == state) continue;
                    return elem.getSyncState();
                }
            }
        }
        return null;
    }

    void setToSynchronized() {
        this.removedElements = null;
        if (this.elements != null) {
            for (PersistableItem item : this.elements) {
                item.setToSynchronized();
            }
        }
    }

    private class ElementChangeListener
    implements ChangeListener {
        private ElementChangeListener() {
        }

        @Override
        public void changed(Object changedElement, SyncState oldState, SyncState newState) {
            if (newState == SyncState.REMOVED || newState == SyncState.NEW_REMOVED) {
                PersistableItemsContainer.this.elements.remove(changedElement);
                if (newState == SyncState.REMOVED) {
                    if (PersistableItemsContainer.this.removedElements == null) {
                        PersistableItemsContainer.this.removedElements = new ArrayList();
                    }
                    if (!PersistableItemsContainer.this.containsElement(PersistableItemsContainer.this.removedElements, (PersistableItem)changedElement)) {
                        PersistableItemsContainer.this.removedElements.add((PersistableItem)changedElement);
                    }
                }
            }
            SyncState myOldContainerState = PersistableItemsContainer.this.getContainerSyncState();
            if (PersistableItemsContainer.this.getContainerSyncState() == SyncState.SYNC) {
                if (newState != SyncState.SYNC) {
                    PersistableItemsContainer.this.setContainerSyncState(SyncState.CHANGED);
                }
            } else if (PersistableItemsContainer.this.getContainerSyncState() == SyncState.CHANGED && (newState == SyncState.NEW_REMOVED || newState == SyncState.SYNC) && PersistableItemsContainer.this.checkContainerForSyncState()) {
                PersistableItemsContainer.this.setContainerSyncState(SyncState.SYNC);
            }
            if (myOldContainerState != PersistableItemsContainer.this.getContainerSyncState()) {
                PersistableItemsContainer.this.fireContainerChanged(myOldContainerState, PersistableItemsContainer.this.getContainerSyncState());
            }
        }
    }
}

