/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query;

import iot.jcypher.query.LiteralMap;
import iot.jcypher.query.values.JcPrimitive;
import iot.jcypher.query.values.ValueAccess;
import java.math.BigDecimal;
import java.util.ArrayList;

public class LiteralMapList
extends ArrayList<LiteralMap> {
    private static final long serialVersionUID = 1L;

    LiteralMapList() {
    }

    LiteralMapList(int initialSize) {
        super(initialSize);
    }

    public LiteralMapList select(JcPrimitive key, Object value) {
        LiteralMapList ret = new LiteralMapList();
        for (LiteralMap lm : this) {
            if (!this.isEqual(value, lm.get(ValueAccess.getName(key)))) continue;
            ret.add(lm);
        }
        return ret;
    }

    public LiteralMapList select(String key, Object value) {
        LiteralMapList ret = new LiteralMapList();
        for (LiteralMap lm : this) {
            if (!this.isEqual(value, lm.get(key))) continue;
            ret.add(lm);
        }
        return ret;
    }

    public LiteralMap selectFirst(JcPrimitive key, Object value) {
        for (LiteralMap lm : this) {
            if (!this.isEqual(value, lm.get(ValueAccess.getName(key)))) continue;
            return lm;
        }
        return null;
    }

    public LiteralMap selectFirst(String key, Object value) {
        for (LiteralMap lm : this) {
            if (!this.isEqual(value, lm.get(key))) continue;
            return lm;
        }
        return null;
    }

    private boolean isEqual(Object value, Object mapValue) {
        if (mapValue instanceof BigDecimal) {
            if (value instanceof Integer) {
                return ((Number)value).intValue() == ((BigDecimal)mapValue).intValue();
            }
            if (value instanceof Long) {
                return ((Number)value).longValue() == ((BigDecimal)mapValue).longValue();
            }
            if (value instanceof Short) {
                return ((Number)value).shortValue() == ((BigDecimal)mapValue).shortValue();
            }
            if (value instanceof Byte) {
                return ((Number)value).byteValue() == ((BigDecimal)mapValue).byteValue();
            }
            if (value instanceof Double) {
                return ((Number)value).doubleValue() == ((BigDecimal)mapValue).doubleValue();
            }
            if (value instanceof Float) {
                return ((Number)value).floatValue() == ((BigDecimal)mapValue).floatValue();
            }
        }
        return value.equals(mapValue);
    }
}

