/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.api.collection;

import iot.jcypher.query.api.APIObject;
import iot.jcypher.query.api.APIObjectAccess;
import iot.jcypher.query.api.collection.DoConcat;
import iot.jcypher.query.api.modify.CopyProperties;
import iot.jcypher.query.api.modify.ModifyFactory;
import iot.jcypher.query.api.modify.ModifyTerminal;
import iot.jcypher.query.api.modify.Set;
import iot.jcypher.query.api.pattern.IElement;
import iot.jcypher.query.api.pattern.XFactory;
import iot.jcypher.query.ast.ASTNode;
import iot.jcypher.query.ast.ClauseType;
import iot.jcypher.query.ast.collection.CollectExpression;
import iot.jcypher.query.ast.collection.DoEvalExpression;
import iot.jcypher.query.ast.pattern.PatternExpression;
import iot.jcypher.query.values.JcElement;
import iot.jcypher.query.values.JcLabel;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcProperty;

public class Do
extends APIObject {
    Do(CollectExpression cx) {
        this.astNode = cx;
    }

    public Set<DoConcat> SET(JcProperty property) {
        Set<DoConcat> ret = ModifyFactory.setPropertyInFOREACH(property, this.createConcat());
        ModifyTerminal mt = ModifyFactory.createModifyTerminal(ret);
        ASTNode clause = APIObjectAccess.getAstNode(mt);
        clause.setClauseType(ClauseType.SET);
        DoEvalExpression doEval = (DoEvalExpression)((CollectExpression)this.astNode).getEvalExpression();
        doEval.getClauses().add(clause);
        return ret;
    }

    public DoConcat SET(JcLabel label) {
        ModifyTerminal mt = ModifyFactory.setLabel(label);
        ASTNode clause = APIObjectAccess.getAstNode(mt);
        clause.setClauseType(ClauseType.SET);
        return this.createConcat(clause);
    }

    public CopyProperties<DoConcat> copyPropertiesFrom(JcElement source) {
        CopyProperties<DoConcat> ret = ModifyFactory.copyPropertiesFromInFOREACH(source, this.createConcat());
        ModifyTerminal mt = ModifyFactory.createModifyTerminal(ret);
        ASTNode clause = APIObjectAccess.getAstNode(mt);
        clause.setClauseType(ClauseType.SET);
        DoEvalExpression doEval = (DoEvalExpression)((CollectExpression)this.astNode).getEvalExpression();
        doEval.getClauses().add(clause);
        return ret;
    }

    public DoConcat CREATE(IElement ... X2) {
        for (int i = 0; i < X2.length; ++i) {
            PatternExpression clause = XFactory.getExpression(X2[i]);
            clause.setClauseType(ClauseType.CREATE);
            this.addClause(clause);
        }
        return this.createConcat();
    }

    public DoConcat CREATE_UNIQUE(IElement ... X2) {
        for (int i = 0; i < X2.length; ++i) {
            PatternExpression clause = XFactory.getExpression(X2[i]);
            clause.setClauseType(ClauseType.CREATE_UNIQUE);
            this.addClause(clause);
        }
        return this.createConcat();
    }

    public DoConcat DELETE(JcElement element) {
        ModifyTerminal mt = ModifyFactory.deleteElement(element);
        ASTNode clause = APIObjectAccess.getAstNode(mt);
        clause.setClauseType(ClauseType.DELETE);
        return this.createConcat(clause);
    }

    public DoConcat DETACH_DELETE(JcNode node) {
        ModifyTerminal mt = ModifyFactory.deleteElement(node);
        ASTNode clause = APIObjectAccess.getAstNode(mt);
        clause.setClauseType(ClauseType.DETACH_DELETE);
        return this.createConcat(clause);
    }

    public DoConcat REMOVE(JcProperty property) {
        ModifyTerminal mt = ModifyFactory.removeProperty(property);
        ASTNode clause = APIObjectAccess.getAstNode(mt);
        clause.setClauseType(ClauseType.REMOVE);
        return this.createConcat(clause);
    }

    public DoConcat REMOVE(JcLabel label) {
        ModifyTerminal mt = ModifyFactory.removeLabel(label);
        ASTNode clause = APIObjectAccess.getAstNode(mt);
        clause.setClauseType(ClauseType.REMOVE);
        return this.createConcat(clause);
    }

    public DoConcat FOR_EACH(DoConcat F2) {
        ASTNode clause = APIObjectAccess.getAstNode(F2);
        clause.setClauseType(ClauseType.FOREACH);
        return this.createConcat(clause);
    }

    private DoConcat createConcat(ASTNode clause) {
        this.addClause(clause);
        return this.createConcat();
    }

    private void addClause(ASTNode clause) {
        DoEvalExpression doEval = (DoEvalExpression)((CollectExpression)this.astNode).getEvalExpression();
        doEval.getClauses().add(clause);
    }

    private DoConcat createConcat() {
        DoConcat ret = new DoConcat((CollectExpression)this.astNode, this);
        return ret;
    }
}

