/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.api.collection;

import iot.jcypher.query.api.APIObject;
import iot.jcypher.query.api.collection.CFactory;
import iot.jcypher.query.api.collection.ICollectExpression;
import iot.jcypher.query.api.collection.ICollection;
import iot.jcypher.query.ast.collection.CollectExpression;
import iot.jcypher.query.ast.collection.CollectionSpec;
import iot.jcypher.query.values.JcCollection;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcPath;
import java.util.ArrayList;

public class InCollection<T extends APIObject>
extends APIObject
implements ICollection<T> {
    private T connector;

    InCollection(CollectExpression cx, T connector) {
        this.astNode = cx;
        this.connector = connector;
    }

    @Override
    public T IN(ICollectExpression C2) {
        CollectionSpec cs = new CollectionSpec(CFactory.getRootCollectExpression((APIObject)((Object)C2)));
        return this.in(cs);
    }

    @Override
    public T IN(JcCollection collection) {
        CollectionSpec cs = new CollectionSpec(collection);
        return this.in(cs);
    }

    @Override
    public T IN_list(Object ... value) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] val = value;
        if (value.length == 1 && value[0].getClass().isArray()) {
            val = (Object[])value[0];
        }
        for (int i = 0; i < val.length; ++i) {
            list.add(val[i]);
        }
        CollectionSpec cs = new CollectionSpec(list);
        return this.in(cs);
    }

    @Override
    public T IN_nodes(JcPath path) {
        return (T)this.IN(path.nodes());
    }

    @Override
    public T IN_relations(JcPath path) {
        return (T)this.IN(path.relations());
    }

    @Override
    public T IN_labels(JcNode node) {
        return (T)this.IN(node.labels());
    }

    private T in(CollectionSpec cs) {
        ((CollectExpression)this.astNode).setCollectionToOperateOn(cs);
        return this.connector;
    }
}

