/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.ast.predicate;

import iot.jcypher.query.ast.ASTNode;
import iot.jcypher.query.ast.ClauseType;
import iot.jcypher.query.ast.collection.CollectExpression;
import iot.jcypher.query.ast.predicate.IPredicateHolder;
import iot.jcypher.query.ast.predicate.Predicate;
import iot.jcypher.query.ast.predicate.PredicateConcatenator;

public class PredicateExpression
extends ASTNode
implements IPredicateHolder {
    private PredicateExpression parent;
    private Predicate predicate;
    private CollectExpression containingCollectExpression;

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void setPredicate(Predicate predicate) {
        if (this.predicate != null) {
            predicate.setNotCount(this.predicate.getNotCount() + predicate.getNotCount());
        }
        this.predicate = predicate;
    }

    public Predicate getLastPredicate() {
        Predicate pred;
        Predicate last = pred = this.predicate;
        while (pred != null) {
            last = pred;
            PredicateConcatenator next = pred.getNext();
            if (next != null) {
                pred = next.getPredicate();
                continue;
            }
            pred = null;
        }
        return last;
    }

    public IPredicateHolder getLastPredicateHolder() {
        if (this.predicate == null) {
            return this;
        }
        PredicateExpression last = null;
        IPredicateHolder ret = this;
        while (ret != null) {
            last = ret;
            Predicate pred = ret.getPredicate();
            if (pred != null) {
                ret = pred.getNext();
                continue;
            }
            ret = null;
        }
        return last;
    }

    public PredicateExpression getParent() {
        return this.parent;
    }

    public PredicateExpression getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    public void setParent(PredicateExpression parent) {
        this.parent = parent;
        if (this.parent != null && this.getClauseType() != null) {
            this.parent.setClauseType(this.getClauseType());
        }
    }

    @Override
    public void setClauseType(ClauseType clauseType) {
        super.setClauseType(clauseType);
        if (this.parent != null) {
            this.parent.setClauseType(clauseType);
        }
    }

    public CollectExpression getContainingCollectExpression() {
        return this.containingCollectExpression;
    }

    public void setContainingCollectExpression(CollectExpression containingCollectExpression) {
        this.containingCollectExpression = containingCollectExpression;
    }
}

