/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.result.util;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.graph.GrAccess;
import iot.jcypher.graph.GrLabel;
import iot.jcypher.graph.SyncState;
import iot.jcypher.query.InternalQAccess;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.factories.clause.RETURN;
import iot.jcypher.query.factories.clause.START;
import iot.jcypher.query.result.util.ResultHandler;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcRelation;
import iot.jcypher.util.ResultSettings;
import iot.jcypher.util.Util;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.driver.v1.types.Type;
import org.neo4j.driver.v1.util.Pair;

public class BoltContentHandler
extends ResultHandler.AContentHandler {
    private List<Record> records;
    private Reloaded reloaded;

    public BoltContentHandler(StatementResult statementResult, ResultHandler rh) {
        this.records = statementResult != null ? statementResult.list() : new ArrayList<Record>();
        this.reloaded = new Reloaded(rh.getDbAccess());
    }

    @Override
    public List<String> getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        if (this.records.size() > 0) {
            Record rec = this.records.get(0);
            columns.addAll(rec.keys());
        }
        return columns;
    }

    @Override
    public int getColumnIndex(String colKey) {
        if (this.records.size() > 0) {
            int idx;
            Record rec = this.records.get(0);
            try {
                idx = rec.index(colKey);
            }
            catch (NoSuchElementException e) {
                idx = -1;
            }
            return idx;
        }
        return -1;
    }

    @Override
    public Iterator<ResultHandler.AContentHandler.RowOrRecord> getDataIterator() {
        return new RecordIterator();
    }

    @Override
    public Object convertContentValue(Object value) {
        if (value instanceof Value) {
            InternalTypeSystem ts;
            Value val = (Value)value;
            ArrayList<Object> ret = null;
            Type typ = val.type();
            if (typ == (ts = InternalTypeSystem.TYPE_SYSTEM).NUMBER()) {
                ret = new BigDecimal(val.asNumber().toString());
            } else if (typ == ts.INTEGER()) {
                ret = new BigDecimal(val.asNumber().toString());
            } else if (typ == ts.FLOAT()) {
                ret = new BigDecimal(val.asNumber().toString());
            } else if (typ == ts.STRING()) {
                ret = val.asString();
            } else if (typ == ts.BOOLEAN()) {
                ret = val.asBoolean();
            } else if (typ == ts.LIST()) {
                List orgVals = val.asList();
                ArrayList<Object> vals = new ArrayList<Object>();
                int sz = orgVals.size();
                for (int i = 0; i < sz; ++i) {
                    Object v = orgVals.get(i);
                    vals.add(this.convertContentValue(v));
                }
                ret = vals;
            } else if (typ == ts.ANY()) {
                ret = val.asObject();
            }
            return ret;
        }
        return value;
    }

    @Override
    public Iterator<ResultHandler.AContentHandler.PropEntry> getPropertiesIterator(long id, int rowIndex, ResultHandler.ElemType typ) {
        Entity propertiesObject = this.getPropertiesObject(id, rowIndex, typ);
        Iterator<Map.Entry<String, Object>> esIt = propertiesObject.asMap().entrySet().iterator();
        return new PropertiesIterator(esIt);
    }

    @Override
    public String getRelationType(long relationId, int rowIndex) {
        if (rowIndex >= 0) {
            Relationship rel = (Relationship)this.getPropertiesObject(relationId, rowIndex, ResultHandler.ElemType.RELATION);
            return rel.type();
        }
        return null;
    }

    @Override
    public List<GrLabel> getNodeLabels(long nodeId, int rowIndex) {
        ArrayList<GrLabel> labels = new ArrayList<GrLabel>();
        if (rowIndex >= 0) {
            Node nd = (Node)this.getPropertiesObject(nodeId, rowIndex, ResultHandler.ElemType.NODE);
            for (String lab : nd.labels()) {
                GrLabel label = GrAccess.createLabel(lab);
                GrAccess.setState(label, SyncState.SYNC);
                labels.add(label);
            }
        }
        return labels;
    }

    private Entity getPropertiesObject(long id, int rowIndex, ResultHandler.ElemType typ) {
        Record rec = this.records.get(rowIndex);
        List flds = rec.fields();
        for (Pair pair : flds) {
            Relationship rel;
            if (typ == ResultHandler.ElemType.NODE && pair.value() instanceof NodeValue) {
                Node nd = ((Value)pair.value()).asNode();
                if (nd.id() != id) continue;
                return nd;
            }
            if (typ != ResultHandler.ElemType.RELATION || !(pair.value() instanceof RelationshipValue) || (rel = ((Value)pair.value()).asRelationship()).id() != id) continue;
            return rel;
        }
        return this.reloaded.getEntity(id, typ);
    }

    private class Reloaded {
        private Map<Long, Node> nodesById;
        private Map<Long, Relationship> relationsById;
        private IDBAccess dbAccess;

        private Reloaded(IDBAccess dba) {
            this.dbAccess = dba;
        }

        private Entity getEntity(long id, ResultHandler.ElemType typ) {
            if (typ == ResultHandler.ElemType.NODE) {
                return this.getNode(id);
            }
            return this.getRelation(id);
        }

        private Node getNode(long id) {
            Node ret;
            if (this.nodesById == null) {
                this.nodesById = new HashMap<Long, Node>();
            }
            if ((ret = this.nodesById.get(id)) == null) {
                ret = (Node)this.loadPropertiesObject(id, ResultHandler.ElemType.NODE);
                this.nodesById.put(id, ret);
            }
            return ret;
        }

        private Relationship getRelation(long id) {
            Relationship ret;
            if (this.relationsById == null) {
                this.relationsById = new HashMap<Long, Relationship>();
            }
            if ((ret = this.relationsById.get(id)) == null) {
                ret = (Relationship)this.loadPropertiesObject(id, ResultHandler.ElemType.RELATION);
                this.relationsById.put(id, ret);
            }
            return ret;
        }

        private Entity loadPropertiesObject(long id, ResultHandler.ElemType typ) {
            IClause[] clauses;
            if (typ == ResultHandler.ElemType.NODE) {
                JcNode n = new JcNode("n");
                clauses = new IClause[]{START.node(n).byId(id), RETURN.value(n)};
            } else {
                JcRelation r = new JcRelation("r");
                clauses = new IClause[]{START.relation(r).byId(id), RETURN.value(r)};
            }
            JcQuery q = new JcQuery();
            q.setClauses(clauses);
            JcQueryResult result = this.dbAccess.execute(q);
            if (result.hasErrors()) {
                StringBuilder sb = new StringBuilder();
                Util.appendErrorList(Util.collectErrors(result), sb);
                throw new RuntimeException(sb.toString());
            }
            BoltContentHandler ch = (BoltContentHandler)InternalQAccess.getResultHandler(result).getContentHandler();
            return ch.getPropertiesObject(id, 0, typ);
        }
    }

    public class PropertiesIterator
    implements Iterator<ResultHandler.AContentHandler.PropEntry> {
        private Iterator<Map.Entry<String, Object>> iterator;

        public PropertiesIterator(Iterator<Map.Entry<String, Object>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ResultHandler.AContentHandler.PropEntry next() {
            Map.Entry<String, Object> next = this.iterator.next();
            return new ResultHandler.AContentHandler.PropEntry(next.getKey(), next.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class RecordIterator
    implements Iterator<ResultHandler.AContentHandler.RowOrRecord> {
        private Iterator<Record> recordIterator;

        public RecordIterator() {
            this.recordIterator = BoltContentHandler.this.records.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.recordIterator.hasNext();
        }

        @Override
        public ResultHandler.AContentHandler.RowOrRecord next() {
            Record nextVal = this.recordIterator.next();
            return new Rec(nextVal);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public class Rec
        extends ResultHandler.AContentHandler.RowOrRecord {
            private Record record;

            public Rec(Record record) {
                super(BoltContentHandler.this);
                this.record = record;
            }

            @Override
            public ResultHandler.ElementInfo getElementInfo(String colKey) {
                Value val;
                try {
                    val = this.record.get(colKey);
                }
                catch (NoSuchRecordException e) {
                    throw new RuntimeException("no result column: " + colKey);
                }
                return ResultHandler.ElementInfo.fromRecordValue(val);
            }

            @Override
            public ResultHandler.RelationInfo getRelationInfo(String colKey) {
                Value val = this.record.get(colKey);
                return ResultHandler.RelationInfo.fromRecordValue(val);
            }

            @Override
            public ResultHandler.PathInfo getPathInfo(String colKey) {
                Value val;
                ResultHandler.PathInfo pathInfo = null;
                try {
                    val = this.record.get(colKey);
                }
                catch (NoSuchRecordException e) {
                    throw new RuntimeException("no result column: " + colKey);
                }
                String typName = val.type().name();
                if ("PATH".equals(typName)) {
                    Path p = val.asPath();
                    long startId = p.start().id();
                    long endId = p.end().id();
                    ArrayList<Long> relIds = new ArrayList<Long>();
                    for (Relationship rel : p.relationships()) {
                        relIds.add(rel.id());
                    }
                    pathInfo = new ResultHandler.PathInfo(startId, endId, relIds, p);
                }
                return pathInfo;
            }

            @Override
            public long gePathtNodeIdAt(ResultHandler.PathInfo pathInfo, int index) {
                Object obj = pathInfo.getContentObject();
                ArrayList nodes = null;
                if (obj instanceof List) {
                    nodes = (ArrayList)obj;
                } else if (obj instanceof Path) {
                    nodes = new ArrayList();
                    Iterator it = ((Path)obj).nodes().iterator();
                    while (it.hasNext()) {
                        nodes.add(it.next());
                    }
                    pathInfo.setContentObject(nodes);
                }
                return ((Node)nodes.get(index)).id();
            }

            @Override
            public <T> void addValue(String colKey, List<T> vals) {
                Value val;
                try {
                    val = this.record.get(colKey);
                }
                catch (NoSuchRecordException e) {
                    throw new RuntimeException("no result column: " + colKey);
                }
                Object v = BoltContentHandler.this.convertContentValue(val);
                if (v != null) {
                    vals.add(v);
                } else if (ResultHandler.includeNullValues.get().booleanValue() || ResultSettings.includeNullValuesAndDuplicates.get().booleanValue()) {
                    vals.add(v);
                }
            }
        }
    }
}

