/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.result.util;

import iot.jcypher.graph.GrAccess;
import iot.jcypher.graph.GrLabel;
import iot.jcypher.graph.SyncState;
import iot.jcypher.query.result.util.ResultHandler;
import iot.jcypher.util.ResultSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JSONContentHandler
extends ResultHandler.AContentHandler {
    private JsonObject jsonResult;
    private int queryIndex;
    private List<String> columns;
    private Map<String, Integer> columnIndices;

    public JSONContentHandler(JsonObject jsonResult, int queryIndex) {
        this.jsonResult = jsonResult;
        this.queryIndex = queryIndex;
        this.columnIndices = new HashMap<String, Integer>();
    }

    @Override
    public List<String> getColumns() {
        if (this.columns == null) {
            ArrayList<String> colmns = new ArrayList<String>();
            JsonArray cols = ((JsonObject)this.jsonResult.getJsonArray("results").get(this.queryIndex)).getJsonArray("columns");
            int sz = cols.size();
            for (int i = 0; i < sz; ++i) {
                colmns.add(cols.getString(i));
            }
            this.columns = colmns;
        }
        return this.columns;
    }

    @Override
    public Iterator<ResultHandler.AContentHandler.RowOrRecord> getDataIterator() {
        return new RowIterator();
    }

    @Override
    public int getColumnIndex(String colKey) {
        Integer idx = this.columnIndices.get(colKey);
        if (idx == null) {
            List<String> cols = this.getColumns();
            for (int i = 0; i < cols.size(); ++i) {
                if (!cols.get(i).equals(colKey)) continue;
                idx = new Integer(i);
            }
            if (idx == null) {
                idx = new Integer(-1);
            }
            this.columnIndices.put(colKey, idx);
        }
        return idx;
    }

    @Override
    public Object convertContentValue(Object value) {
        if (value instanceof JsonValue) {
            JsonValue val = (JsonValue)value;
            ArrayList<Object> ret = null;
            JsonValue.ValueType typ = val.getValueType();
            if (typ == JsonValue.ValueType.NUMBER) {
                ret = ((JsonNumber)val).bigDecimalValue();
            } else if (typ == JsonValue.ValueType.STRING) {
                ret = ((JsonString)val).getString();
            } else if (typ == JsonValue.ValueType.FALSE) {
                ret = Boolean.FALSE;
            } else if (typ == JsonValue.ValueType.TRUE) {
                ret = Boolean.TRUE;
            } else if (typ == JsonValue.ValueType.ARRAY) {
                JsonArray arr = (JsonArray)val;
                ArrayList<Object> vals = new ArrayList<Object>();
                int sz = arr.size();
                for (int i = 0; i < sz; ++i) {
                    JsonValue v = (JsonValue)arr.get(i);
                    vals.add(this.convertContentValue(v));
                }
                ret = vals;
            } else if (typ == JsonValue.ValueType.OBJECT) {
                // empty if block
            }
            return ret;
        }
        return value;
    }

    @Override
    public Iterator<ResultHandler.AContentHandler.PropEntry> getPropertiesIterator(long id, int rowIndex, ResultHandler.ElemType typ) {
        JsonObject propertiesObject = this.getPropertiesObject(id, rowIndex, typ);
        Iterator<Map.Entry<String, JsonValue>> esIt = propertiesObject.entrySet().iterator();
        return new PropertiesIterator(esIt);
    }

    @Override
    public String getRelationType(long relationId, int rowIndex) {
        if (rowIndex >= 0) {
            JsonObject graphObject = this.getGraphObject(rowIndex);
            JsonArray elemsArray = graphObject.getJsonArray("relationships");
            int sz = elemsArray.size();
            for (int i = 0; i < sz; ++i) {
                long elemId;
                JsonObject elem = elemsArray.getJsonObject(i);
                String idStr = elem.getString("id");
                try {
                    elemId = Long.parseLong(idStr);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                if (relationId != elemId) continue;
                return elem.getString("type");
            }
        }
        return null;
    }

    @Override
    public List<GrLabel> getNodeLabels(long nodeId, int rowIndex) {
        ArrayList<GrLabel> labels = new ArrayList<GrLabel>();
        if (rowIndex >= 0) {
            JsonArray labelsArray = this.getNodeLabelsObject(nodeId, rowIndex);
            int sz = labelsArray.size();
            for (int i = 0; i < sz; ++i) {
                GrLabel label = GrAccess.createLabel(labelsArray.getString(i));
                GrAccess.setState(label, SyncState.SYNC);
                labels.add(label);
            }
        }
        return labels;
    }

    private JsonArray getNodeLabelsObject(long id, int rowIndex) {
        JsonObject graphObject = this.getGraphObject(rowIndex);
        JsonArray elemsArray = graphObject.getJsonArray("nodes");
        int sz = elemsArray.size();
        for (int i = 0; i < sz; ++i) {
            long elemId;
            JsonObject elem = elemsArray.getJsonObject(i);
            String idStr = elem.getString("id");
            try {
                elemId = Long.parseLong(idStr);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            if (id != elemId) continue;
            return elem.getJsonArray("labels");
        }
        return null;
    }

    private JsonArray getRestArray(JsonObject dataObject) {
        return dataObject.getJsonArray("rest");
    }

    private JsonValue getRestValue(JsonArray restArray, int colIdx) {
        return (JsonValue)restArray.get(colIdx);
    }

    private JsonArray getDataArray() {
        return ((JsonObject)this.jsonResult.getJsonArray("results").get(this.queryIndex)).getJsonArray("data");
    }

    private JsonObject getDataObject(int rowIndex) {
        JsonArray datas = this.getDataArray();
        return datas.getJsonObject(rowIndex);
    }

    private JsonObject getGraphObject(int rowIndex) {
        JsonObject dataObject = this.getDataObject(rowIndex);
        return dataObject.getJsonObject("graph");
    }

    private JsonObject getPropertiesObject(long id, int rowIndex, ResultHandler.ElemType typ) {
        JsonObject graphObject = this.getGraphObject(rowIndex);
        JsonArray elemsArray = null;
        if (typ == ResultHandler.ElemType.NODE) {
            elemsArray = graphObject.getJsonArray("nodes");
        } else if (typ == ResultHandler.ElemType.RELATION) {
            elemsArray = graphObject.getJsonArray("relationships");
        }
        int sz = elemsArray.size();
        for (int i = 0; i < sz; ++i) {
            long elemId;
            JsonObject elem = elemsArray.getJsonObject(i);
            String idStr = elem.getString("id");
            try {
                elemId = Long.parseLong(idStr);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            if (id != elemId) continue;
            return elem.getJsonObject("properties");
        }
        return null;
    }

    public class PropertiesIterator
    implements Iterator<ResultHandler.AContentHandler.PropEntry> {
        private Iterator<Map.Entry<String, JsonValue>> iterator;

        public PropertiesIterator(Iterator<Map.Entry<String, JsonValue>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ResultHandler.AContentHandler.PropEntry next() {
            Map.Entry<String, JsonValue> next = this.iterator.next();
            return new ResultHandler.AContentHandler.PropEntry(next.getKey(), next.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class RowIterator
    implements Iterator<ResultHandler.AContentHandler.RowOrRecord> {
        private Iterator<JsonValue> jsonIterator;

        public RowIterator() {
            JsonArray datas = JSONContentHandler.this.getDataArray();
            this.jsonIterator = datas.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.jsonIterator.hasNext();
        }

        @Override
        public ResultHandler.AContentHandler.RowOrRecord next() {
            JsonValue nextVal = this.jsonIterator.next();
            return new Row(nextVal);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public class Row
        extends ResultHandler.AContentHandler.RowOrRecord {
            private JsonValue jsonValue;

            public Row(JsonValue jsonValue) {
                super(JSONContentHandler.this);
                this.jsonValue = jsonValue;
            }

            @Override
            public ResultHandler.ElementInfo getElementInfo(String colKey) {
                int colIdx = JSONContentHandler.this.getColumnIndex(colKey);
                if (colIdx == -1) {
                    throw new RuntimeException("no result column: " + colKey);
                }
                JsonObject dataObject = (JsonObject)this.jsonValue;
                JsonArray restArray = JSONContentHandler.this.getRestArray(dataObject);
                JsonValue obj = JSONContentHandler.this.getRestValue(restArray, colIdx);
                if ((obj = this.handleArrayCase(obj)).getValueType() == JsonValue.ValueType.OBJECT) {
                    String selfString;
                    JsonObject restObject = (JsonObject)obj;
                    if (restObject.containsKey((Object)"self") && (selfString = restObject.getString("self")) != null) {
                        ResultHandler.ElementInfo ei = ResultHandler.ElementInfo.parse(selfString);
                        return ei;
                    }
                } else if (obj.getValueType() == JsonValue.ValueType.NULL) {
                    ResultHandler.ElementInfo ei = ResultHandler.ElementInfo.nullElement();
                    return ei;
                }
                return null;
            }

            @Override
            public ResultHandler.RelationInfo getRelationInfo(String colKey) {
                JsonObject dataObject = (JsonObject)this.jsonValue;
                JsonArray restArray = JSONContentHandler.this.getRestArray(dataObject);
                JsonValue restObject = JSONContentHandler.this.getRestValue(restArray, JSONContentHandler.this.getColumnIndex(colKey));
                restObject = this.handleArrayCase(restObject);
                String startString = ((JsonObject)restObject).getString("start");
                String endString = ((JsonObject)restObject).getString("end");
                ResultHandler.RelationInfo ri = ResultHandler.RelationInfo.parse(startString, endString);
                return ri;
            }

            @Override
            public ResultHandler.PathInfo getPathInfo(String colKey) {
                ResultHandler.PathInfo pathInfo = null;
                int colIdx = JSONContentHandler.this.getColumnIndex(colKey);
                if (colIdx == -1) {
                    throw new RuntimeException("no result column: " + colKey);
                }
                JsonObject dataObject = (JsonObject)this.jsonValue;
                JsonArray restArray = JSONContentHandler.this.getRestArray(dataObject);
                JsonValue restValue = JSONContentHandler.this.getRestValue(restArray, colIdx);
                if ((restValue = this.handleArrayCase(restValue)).getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject pathObject = (JsonObject)restValue;
                    String str = pathObject.getString("start");
                    long startId = Long.parseLong(str.substring(str.lastIndexOf(47) + 1));
                    str = pathObject.getString("end");
                    long endId = Long.parseLong(str.substring(str.lastIndexOf(47) + 1));
                    JsonArray rels = pathObject.getJsonArray("relationships");
                    ArrayList<Long> relIds = new ArrayList<Long>();
                    int sz = rels.size();
                    for (int i = 0; i < sz; ++i) {
                        String rel = rels.getString(i);
                        long rid = Long.parseLong(rel.substring(rel.lastIndexOf(47) + 1));
                        relIds.add(rid);
                    }
                    pathInfo = new ResultHandler.PathInfo(startId, endId, relIds, pathObject);
                }
                return pathInfo;
            }

            @Override
            public long gePathtNodeIdAt(ResultHandler.PathInfo pathInfo, int index) {
                Object obj = pathInfo.getContentObject();
                JsonArray nodes = null;
                if (obj instanceof JsonArray) {
                    nodes = (JsonArray)obj;
                } else if (obj instanceof JsonObject) {
                    nodes = ((JsonObject)obj).getJsonArray("nodes");
                    pathInfo.setContentObject(nodes);
                }
                String str = nodes.getString(index);
                return Long.parseLong(str.substring(str.lastIndexOf(47) + 1));
            }

            @Override
            public <T> void addValue(String colKey, List<T> vals) {
                int colIdx = JSONContentHandler.this.getColumnIndex(colKey);
                if (colIdx == -1) {
                    throw new RuntimeException("no result column: " + colKey);
                }
                JsonValue restVal = JSONContentHandler.this.getRestValue(JSONContentHandler.this.getRestArray((JsonObject)this.jsonValue), colIdx);
                Object v = JSONContentHandler.this.convertContentValue(restVal);
                if (v != null) {
                    vals.add(v);
                } else if (ResultHandler.includeNullValues.get().booleanValue() || ResultSettings.includeNullValuesAndDuplicates.get().booleanValue()) {
                    vals.add(v);
                }
            }

            private JsonValue handleArrayCase(JsonValue obj) {
                if (obj.getValueType() == JsonValue.ValueType.ARRAY && ((JsonArray)obj).size() > 0) {
                    return (JsonValue)((JsonArray)obj).get(0);
                }
                return obj;
            }
        }
    }
}

