/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.values;

import iot.jcypher.domainquery.internal.QueryRecorder;
import iot.jcypher.query.values.FunctionInstance;
import iot.jcypher.query.values.IOperatorOrFunction;
import iot.jcypher.query.values.JcNumber;
import iot.jcypher.query.values.JcProperty;
import iot.jcypher.query.values.JcValue;
import iot.jcypher.query.values.ValueElement;
import iot.jcypher.query.values.functions.FUNCTION;
import iot.jcypher.query.values.operators.OPERATOR;
import java.util.Collection;
import java.util.List;

public class JcCollection
extends JcValue {
    private Object value;

    JcCollection() {
    }

    public JcCollection(String name) {
        super(name);
    }

    public JcCollection(List<?> list) {
        this(JcCollection.fromPrimitiveList(list), null, null);
    }

    JcCollection(String name, ValueElement predecessor, IOperatorOrFunction opf) {
        super(name, predecessor, opf);
    }

    JcCollection(String name, Object val, ValueElement predecessor, IOperatorOrFunction opf) {
        super(name, predecessor, opf);
        this.value = val;
    }

    public JcNumber length() {
        JcNumber ret = new JcNumber((Object)null, (ValueElement)this, (IOperatorOrFunction)new FunctionInstance(FUNCTION.Collection.LENGTH, 1));
        QueryRecorder.recordInvocationConditional(this, "length", (Object)ret, new Object[0]);
        return ret;
    }

    public JcCollection add(Object value) {
        JcCollection ret = new JcCollection(null, value, this, OPERATOR.Collection.ADD);
        QueryRecorder.recordInvocationConditional(this, "add", (Object)ret, QueryRecorder.placeHolder(value));
        return ret;
    }

    public JcCollection addAll(Collection<?> coll) {
        JcCollection ret = new JcCollection(null, coll, this, OPERATOR.Collection.ADD_ALL);
        QueryRecorder.recordInvocationConditional(this, "addAll", (Object)ret, QueryRecorder.literal(coll));
        return ret;
    }

    public JcProperty get(int index) {
        JcProperty ret = new JcProperty(null, this, OPERATOR.Collection.GET);
        ret.setHint("v_op", index);
        QueryRecorder.recordInvocationConditional(this, "get", (Object)ret, QueryRecorder.literal(index));
        return ret;
    }

    public JcProperty get(JcNumber indexExpression) {
        JcProperty ret = new JcProperty(null, this, OPERATOR.Collection.GET);
        ret.setHint("v_op", indexExpression);
        QueryRecorder.recordInvocationConditional(this, "get", (Object)ret, QueryRecorder.placeHolder(indexExpression));
        return ret;
    }

    public ValueElement head() {
        ValueElement ret = new ValueElement(this, new FunctionInstance(FUNCTION.Collection.HEAD, 1));
        QueryRecorder.recordInvocationConditional(this, "head", (Object)ret, new Object[0]);
        return ret;
    }

    public ValueElement last() {
        ValueElement ret = new ValueElement(this, new FunctionInstance(FUNCTION.Collection.LAST, 1));
        QueryRecorder.recordInvocationConditional(this, "last", (Object)ret, new Object[0]);
        return ret;
    }

    Object getValue() {
        return this.value;
    }

    private static String fromPrimitiveList(List<?> list) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (list != null) {
            int idx = 0;
            for (Object val : list) {
                if (idx > 0) {
                    sb.append(", ");
                }
                if (val instanceof String) {
                    sb.append('\'');
                    sb.append(val.toString());
                    sb.append('\'');
                } else {
                    sb.append(val.toString());
                }
                ++idx;
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

