/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.values;

import iot.jcypher.query.values.FunctionInstance;
import iot.jcypher.query.values.JcNumber;
import iot.jcypher.query.values.JcPrimitive;
import iot.jcypher.query.values.JcValue;
import iot.jcypher.query.values.MathFunctions;
import iot.jcypher.query.values.ValueElement;
import iot.jcypher.query.values.functions.FUNCTION;
import iot.jcypher.query.values.operators.OPERATOR;

public class ValueAccess {
    static final String hintKey_opValue = "v_op";

    public static JcValue timeStamp() {
        return new JcValue(null, null, new FunctionInstance(FUNCTION.Common.TIMESTAMP));
    }

    public static JcValue coalesce(ValueElement ... expression) {
        ValueElement next = null;
        ValueElement last = null;
        boolean init = true;
        for (int i = expression.length - 1; i >= 0; --i) {
            if (next != null) {
                next = ValueAccess.findAndCloneFirst(next);
                if (init) {
                    if (ValueAccess.findFirst(last) == last) {
                        last = next;
                    }
                    init = false;
                }
                next.setPredecessor(expression[i]);
                next.setOperatorOrFunction(OPERATOR.Common.COMMA_SEPARATOR);
            } else {
                last = expression[i];
            }
            next = expression[i];
        }
        return new JcValue(null, last, new FunctionInstance(FUNCTION.Common.COALESCE, expression.length));
    }

    private static ValueElement findAndCloneFirst(ValueElement ve) {
        ValueElement ret;
        ValueElement next = null;
        ValueElement first = ve;
        while (first.getPredecessor() != null) {
            next = first;
            first = first.getPredecessor();
        }
        try {
            ret = (ValueElement)first.getClass().newInstance();
            ret.setOperatorOrFunction(first.getOperatorOrFunction());
            ret.setPredecessor(first.getPredecessor());
            if (ret instanceof JcPrimitive) {
                ((JcPrimitive)ret).setValue(((JcPrimitive)first).getValue());
            } else if (ret instanceof JcValue) {
                ((JcValue)ret).setName(((JcValue)first).getName());
            }
            if (next != null) {
                next.setPredecessor(ret);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static ValueElement findFirst(ValueElement ve) {
        ValueElement first = ve;
        while (first.getPredecessor() != null) {
            first = first.getPredecessor();
        }
        return first;
    }

    public static String getName(JcValue jcValue) {
        return jcValue.getName();
    }

    public static void setName(String name, JcValue jcValue) {
        jcValue.setName(name);
    }

    public static Object getValue(JcPrimitive jcPrimitive) {
        return jcPrimitive.getValue();
    }

    public static ValueElement getPredecessor(ValueElement ve) {
        return ve.getPredecessor();
    }

    public static void setPredecessor(ValueElement ve, ValueElement predecessor) {
        ve.setPredecessor(predecessor);
    }

    public static ValueElement cloneShallow(ValueElement ve) {
        return ve.cloneShallow();
    }

    public static void setHint(ValueElement ve, String key, Object hint) {
        ve.setHint(key, hint);
    }

    public static Object getAnyHint(ValueElement ve, String key) {
        for (ValueElement toTest = ve; toTest != null; toTest = toTest.getPredecessor()) {
            Object hint = toTest.getHint(key);
            if (hint == null) continue;
            return hint;
        }
        return null;
    }

    public static boolean isSame(JcValue val1, JcValue val2) {
        return val1.getName() != null && val1.getName().equals(val2.getName());
    }

    public static JcNumber getArgument(MathFunctions math) {
        return math.getArgument();
    }
}

