/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.values;

import iot.jcypher.query.values.FunctionCapsule;
import iot.jcypher.query.values.FunctionInstance;
import iot.jcypher.query.values.IFragment;
import iot.jcypher.query.values.IOperatorOrFunction;
import iot.jcypher.query.values.JcCollection;
import iot.jcypher.query.values.JcNumber;
import iot.jcypher.query.values.JcPrimitive;
import iot.jcypher.query.values.JcString;
import iot.jcypher.query.values.JcValue;
import iot.jcypher.query.values.Operator;
import iot.jcypher.query.values.ValueElement;
import iot.jcypher.query.values.operators.OPERATOR;
import iot.jcypher.query.values.operators.OPTYPE;
import iot.jcypher.query.writer.CypherWriter;
import iot.jcypher.query.writer.WriterContext;
import java.util.ArrayList;

public class ValueWriter {
    public static void toValueExpression(ValueElement valueElem, WriterContext context, StringBuilder sb) {
        ArrayList<Object> elementList = new ArrayList<Object>();
        int insertIndex = 0;
        ArrayList<FunctionStackEntry> functionStack = new ArrayList<FunctionStackEntry>();
        for (ValueElement ve = valueElem; ve != null; ve = ve.getPredecessor()) {
            if (ve.getOperatorOrFunction() instanceof FunctionInstance) {
                FunctionInstance fi = (FunctionInstance)ve.getOperatorOrFunction();
                FunctionCapsule.FunctionStart start = new FunctionCapsule.FunctionStart(fi.getFunction().getPrefix());
                FunctionCapsule.FunctionEnd functionEnd = new FunctionCapsule.FunctionEnd(fi.getFunction().getPostfix());
                functionStack.add(0, new FunctionStackEntry(fi, start));
                elementList.add(insertIndex, functionEnd);
                elementList.add(insertIndex, start);
                ++insertIndex;
            }
            elementList.add(insertIndex, ve);
            if (!(ve.getOperatorOrFunction() instanceof Operator) || (Operator)ve.getOperatorOrFunction() != OPERATOR.Common.COMMA_SEPARATOR) continue;
            FunctionStackEntry outmost = null;
            while (functionStack.size() > 0) {
                FunctionStackEntry fe = (FunctionStackEntry)functionStack.get(0);
                fe.remainingNumArgs--;
                if (fe.remainingNumArgs > 0) break;
                outmost = fe;
                functionStack.remove(0);
                --insertIndex;
            }
            if (outmost == null) continue;
            outmost.functionStart.setOperator((Operator)ve.getOperatorOrFunction());
            ve.setOperatorOrFunction(null);
        }
        int idx = 0;
        for (IFragment iFragment : elementList) {
            ValueWriter.toValueExpression(iFragment, idx, context, sb);
            ++idx;
        }
    }

    private static void toValueExpression(IFragment ifragment, int index, WriterContext context, StringBuilder sb) {
        if (ifragment instanceof ValueElement) {
            boolean writeAsValue = true;
            ValueElement valueElem = (ValueElement)ifragment;
            IOperatorOrFunction opf = valueElem.getOperatorOrFunction();
            if (opf instanceof Operator) {
                Object opVal;
                sb.append(((Operator)opf).getPrettySymbol());
                if (((Operator)opf).getType() == OPTYPE.PropertyContainer.PROPERTY_ACCESS) {
                    writeAsValue = false;
                } else if (((Operator)opf).getType() == OPTYPE.Node.LABEL_ACCESS) {
                    writeAsValue = false;
                }
                if (((Operator)opf).getPostfixSymbol() != null && (opVal = valueElem.getHint("v_op")) != null) {
                    if (opVal instanceof ValueElement) {
                        ValueWriter.toValueExpression((ValueElement)opVal, context, sb);
                    } else {
                        CypherWriter.PrimitiveCypherWriter.writePrimitiveValue(opVal, context, sb);
                    }
                    sb.append(((Operator)opf).getPostfixSymbol());
                }
            }
            boolean nameWritten = false;
            if (valueElem instanceof JcValue && ((JcValue)valueElem).getName() != null && (!(valueElem instanceof JcString) && !(valueElem instanceof JcNumber) || ((JcPrimitive)valueElem).getValue() == null)) {
                sb.append(((JcValue)valueElem).getName());
                nameWritten = true;
            }
            Object listVal = null;
            if (!nameWritten && valueElem instanceof JcCollection) {
                listVal = ((JcCollection)valueElem).getValue();
            }
            if ((valueElem instanceof JcPrimitive || listVal != null) && !nameWritten) {
                Object val;
                Object object = val = listVal != null ? listVal : ((JcPrimitive)valueElem).getValue();
                if (val instanceof ValueElement) {
                    ValueWriter.toValueExpression((ValueElement)val, context, sb);
                } else if (val != null) {
                    if (writeAsValue) {
                        CypherWriter.PrimitiveCypherWriter.writePrimitiveValue(val, context, sb);
                    } else {
                        sb.append(val.toString());
                    }
                }
            }
        } else if (ifragment instanceof FunctionCapsule) {
            Operator op;
            if (ifragment instanceof FunctionCapsule.FunctionStart && (op = ((FunctionCapsule.FunctionStart)ifragment).getOperator()) != null) {
                sb.append(op.getPrettySymbol());
            }
            sb.append(((FunctionCapsule)((Object)ifragment)).getToken());
        }
    }

    private static class FunctionStackEntry {
        private FunctionCapsule.FunctionStart functionStart;
        private int remainingNumArgs;

        FunctionStackEntry(FunctionInstance functionInstance, FunctionCapsule.FunctionStart functionStart) {
            this.functionStart = functionStart;
            this.remainingNumArgs = functionInstance.getNumArgs();
        }
    }
}

