/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.query.writer;

import iot.jcypher.query.JcQuery;
import iot.jcypher.query.writer.ContextAccess;
import iot.jcypher.query.writer.CypherWriter;
import iot.jcypher.query.writer.Format;
import iot.jcypher.query.writer.IQueryParam;
import iot.jcypher.query.writer.PreparedQueries;
import iot.jcypher.query.writer.PreparedQuery;
import iot.jcypher.query.writer.QueryParam;
import iot.jcypher.query.writer.QueryParamSet;
import iot.jcypher.query.writer.WriterContext;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class JSONWriter {
    private static JsonGeneratorFactory prettyGeneratorFactory;

    public static void toJSON(List<JcQuery> queries, WriterContext context) {
        JsonGenerator generator;
        ArrayList<Statement> statements = new ArrayList<Statement>(queries.size());
        PreparedQueries prepQs = new PreparedQueries();
        context.preparedQuery = prepQs;
        Format cf = context.cypherFormat;
        context.cypherFormat = Format.NONE;
        boolean useTxEndpoint = ContextAccess.useTransationalEndpoint(context);
        ContextAccess.setUseTransactionalEndpoint(true, context);
        boolean extract = QueryParam.isExtractParams(context);
        for (JcQuery query : queries) {
            PreparedQuery prepQ = new PreparedQuery();
            prepQs.add(prepQ);
            PreparedQuery.PQContext pqContext = prepQ.getContext();
            pqContext.cypherFormat = cf;
            pqContext.extractParams = query.isExtractParams();
            pqContext.useTransationalEndpoint = ContextAccess.useTransationalEndpoint(context);
            pqContext.resultDataContents = ContextAccess.getResultDataContents(context);
            WriterContext ctxt = ContextAccess.cloneContext(context);
            ctxt.preparedQuery = prepQs;
            QueryParam.setExtractParams(query.isExtractParams(), ctxt);
            CypherWriter.toCypherExpression(query, ctxt);
            String cypher = ctxt.buffer.toString();
            prepQ.setCypher(cypher);
            pqContext.queryParams = QueryParamSet.getQueryParams(ctxt);
            JSONWriter.reInitContext(ctxt);
            statements.add(new Statement(ctxt, cypher));
        }
        context.cypherFormat = cf;
        StringWriter sw = new StringWriter();
        if (context.cypherFormat != Format.NONE) {
            JsonGeneratorFactory gf = JSONWriter.getPrettyGeneratorFactory();
            generator = gf.createGenerator((Writer)sw);
        } else {
            generator = Json.createGenerator((Writer)sw);
        }
        generator.writeStartObject();
        Statement[] statementsArray = statements.toArray(new Statement[statements.size()]);
        JSONWriter.writeStatements(statementsArray, generator);
        generator.writeEnd();
        generator.flush();
        context.buffer.append(sw.getBuffer());
        QueryParam.setExtractParams(extract, context);
        ContextAccess.setUseTransactionalEndpoint(useTxEndpoint, context);
        prepQs.setJson(context.buffer.toString());
    }

    public static void toJSON(JcQuery query, WriterContext context) {
        JsonGenerator generator;
        PreparedQuery prepQ = new PreparedQuery();
        context.preparedQuery = prepQ;
        PreparedQuery.PQContext pqContext = prepQ.getContext();
        pqContext.cypherFormat = context.cypherFormat;
        context.cypherFormat = Format.NONE;
        boolean extract = QueryParam.isExtractParams(context);
        pqContext.extractParams = query.isExtractParams();
        QueryParam.setExtractParams(query.isExtractParams(), context);
        CypherWriter.toCypherExpression(query, context);
        context.cypherFormat = pqContext.cypherFormat;
        String cypher = context.buffer.toString();
        JSONWriter.reInitContext(context);
        prepQ.setCypher(cypher);
        StringWriter sw = new StringWriter();
        if (context.cypherFormat != Format.NONE) {
            JsonGeneratorFactory gf = JSONWriter.getPrettyGeneratorFactory();
            generator = gf.createGenerator((Writer)sw);
        } else {
            generator = Json.createGenerator((Writer)sw);
        }
        pqContext.useTransationalEndpoint = ContextAccess.useTransationalEndpoint(context);
        pqContext.resultDataContents = ContextAccess.getResultDataContents(context);
        pqContext.queryParams = QueryParamSet.getQueryParams(context);
        generator.writeStartObject();
        if (ContextAccess.useTransationalEndpoint(context)) {
            JSONWriter.writeStatements(new Statement[]{new Statement(context, cypher)}, generator);
        } else {
            JSONWriter.writeQuery("query", cypher, context, generator);
        }
        generator.writeEnd();
        generator.flush();
        context.buffer.append(sw.getBuffer());
        QueryParam.setExtractParams(extract, context);
        prepQ.setJson(context.buffer.toString());
    }

    public static PreparedQuery toPreparedQuery(JcQuery query, WriterContext context) {
        JSONWriter.toJSON(query, context);
        return (PreparedQuery)context.preparedQuery;
    }

    public static PreparedQueries toPreparedQueries(List<JcQuery> queries, WriterContext context) {
        JSONWriter.toJSON(queries, context);
        return (PreparedQueries)context.preparedQuery;
    }

    public static String toJSON(PreparedQuery preparedQuery) {
        if (preparedQuery.hasdSLParams()) {
            JsonGenerator generator;
            WriterContext context = new WriterContext();
            PreparedQuery.PQContext pqContext = preparedQuery.getContext();
            QueryParam.setExtractParams(pqContext.extractParams, context);
            context.cypherFormat = pqContext.cypherFormat;
            String cypher = preparedQuery.getCypher();
            StringWriter sw = new StringWriter();
            if (context.cypherFormat != Format.NONE) {
                JsonGeneratorFactory gf = JSONWriter.getPrettyGeneratorFactory();
                generator = gf.createGenerator((Writer)sw);
            } else {
                generator = Json.createGenerator((Writer)sw);
            }
            ContextAccess.setUseTransactionalEndpoint(pqContext.useTransationalEndpoint, context);
            ContextAccess.setResultDataContents(context, pqContext.resultDataContents);
            context.queryParams = pqContext.queryParams;
            generator.writeStartObject();
            if (pqContext.useTransationalEndpoint) {
                JSONWriter.writeStatements(new Statement[]{new Statement(context, cypher)}, generator);
            } else {
                JSONWriter.writeQuery("query", cypher, context, generator);
            }
            generator.writeEnd();
            generator.flush();
            context.buffer.append(sw.getBuffer());
            return context.buffer.toString();
        }
        return preparedQuery.getJson();
    }

    public static String toJSON(PreparedQueries preparedQueries) {
        if (preparedQueries.hasdSLParams()) {
            JsonGenerator generator;
            WriterContext context = new WriterContext();
            List<PreparedQuery> prepQs = preparedQueries.getPreparedQueries();
            if (prepQs.isEmpty()) {
                return new String();
            }
            PreparedQuery prepQ = prepQs.get(0);
            PreparedQuery.PQContext pqContext = prepQ.getContext();
            ArrayList<Statement> statements = new ArrayList<Statement>(prepQs.size());
            Format cf = pqContext.cypherFormat;
            pqContext.fillContext(context);
            context.cypherFormat = Format.NONE;
            ContextAccess.setUseTransactionalEndpoint(true, context);
            for (PreparedQuery pq : prepQs) {
                WriterContext ctxt = new WriterContext();
                PreparedQuery.PQContext pqCtxt = pq.getContext();
                pqCtxt.fillContext(ctxt);
                String cypher = pq.getCypher();
                statements.add(new Statement(ctxt, cypher));
            }
            context.cypherFormat = cf;
            StringWriter sw = new StringWriter();
            if (context.cypherFormat != Format.NONE) {
                JsonGeneratorFactory gf = JSONWriter.getPrettyGeneratorFactory();
                generator = gf.createGenerator((Writer)sw);
            } else {
                generator = Json.createGenerator((Writer)sw);
            }
            generator.writeStartObject();
            Statement[] statementsArray = statements.toArray(new Statement[statements.size()]);
            JSONWriter.writeStatements(statementsArray, generator);
            generator.writeEnd();
            generator.flush();
            context.buffer.append(sw.getBuffer());
            preparedQueries.setJson(context.buffer.toString());
            return preparedQueries.getJson();
        }
        return preparedQueries.getJson();
    }

    private static void writeStatements(Statement[] statements, JsonGenerator generator) {
        generator.writeStartArray("statements");
        for (Statement statement : statements) {
            generator.writeStartObject();
            JSONWriter.writeQuery("statement", statement.cypher, statement.context, generator);
            if (ContextAccess.getResultDataContents(statement.context).size() > 0) {
                generator.writeStartArray("resultDataContents");
                for (String contentDescription : ContextAccess.getResultDataContents(statement.context)) {
                    generator.write(contentDescription);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    private static void writeQuery(String queryKey, String cypher, WriterContext context, JsonGenerator generator) {
        generator.write(queryKey, cypher);
        JSONWriter.writeQueryParams(context, generator);
    }

    private static void writeQueryParams(WriterContext context, JsonGenerator generator) {
        List<IQueryParam> params;
        if (QueryParam.isExtractParams(context) && (params = QueryParamSet.getQueryParams(context)) != null) {
            String paramsKey = "params";
            if (ContextAccess.useTransationalEndpoint(context)) {
                paramsKey = "parameters";
            }
            generator.writeStartObject(paramsKey);
            for (IQueryParam iparam : params) {
                if (iparam instanceof QueryParamSet) {
                    QueryParamSet paramSet = (QueryParamSet)iparam;
                    if (paramSet.canUseSet() && paramSet.getQueryParams().size() > 1) {
                        JSONWriter.writeAsSet(paramSet, generator);
                        continue;
                    }
                    JSONWriter.writeAsParams(paramSet, generator);
                    continue;
                }
                if (!(iparam instanceof QueryParam)) continue;
                JSONWriter.writeParam((QueryParam)iparam, generator);
            }
            generator.writeEnd();
        }
    }

    private static void writeAsParams(QueryParamSet paramSet, JsonGenerator generator) {
        for (QueryParam param : paramSet.getQueryParams()) {
            String key = param.getKey();
            Object val = param.getValue();
            JSONWriter.writeLiteral(key, val, generator);
        }
    }

    private static void writeAsSet(QueryParamSet paramSet, JsonGenerator generator) {
        generator.writeStartObject(paramSet.getKey());
        for (QueryParam param : paramSet.getQueryParams()) {
            String key = param.getOrgName();
            Object val = param.getValue();
            JSONWriter.writeLiteral(key, val, generator);
        }
        generator.writeEnd();
    }

    private static void writeParam(QueryParam param, JsonGenerator generator) {
        String key = param.getKey();
        Object val = param.getValue();
        JSONWriter.writeLiteral(key, val, generator);
    }

    private static void writeLiteral(String key, Object val, JsonGenerator generator) {
        if (val instanceof String) {
            generator.write(key, val.toString());
        } else if (val instanceof Number) {
            if (val instanceof Long) {
                generator.write(key, ((Long)val).longValue());
            } else if (val instanceof Integer) {
                generator.write(key, ((Integer)val).intValue());
            } else if (val instanceof Double) {
                generator.write(key, ((Double)val).doubleValue());
            } else if (val instanceof Float) {
                generator.write(key, (double)((Float)val).floatValue());
            }
        } else if (val instanceof Boolean) {
            generator.write(key, ((Boolean)val).booleanValue());
        } else if (val instanceof List) {
            generator.writeStartArray(key);
            for (Object v : (List)val) {
                JSONWriter.writeLiteral(v, generator);
            }
            generator.writeEnd();
        } else if (val != null) {
            generator.write(key, val.toString());
        }
    }

    private static void writeLiteral(Object val, JsonGenerator generator) {
        if (val instanceof String) {
            generator.write(val.toString());
        } else if (val instanceof Number) {
            if (val instanceof Long) {
                generator.write(((Long)val).longValue());
            } else if (val instanceof Integer) {
                generator.write(((Integer)val).intValue());
            } else if (val instanceof Double) {
                generator.write(((Double)val).doubleValue());
            } else if (val instanceof Float) {
                generator.write((double)((Float)val).floatValue());
            }
        } else if (val instanceof Boolean) {
            generator.write(((Boolean)val).booleanValue());
        } else if (val != null) {
            generator.write(val.toString());
        }
    }

    private static void reInitContext(WriterContext context) {
        context.buffer = new StringBuilder();
        context.inFunction = false;
        context.currentClause = null;
        context.previousClause = null;
        context.resetLevel();
    }

    public static JsonGeneratorFactory getPrettyGeneratorFactory() {
        if (prettyGeneratorFactory == null) {
            HashMap<String, Boolean> prettyConfigMap = new HashMap<String, Boolean>();
            prettyConfigMap.put("javax.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
            prettyGeneratorFactory = Json.createGeneratorFactory(prettyConfigMap);
        }
        return prettyGeneratorFactory;
    }

    private static class Statement {
        private WriterContext context;
        private String cypher;

        private Statement(WriterContext context, String cypher) {
            this.context = context;
            this.cypher = cypher;
        }
    }
}

