/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MultiOutputStream
extends OutputStream {
    private List<OutputStream> delegates = new ArrayList<OutputStream>();

    @Override
    public void write(int toWrite) throws IOException {
        for (OutputStream out : this.delegates) {
            out.write(toWrite);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (OutputStream out : this.delegates) {
            out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        for (OutputStream out : this.delegates) {
            out.flush();
        }
    }

    public void addDelegate(OutputStream delegate) {
        if (!this.delegates.contains(delegate)) {
            this.delegates.add(delegate);
        }
    }

    public void removeDelegate(OutputStream delegate) {
        this.delegates.remove(delegate);
    }

    public void removeAllDelegates() {
        this.delegates.clear();
    }
}

