/*
 * Decompiled with CFR 0.152.
 */
package net.iotgw.mail.imap.protocol;

import java.io.ByteArrayInputStream;
import net.iotgw.mail.iap.ByteArray;
import net.iotgw.mail.iap.ParsingException;
import net.iotgw.mail.imap.protocol.FetchResponse;
import net.iotgw.mail.imap.protocol.Item;

public class BODY
implements Item {
    static final char[] name = new char[]{'B', 'O', 'D', 'Y'};
    private final int msgno;
    private final ByteArray data;
    private final String section;
    private final int origin;
    private final boolean isHeader;

    public BODY(FetchResponse r) throws ParsingException {
        this.msgno = r.getNumber();
        r.skipSpaces();
        if (r.readByte() != 91) {
            throw new ParsingException("BODY parse error: missing ``['' at section start");
        }
        this.section = r.readString(']');
        if (r.readByte() != 93) {
            throw new ParsingException("BODY parse error: missing ``]'' at section end");
        }
        this.isHeader = this.section.regionMatches(true, 0, "HEADER", 0, 6);
        if (r.readByte() == 60) {
            this.origin = r.readNumber();
            r.skip(1);
        } else {
            this.origin = 0;
        }
        this.data = r.readByteArray();
    }

    public ByteArray getByteArray() {
        return this.data;
    }

    public ByteArrayInputStream getByteArrayInputStream() {
        if (this.data != null) {
            return this.data.toByteArrayInputStream();
        }
        return null;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public String getSection() {
        return this.section;
    }
}

