/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.irisvalet.android.apps.mobilevalethelper.BaseManager;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.PropertyManager;
import com.irisvalet.android.apps.mobilevalethelper.ShoppingCart;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.BasketContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.GuestOrderContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.RegisterAssetResponseDetailsAssetContent;
import com.irisvalet.android.apps.mobilevalethelper.library.CartManagerListener.CartManagerListener;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.DeliveryLocation;
import com.irisvalet.android.apps.mobilevalethelper.object.DeliveryLocationArea;
import com.irisvalet.android.apps.mobilevalethelper.object.Modifier;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import com.irisvalet.android.apps.mobilevalethelper.object.NonVerifiedGuestField;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderItem;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderItemModifier;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderItemModifierOption;
import com.irisvalet.android.apps.mobilevalethelper.object.OutletSettings;
import com.irisvalet.android.apps.mobilevalethelper.object.PaymentRecord;
import com.irisvalet.android.apps.mobilevalethelper.object.PaymentType;
import com.irisvalet.android.apps.mobilevalethelper.object.ShoppingCartItem;
import com.irisvalet.android.apps.mobilevalethelper.object.SubModifier;
import com.irisvalet.android.apps.mobilevalethelper.service.AssetApiIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.GuestApiIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.NonGuestApiIntentService;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class CartManager
extends BaseManager {
    private static final String TAG = "CartManager";
    private static CartManagerListener cartManagerListener = null;
    private static Map<String, Integer> mItemsInCartMap = new HashMap<String, Integer>();
    private static Map<String, String> mCommentsMap = new HashMap<String, String>();
    private static Map<String, Integer> mNumberOfGuestsMap = new HashMap<String, Integer>();
    private static Map<String, BasketContent> mBasketContentMap = new HashMap<String, BasketContent>();
    private static Map<String, ShoppingCart> mCartMap = new HashMap<String, ShoppingCart>();
    private static Map<String, DeliveryLocationArea> mDeliveryAreaMap = new HashMap<String, DeliveryLocationArea>();
    public static Map<String, DeliveryLocation> mDeliveryLocationMap = new HashMap<String, DeliveryLocation>();
    private static Map<String, Integer> mDeliveryLocationOptionMap = new HashMap<String, Integer>();
    private static Map<String, Integer> mDeliveryTimeOptionMap = new HashMap<String, Integer>();
    private static Map<String, Date> mDeliveryTimeMap = new HashMap<String, Date>();
    private static Map<String, ArrayList<NonVerifiedGuestField>> mNonVerifiedGuestFieldsMap = new HashMap<String, ArrayList<NonVerifiedGuestField>>();
    public static final int ERROR_CODE_ANOTHER_OUTLET_BASKET_ALREADY_EXISTS = 100;
    public static final int ERROR_CODE_ITEM_LIMIT_REACHED = 101;
    public static final int ERROR_CODE_MANDATORY_MODIFIER_MISSING = 102;

    private static void initiateCart(Context context, String outletCode, String outletName) {
        if (mCartMap == null || mCartMap.size() == 0) {
            mCartMap = new HashMap<String, ShoppingCart>();
            mItemsInCartMap = new HashMap<String, Integer>();
        }
        if (outletCode != null) {
            OutletSettings settings;
            ShoppingCart cart = new ShoppingCart(ContentManager.getPropertyCode());
            cart.outletCode = outletCode;
            cart.outletName = outletName;
            mCartMap.put(outletCode, cart);
            int deliveryOption = 0;
            if (mDeliveryLocationOptionMap.get(outletCode) != null) {
                deliveryOption = mDeliveryLocationOptionMap.get(outletCode);
            }
            if (deliveryOption == 0 && (settings = ContentManager.getOutletSettings(outletCode)) != null) {
                deliveryOption = settings.allowDeliverToRoom ? 1 : (settings.allowCollection ? 2 : 3);
                CartManager.setDeliveryLocation(context, outletCode, deliveryOption, null, null);
            }
        }
    }

    public static ShoppingCart getDefaultCart() {
        Map.Entry<String, ShoppingCart> entry;
        if (mCartMap != null && mCartMap.size() > 0 && (entry = mCartMap.entrySet().iterator().next()).getValue() != null) {
            return mCartMap.get(entry.getKey());
        }
        return null;
    }

    public static int getNumberOfItemsInCart() {
        ShoppingCart cart = CartManager.getDefaultCart();
        if (cart != null) {
            return cart.countItems();
        }
        return 0;
    }

    public static ShoppingCart getCart(String outletCode) {
        ShoppingCart cart = CartManager.getDefaultCart();
        if (cart != null && cart.outletCode.equals(outletCode)) {
            return cart;
        }
        return null;
    }

    public static int getDeliveryTimeOption(String outletCode) {
        if (mDeliveryTimeOptionMap != null && mDeliveryTimeOptionMap.get(outletCode) != null) {
            return mDeliveryTimeOptionMap.get(outletCode);
        }
        return 10;
    }

    public static Date getDeliveryTime(String outletCode) {
        if (mDeliveryTimeMap.get(outletCode) != null) {
            return mDeliveryTimeMap.get(outletCode);
        }
        return CartManager.getDefaultDeliveryTime(outletCode);
    }

    public static Date getDefaultDeliveryTime(String outletCode) {
        Date deliveryTime = Calendar.getInstance().getTime();
        try {
            String propertyTimeZone = PropertyManager.getPropertyTimeZone();
            if (propertyTimeZone != null) {
                TimeZone hotelTZ = TimeZone.getTimeZone(propertyTimeZone);
                TimeZone.setDefault(hotelTZ);
                deliveryTime = Calendar.getInstance().getTime();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long timeInMilliseconds = deliveryTime.getTime();
        deliveryTime = new Date(timeInMilliseconds);
        mDeliveryTimeMap.put(outletCode, deliveryTime);
        DebugLog.d(TAG, "getDefaultDeliveryTime: " + deliveryTime.toString());
        return deliveryTime;
    }

    public static void setDeliveryTime(Context context, String outletCode, int deliveryOption, Date deliveryTime) {
        mDeliveryTimeOptionMap.put(outletCode, deliveryOption);
        mDeliveryTimeMap.put(outletCode, deliveryTime);
        mBasketContentMap.remove(outletCode);
        CartManager.submitBasket(context, outletCode);
    }

    public static int getDeliveryLocationOption(String outletCode) {
        if (mDeliveryLocationOptionMap != null && mDeliveryLocationOptionMap.get(outletCode) != null) {
            return mDeliveryLocationOptionMap.get(outletCode);
        }
        return 0;
    }

    public static DeliveryLocation getDeliveryLocation(String outletCode) {
        if (mDeliveryLocationMap != null && mDeliveryLocationMap.get(outletCode) != null) {
            return mDeliveryLocationMap.get(outletCode);
        }
        return null;
    }

    public static void setDeliveryLocation(Context context, String outletCode, int deliveryOption, DeliveryLocationArea deliveryArea, DeliveryLocation deliveryLocation) {
        if (CartManager.allowAddingToCart(outletCode)) {
            mDeliveryLocationOptionMap.put(outletCode, deliveryOption);
            mDeliveryAreaMap.put(outletCode, deliveryArea);
            mDeliveryLocationMap.put(outletCode, deliveryLocation);
            mBasketContentMap.remove(outletCode);
            if (CartManager.getDefaultCart() != null) {
                CartManager.submitBasket(context, outletCode);
            }
        }
    }

    public static DeliveryLocationArea getDeliveryArea(String outletCode) {
        if (mDeliveryAreaMap != null && mDeliveryAreaMap.get(outletCode) != null) {
            return mDeliveryAreaMap.get(outletCode);
        }
        return null;
    }

    public static boolean addItemToCart(Context context, String outletCode, String outletName, String SectionCode, OrderItem orderItem, int quantity, String comments) {
        if (orderItem == null) {
            return false;
        }
        CategoryItem item = ContentManager.getCategoryItem(orderItem.code, outletCode);
        if (item != null && orderItem.modifiers != null && item.modifiers != null) {
            for (OrderItemModifier orderItemModifier : orderItem.modifiers) {
                for (Modifier modifier : item.modifiers) {
                    if (!modifier.code.equals(orderItemModifier.code) || orderItemModifier.options == null || modifier.modifierOptions == null) continue;
                    for (OrderItemModifierOption orderItemModifierOption : orderItemModifier.options) {
                        for (ModifierOption modifierOption : modifier.modifierOptions) {
                            if (!modifierOption.code.equals(orderItemModifierOption.code)) continue;
                            modifierOption.quantity = 1;
                        }
                    }
                }
            }
        }
        return item != null && CartManager.addItemToCart(context, outletCode, outletName, SectionCode, item, quantity, comments);
    }

    public static boolean addItemToCart(Context context, String outletCode, String outletName, String SectionCode, CategoryItem item, int quantity, String comments) {
        cartManagerListener = (CartManagerListener)context;
        ShoppingCartItem shoppingCartItem = new ShoppingCartItem(SectionCode, item, quantity, comments);
        if (!CartManager.allowAddingToCart(outletCode)) {
            cartManagerListener.onAddToCartFailed(100, 0, 0, shoppingCartItem);
            return false;
        }
        if (item != null && quantity > 0) {
            if (item.modifiers != null && item.modifiers.size() > 0) {
                int indexModifier = 0;
                for (Modifier m : item.modifiers) {
                    if (m != null && m.type != null) {
                        if (m.type.equalsIgnoreCase("text") && m.isRequired && TextUtils.isEmpty((CharSequence)m.value)) {
                            cartManagerListener.onAddToCartFailed(102, indexModifier, -1, shoppingCartItem);
                            return false;
                        }
                        if ((m.type.equalsIgnoreCase("select") || m.type.toLowerCase().contains("multi")) && m.isRequired && m.modifierOptions != null && m.modifierOptions.size() > 0) {
                            boolean optionSelected = false;
                            for (ModifierOption o : m.modifierOptions) {
                                boolean bl = optionSelected = o.quantity > 0;
                                if (optionSelected) break;
                                if (o.subModifiers != null && o.subModifiers.size() > 0) {
                                    for (SubModifier sm : o.subModifiers) {
                                        if ((sm.type.equalsIgnoreCase("select") || sm.type.toLowerCase().contains("multi")) && sm.modifierOptions != null && sm.modifierOptions.size() > 0) {
                                            for (ModifierOption smo : sm.modifierOptions) {
                                                optionSelected = smo.quantity > 0;
                                                if (!optionSelected) continue;
                                                break;
                                            }
                                        }
                                        if (!optionSelected) continue;
                                        break;
                                    }
                                }
                                if (!optionSelected) continue;
                                break;
                            }
                            if (!optionSelected) {
                                cartManagerListener.onAddToCartFailed(102, indexModifier, -1, shoppingCartItem);
                                return false;
                            }
                        }
                    }
                    ++indexModifier;
                }
            }
            if (mCartMap == null) {
                mCartMap = new HashMap<String, ShoppingCart>();
            }
            if (mCartMap.get(outletCode) == null) {
                CartManager.initiateCart(context, outletCode, outletName);
            }
            if (CartManager.getCart(outletCode) != null && CartManager.getCart(outletCode).add(shoppingCartItem, quantity, 0, comments)) {
                int value = quantity;
                if (mItemsInCartMap.get(item.code) != null) {
                    value += mItemsInCartMap.get(item.code).intValue();
                }
                mItemsInCartMap.put(item.code, value);
                cartManagerListener.onItemAddToCartSucceeded(item, quantity);
                CartManager.saveCart(outletCode);
                return true;
            }
            cartManagerListener.onAddToCartFailed(101, 0, 0, shoppingCartItem);
        }
        return false;
    }

    private static boolean allowAddingToCart(String outletCode) {
        ShoppingCart cart = CartManager.getDefaultCart();
        if (cart == null || cart.outletCode.equals(outletCode)) {
            return true;
        }
        if (cart.items == null || cart.items.size() == 0) {
            mCartMap.remove(outletCode);
            return true;
        }
        return false;
    }

    public static float getTotal(String outletCode) {
        return mCartMap == null || mCartMap.get(outletCode) == null ? 0.0f : CartManager.mCartMap.get((Object)outletCode).total;
    }

    public static void clearCart(String outletCode) {
        if (outletCode != null) {
            mBasketContentMap.remove(outletCode);
            mCartMap.remove(outletCode);
        } else {
            mBasketContentMap.clear();
            mCartMap.clear();
        }
        mItemsInCartMap = new HashMap<String, Integer>();
        ContentManager.clearCart(outletCode);
    }

    static void clearAllCarts() {
        mCartMap = new HashMap<String, ShoppingCart>();
        mBasketContentMap = new HashMap<String, BasketContent>();
        mItemsInCartMap = new HashMap<String, Integer>();
        ContentManager.clearCart(null);
    }

    public static void setBasketContent(String outletCode, BasketContent basketContent) {
        mBasketContentMap.put(outletCode, basketContent);
        if (mCartMap != null && mCartMap.get(outletCode) != null && basketContent != null) {
            CartManager.mCartMap.get((Object)outletCode).total = basketContent.total + basketContent.deliveryChargeAmount + basketContent.posTotalSurcharge;
            CartManager.mCartMap.get((Object)outletCode).deliveryCharge = basketContent.deliveryChargeAmount;
            CartManager.mCartMap.get((Object)outletCode).serviceCharge = basketContent.gxpFlatExtraCharges + basketContent.posTotalSurcharge;
            CartManager.mCartMap.get((Object)outletCode).tax = basketContent.gxpTaxForExtraCharges + basketContent.posTaxChargeAmount;
        }
    }

    public static BasketContent getBasketContent(String outletCode) {
        return mBasketContentMap.get(outletCode);
    }

    private static void saveCart(String outletCode) {
        ShoppingCart cart;
        if (mCartMap.size() > 0 && (cart = mCartMap.get(outletCode)) != null) {
            ContentManager.saveCart(outletCode, cart);
        }
    }

    public static void restoreCart() {
        if (mCartMap == null || mCartMap.size() == 0) {
            mCartMap = new HashMap<String, ShoppingCart>();
            mItemsInCartMap = new HashMap<String, Integer>();
            ArrayList<ShoppingCart> carts = ContentManager.restoreCart();
            if (carts != null && carts.size() > 0) {
                for (ShoppingCart cart : carts) {
                    if (cart == null) continue;
                    mCartMap.put(cart.outletCode, cart);
                    if (cart.items == null || cart.items.size() <= 0) continue;
                    for (ShoppingCartItem item : cart.items) {
                        if (item == null || item.item == null) continue;
                        int value = item.quantity;
                        if (mItemsInCartMap.get(item.item.code) != null) {
                            value += mItemsInCartMap.get(item.item.code).intValue();
                        }
                        mItemsInCartMap.put(item.item.code, value);
                    }
                }
            }
        }
    }

    public static void update(String outletCode, ShoppingCartItem item, int delta) {
        DebugLog.d(TAG, "update " + item.item.name + " delta " + delta);
        if (mCartMap != null && mCartMap.get(outletCode) != null) {
            if (item.quantity + delta > 0) {
                mCartMap.get(outletCode).update(item, item.quantity + delta);
            } else {
                mCartMap.get(outletCode).remove(item);
            }
            if (CartManager.mCartMap.get((Object)outletCode).items == null || CartManager.mCartMap.get((Object)outletCode).items.size() == 0) {
                CartManager.clearCart(outletCode);
            }
        }
        int value = 0;
        if (mItemsInCartMap.get(item.item.code) != null) {
            value = mItemsInCartMap.get(item.item.code) + delta;
        }
        mItemsInCartMap.put(item.item.code, value);
        CartManager.saveCart(outletCode);
    }

    public static int getTotalOfThisItemInCart(String itemCode) {
        if (mCartMap == null || mItemsInCartMap == null || mItemsInCartMap.get(itemCode) == null) {
            return 0;
        }
        return mItemsInCartMap.get(itemCode);
    }

    public static boolean isCartEmpty(String outletCode) {
        return mCartMap == null || mCartMap.get(outletCode) == null || CartManager.mCartMap.get((Object)outletCode).items == null || CartManager.mCartMap.get((Object)outletCode).items.size() == 0;
    }

    public static String searchOutletCodeByItem(ShoppingCartItem item) {
        if (item != null && mCartMap != null && mCartMap.size() > 0) {
            for (Map.Entry<String, ShoppingCart> entry : mCartMap.entrySet()) {
                ShoppingCart cart = entry.getValue();
                if (cart == null || cart.items == null || cart.items.size() <= 0) continue;
                for (ShoppingCartItem cartItem : cart.items) {
                    if (cartItem == null || cartItem.item == null || !cartItem.item.code.equals(item.item.code)) continue;
                    return entry.getKey();
                }
            }
        }
        return null;
    }

    public static void addToBasket(Context context, String outletCode) {
        mBasketContentMap.remove(outletCode);
        if (context.getApplicationContext() == null) {
            return;
        }
        cartManagerListener = (CartManagerListener)context.getApplicationContext();
        if (outletCode != null && CartManager.getCart(outletCode) != null && CartManager.getCart((String)outletCode).items != null && CartManager.getCart((String)outletCode).items.size() > 0) {
            Intent intent;
            if (GuestManager.isFnb()) {
                intent = new Intent(context, NonGuestApiIntentService.class);
            } else if (!ContentManager.isGV()) {
                if (!GuestManager.isSignedIn()) {
                    intent = new Intent(context, NonGuestApiIntentService.class);
                } else {
                    intent = new Intent(context, GuestApiIntentService.class);
                    intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
                    intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
                }
            } else {
                RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
                if (assetContent == null) {
                    cartManagerListener.onSubmitCartFailed("Guest not logged in");
                    return;
                }
                intent = new Intent(context, AssetApiIntentService.class);
                intent.putExtra("DEVICE_ID", assetContent.assetId);
                intent.putExtra("ASSET_KEY", assetContent.assetKey);
                intent.putExtra("ROOM", assetContent.roomNumber);
            }
            intent.putExtra("OUTLET_CODE", outletCode);
            intent.putExtra("ACTION", "addItemsToBasket");
            context.startService(intent);
        } else {
            cartManagerListener.onSubmitCartFailed("Cart empty");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void submitBasket(Context context, String outletCode) {
        if (context.getApplicationContext() == null) {
            return;
        }
        if (CartManager.getBasketContent(outletCode) == null || CartManager.getBasketContent((String)outletCode).basketCode == null) {
            CartManager.addToBasket(context, outletCode);
            return;
        }
        cartManagerListener = (CartManagerListener)context.getApplicationContext();
        ShoppingCart cart = CartManager.getCart(outletCode);
        if (outletCode != null && cart != null && cart.items != null && cart.items.size() > 0) {
            Intent intent;
            block11: {
                if (GuestManager.isFnb()) {
                    intent = new Intent(context, NonGuestApiIntentService.class);
                } else if (!ContentManager.isGV()) {
                    if (!GuestManager.isSignedIn()) {
                        OutletSettings settings = ContentManager.getOutletSettings(outletCode);
                        if (settings != null && settings.allowNonVerifiedGuests) {
                            intent = new Intent(context, NonGuestApiIntentService.class);
                            break block11;
                        } else {
                            cartManagerListener.onSubmitCartFailed("Guest not logged in");
                            return;
                        }
                    }
                    intent = new Intent(context, GuestApiIntentService.class);
                    intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
                    intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
                } else {
                    RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
                    if (assetContent == null) {
                        cartManagerListener.onSubmitCartFailed("Guest not logged in");
                        return;
                    }
                    intent = new Intent(context, AssetApiIntentService.class);
                    intent.putExtra("DEVICE_ID", assetContent.assetId);
                    intent.putExtra("ASSET_KEY", assetContent.assetKey);
                    intent.putExtra("ROOM", assetContent.roomNumber);
                }
            }
            intent.putExtra("OUTLET_CODE", outletCode);
            intent.putExtra("ACTION", "placeGuestOrder");
            context.startService(intent);
            return;
        }
        cartManagerListener.onSubmitCartFailed("Cart empty");
    }

    public static void onAddToBasketSucceed(Context context) {
        cartManagerListener = (CartManagerListener)context;
        cartManagerListener.onAddToBasketSucceed();
    }

    public static void onPostBasketSucceed(Context context, String outletCode, boolean isNonVerifiedGuest, GuestOrderContent orderConfirmation) {
        CartManager.setComments(outletCode, null);
        mItemsInCartMap = new HashMap<String, Integer>();
        if (!GuestManager.isFnb() && GuestManager.isGV()) {
            mDeliveryAreaMap.remove(outletCode);
            mDeliveryLocationMap.remove(outletCode);
            mDeliveryLocationOptionMap.remove(outletCode);
        }
        mDeliveryTimeOptionMap.remove(outletCode);
        mDeliveryTimeMap.remove(outletCode);
        cartManagerListener = (CartManagerListener)context;
        if (isNonVerifiedGuest) {
            cartManagerListener.onNonVerifiedOrderSucceed(orderConfirmation);
        } else {
            cartManagerListener.onSubmitCartSucceed(orderConfirmation);
        }
    }

    public static void onPostBasketFailed(Context context, String outletCode, String message) {
        mBasketContentMap.remove(outletCode);
        cartManagerListener = (CartManagerListener)context;
        cartManagerListener.onSubmitCartFailed(message);
    }

    public static void setComments(String outletCode, String comments) {
        mCommentsMap.put(outletCode, comments);
    }

    public static String getComments(String outletCode) {
        return mCommentsMap.get(outletCode);
    }

    public static void setNumberOfGuests(String outletCode, int value) {
        mNumberOfGuestsMap.put(outletCode, value);
    }

    public static int getNumberOfGuests(String outletCode) {
        if (mNumberOfGuestsMap.get(outletCode) != null) {
            return mNumberOfGuestsMap.get(outletCode);
        }
        return 1;
    }

    public static ArrayList<NonVerifiedGuestField> getNonVerifiedGuestsFields(String outletCode) {
        CartManager.restoreNonVerifiedGuestFields();
        if (mNonVerifiedGuestFieldsMap.size() > 0) {
            return mNonVerifiedGuestFieldsMap.get(outletCode);
        }
        return null;
    }

    public static void setNonVerifiedGuestsFields(String outletCode, ArrayList<NonVerifiedGuestField> nonVerifiedGuestFields) {
        mNonVerifiedGuestFieldsMap.put(outletCode, nonVerifiedGuestFields);
        CartManager.saveNonVerifiedGuestFields(outletCode);
    }

    private static void saveNonVerifiedGuestFields(String outletCode) {
        ArrayList<NonVerifiedGuestField> nonVerifiedGuestFields;
        if (mNonVerifiedGuestFieldsMap.size() > 0 && (nonVerifiedGuestFields = mNonVerifiedGuestFieldsMap.get(outletCode)) != null) {
            ContentManager.saveNonVerifiedGuestFields(outletCode, nonVerifiedGuestFields);
        }
    }

    private static void restoreNonVerifiedGuestFields() {
        if (mNonVerifiedGuestFieldsMap == null || mNonVerifiedGuestFieldsMap.size() == 0) {
            mNonVerifiedGuestFieldsMap = ContentManager.restoreNonVerifiedGuestFields();
        }
    }

    public static void setPaymentType(String outletCode, int type) {
        ShoppingCart cart = CartManager.getCart(outletCode);
        if (cart != null) {
            cart.paymentType = type;
            CartManager.saveCart(cart.outletCode);
        }
    }

    public static void addPaymentRecord(String outletCode, PaymentRecord record) {
        ShoppingCart cart = CartManager.getCart(outletCode);
        if (cart != null) {
            if (cart.paymentRecords == null) {
                cart.paymentRecords = new ArrayList();
            }
            cart.paymentRecords.add(record);
            CartManager.saveCart(cart.outletCode);
        }
    }

    public static int getPaymentType(String outletCode) {
        ShoppingCart cart = CartManager.getCart(outletCode);
        if (cart != null) {
            return cart.paymentType;
        }
        return PaymentType.Open;
    }
}

