/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.google.gson.JsonObject;
import com.irisvalet.android.apps.mobilevalethelper.BaseManager;
import com.irisvalet.android.apps.mobilevalethelper.CartManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.LanguagesManager;
import com.irisvalet.android.apps.mobilevalethelper.PropertyManager;
import com.irisvalet.android.apps.mobilevalethelper.ServiceManager;
import com.irisvalet.android.apps.mobilevalethelper.ShoppingCart;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.ServiceRequestDetails;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.ConversationsResponseDetailsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.ForecastResponseDetailsForecastContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.GuestProfileResponseDetailsProfileContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HomePageResponseDetailsHomepageContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HotelCMSSettingsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HotelCartSettingsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HotelPropertySettingsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OrderHistoryResponseDetailsGetOrdersContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletDeliveryLocationsResponseDetailsLocationsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.OutletsResponseDetailsOutletsContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.RegisterAssetResponseDetailsAssetContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.SectionsResponseDetailsSectionsContent;
import com.irisvalet.android.apps.mobilevalethelper.database.DataCacheHelper;
import com.irisvalet.android.apps.mobilevalethelper.database.DatabaseHelper;
import com.irisvalet.android.apps.mobilevalethelper.object.Category;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.Conversation;
import com.irisvalet.android.apps.mobilevalethelper.object.DeliveryLocationArea;
import com.irisvalet.android.apps.mobilevalethelper.object.Modifier;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import com.irisvalet.android.apps.mobilevalethelper.object.NonVerifiedGuestField;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderHistoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderItem;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderItemModifier;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderItemModifierOption;
import com.irisvalet.android.apps.mobilevalethelper.object.OrderItemSubModifier;
import com.irisvalet.android.apps.mobilevalethelper.object.Outlet;
import com.irisvalet.android.apps.mobilevalethelper.object.OutletSettings;
import com.irisvalet.android.apps.mobilevalethelper.object.Section;
import com.irisvalet.android.apps.mobilevalethelper.object.ShoppingCartItem;
import com.irisvalet.android.apps.mobilevalethelper.object.SubCategory;
import com.irisvalet.android.apps.mobilevalethelper.object.SubModifier;
import com.irisvalet.android.apps.mobilevalethelper.object.User;
import com.irisvalet.android.apps.mobilevalethelper.service.ContentIntentService;
import com.irisvalet.android.apps.mobilevalethelper.utils.CategoriesComparator;
import com.irisvalet.android.apps.mobilevalethelper.utils.ConversationsDateTimeComparator;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import com.irisvalet.android.apps.mobilevalethelper.utils.HomePageQuickLaunchesComparator;
import com.irisvalet.android.apps.mobilevalethelper.utils.MessagesDateTimeComparator;
import com.irisvalet.android.apps.mobilevalethelper.utils.OrderHistoryDateTimeComparator;
import com.irisvalet.android.apps.mobilevalethelper.utils.OutletsComparator;
import com.irisvalet.android.apps.mobilevalethelper.utils.SectionsComparator;
import com.irisvalet.android.apps.mobilevalethelper.utils.SubCategoriesComparator;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class ContentManager
extends BaseManager {
    private static final String TAG = "ContentManager";
    private static String mPropertyCode = null;
    private static String mAppToken = null;
    private static String mContentSessionToken = null;
    private static HashMap<String, Integer> mContentVersionNumberMap = new HashMap();
    public static Map<String, ArrayList<Section>> mStandardSectionsMap = new HashMap<String, ArrayList<Section>>();
    public static Map<String, ArrayList<Section>> mGuestSectionsMap = new HashMap<String, ArrayList<Section>>();
    public static Map<String, ArrayList<Outlet>> mOutletsMap = new HashMap<String, ArrayList<Outlet>>();
    public static Map<String, Section> mSectionsByCodeMap = new HashMap<String, Section>();
    public static Map<String, CategoryItem> mCategoryItemsByCodeMap = new HashMap<String, CategoryItem>();
    public static Map<String, HomePageResponseDetailsHomepageContent> mHomePageContentData = new HashMap<String, HomePageResponseDetailsHomepageContent>();
    public static Map<String, HomePageResponseDetailsHomepageContent> mHomePageContentByGuestData = new HashMap<String, HomePageResponseDetailsHomepageContent>();
    public static Map<String, ArrayList<CategoryItem>> mCategoryItemsMap = new HashMap<String, ArrayList<CategoryItem>>();
    public static Map<String, ArrayList<DeliveryLocationArea>> mOutletDeliveryLocationAreasMap = new HashMap<String, ArrayList<DeliveryLocationArea>>();
    private static Map<String, OutletSettings> mOutletSettingsMap = new HashMap<String, OutletSettings>();
    private static ArrayList<Conversation> mConversations = null;
    private static ArrayList<OrderHistoryItem> mOrders = null;

    static void onLowMemory() {
        TranslationUtils.mStaticContentData = new HashMap<String, JsonObject>();
    }

    public static void initialize(Context context, String propertyCode, String appToken, GuestManager.APP_TYPE appType, boolean isGV) throws Exception {
        mAppContext = context;
        DatabaseHelper db = new DatabaseHelper(context);
        db.initInstance(context);
        if (TextUtils.isEmpty((CharSequence)appToken)) {
            throw new Exception("Missing App token");
        }
        if (TextUtils.isEmpty((CharSequence)propertyCode)) {
            throw new Exception("Missing Property code");
        }
        mAppToken = appToken;
        ContentManager.setPropertyCode(propertyCode);
        ContentManager.setAppToken(appToken);
        ContentManager.setGV(isGV);
        ContentManager.setAppType(appType);
    }

    public static void resetPropertyData() {
        ContentManager.resetContentSessionToken();
        LanguagesManager.setDefaultLanguage();
        ContentManager.deleteUser();
        PropertyManager.mPropertySettings = null;
        PropertyManager.mHotelCMSSettings = null;
        PropertyManager.mPropertyName = null;
        PropertyManager.mDefaultCurrencySymbol = null;
        PropertyManager.mNumberOfDecimals = -1;
        PropertyManager.mMetricsFormat = null;
        PropertyManager.mPropertyCityName = "";
        PropertyManager.mCurrentLocationLat = 0.0;
        PropertyManager.mCurrentLocationLng = 0.0;
        PropertyManager.mTimeZone = null;
        mStandardSectionsMap = new HashMap<String, ArrayList<Section>>();
        mGuestSectionsMap = new HashMap<String, ArrayList<Section>>();
        mHomePageContentData = new HashMap<String, HomePageResponseDetailsHomepageContent>();
        mHomePageContentByGuestData = new HashMap<String, HomePageResponseDetailsHomepageContent>();
        mCategoryItemsMap = new HashMap<String, ArrayList<CategoryItem>>();
        mOutletsMap = new HashMap<String, ArrayList<Outlet>>();
        mSectionsByCodeMap = new HashMap<String, Section>();
        mCategoryItemsByCodeMap = new HashMap<String, CategoryItem>();
        mOutletSettingsMap = new HashMap<String, OutletSettings>();
        mOutletDeliveryLocationAreasMap = new HashMap<String, ArrayList<DeliveryLocationArea>>();
        mConversations = null;
        mOrders = null;
    }

    public static String getPropertyCode() {
        if (TextUtils.isEmpty((CharSequence)mPropertyCode)) {
            mPropertyCode = ContentManager.getStringPreferences("PROPERTY_CODE");
        }
        return mPropertyCode;
    }

    public static void setPropertyCode(String code) {
        mPropertyCode = code;
        ContentManager.SaveStringPreferences("PROPERTY_CODE", code);
    }

    private static void setAppToken(String token) {
        mAppToken = token;
        ContentManager.SaveStringPreferences("APP_TOKEN", token);
    }

    public static String getAppToken() {
        if (TextUtils.isEmpty((CharSequence)mAppToken)) {
            mAppToken = ContentManager.getStringPreferences("APP_TOKEN");
        }
        return mAppToken;
    }

    public static boolean isGV() {
        return ContentManager.getBooleanPreferences("IS_GV");
    }

    static void setGV(boolean isGV) {
        ContentManager.SaveBooleanPreferences("IS_GV", isGV);
    }

    static boolean isFnB() {
        return ContentManager.getBooleanPreferences("IS_FnB");
    }

    static void setFnB(boolean isFnB) {
        ContentManager.SaveBooleanPreferences("IS_FnB", isFnB);
    }

    private static void setAppType(GuestManager.APP_TYPE appType) {
        ContentManager.SaveStringPreferences("APP_TYPE", appType.name());
    }

    static String getAppType() {
        return ContentManager.getStringPreferences("APP_TYPE");
    }

    public static String getContentSessionToken() {
        if (TextUtils.isEmpty((CharSequence)mContentSessionToken)) {
            mContentSessionToken = ContentManager.getStringPreferences("SESSION_TOKEN");
        }
        return mContentSessionToken;
    }

    public static void resetContentSessionToken() {
        ContentManager.setContentSessionToken(null);
    }

    public static void setContentSessionToken(String token) {
        mContentSessionToken = token;
        ContentManager.SaveStringPreferences("SESSION_TOKEN", token);
    }

    public static int getContentVersionNumber() {
        if (mContentVersionNumberMap.get(ContentManager.getPropertyCode()) == null) {
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            return dataCacheHelper.getContentVersionNumber();
        }
        try {
            return mContentVersionNumberMap.get(ContentManager.getPropertyCode());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void resetContentVersionNumber() {
        ContentManager.setContentVersionNumber(0);
    }

    public static void setContentVersionNumber(int value) {
        mContentVersionNumberMap.put(ContentManager.getPropertyCode(), value);
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.setContentVersionNumber(value);
    }

    public static void setGXPCurrentVersion(int version) {
        ContentManager.SaveIntPreferences("GXP_CURRENT_VERSION_NUMBER", version);
    }

    public static void setDraftVersion(boolean draftVersion) {
        ContentManager.SaveBooleanPreferences("DRAFT_VERSION", draftVersion);
    }

    public static void deleteContentForOldVersion(int version) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.deleteContentForOldVersion(version);
    }

    public static void addAssetRegistration(RegisterAssetResponseDetailsAssetContent content) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.addAssetRegistration(content);
    }

    static void deleteAssetRegistration() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.deleteAssetRegistration();
    }

    public static RegisterAssetResponseDetailsAssetContent getAssetRegistration() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getAssetRegistration();
    }

    public static void setStaticContent(String langCode, int version, JsonObject messagesDictionary) {
        TranslationUtils.mStaticContentData.put(langCode, messagesDictionary);
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertStaticContent(ContentManager.getPropertyCode(), langCode, version, messagesDictionary);
    }

    public static JsonObject getStaticContent() {
        return ContentManager.getStaticContent(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode());
    }

    public static JsonObject getStaticContent(String propertyCode, String langCode) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getStaticContent(propertyCode, langCode);
    }

    public static void setHomePageContent(String langCode, int version, HomePageResponseDetailsHomepageContent content) {
        mHomePageContentData.put(langCode, content);
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertHomePageContent(ContentManager.getPropertyCode(), langCode, version, content);
    }

    public static void setHomePageContentByGuest(String langCode, int version, HomePageResponseDetailsHomepageContent content) {
        mHomePageContentByGuestData.put(langCode, content);
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertHomePageContentByGuest(ContentManager.getPropertyCode(), langCode, version, content);
    }

    static HomePageResponseDetailsHomepageContent getHomePageContent(String languageCode) {
        DataCacheHelper dataCacheHelper;
        HomePageResponseDetailsHomepageContent homePageContent = mHomePageContentData.get(languageCode);
        HomePageResponseDetailsHomepageContent homePageContentByGuest = mHomePageContentByGuestData.get(languageCode);
        if (homePageContent == null) {
            dataCacheHelper = new DataCacheHelper(mAppContext);
            homePageContent = dataCacheHelper.getHomePageContent(languageCode);
            mHomePageContentData.put(languageCode, homePageContent);
        }
        if (homePageContentByGuest == null) {
            dataCacheHelper = new DataCacheHelper(mAppContext);
            homePageContentByGuest = dataCacheHelper.getHomePageContentByGuest(languageCode);
            mHomePageContentByGuestData.put(languageCode, homePageContentByGuest);
        }
        HomePageResponseDetailsHomepageContent content = new HomePageResponseDetailsHomepageContent();
        if (homePageContent != null) {
            if (homePageContent.quicklaunches != null && homePageContent.quicklaunches.size() > 0) {
                content.quicklaunches.addAll(homePageContent.quicklaunches);
            }
            if (homePageContent.widgets != null && homePageContent.widgets.size() > 0) {
                content.widgets.addAll(homePageContent.widgets);
            }
            content.timedBackgroundImages = homePageContent.timedBackgroundImages;
        }
        if (homePageContentByGuest != null) {
            if (homePageContentByGuest.quicklaunches != null && homePageContentByGuest.quicklaunches.size() > 0) {
                content.quicklaunches.addAll(homePageContentByGuest.quicklaunches);
            }
            if (homePageContentByGuest.widgets != null && homePageContentByGuest.widgets.size() > 0) {
                content.widgets.addAll(homePageContentByGuest.widgets);
            }
        }
        if (content.quicklaunches != null) {
            Collections.sort(content.quicklaunches, new HomePageQuickLaunchesComparator());
        }
        return homePageContent == null && homePageContentByGuest == null ? null : content;
    }

    public static HomePageResponseDetailsHomepageContent getHomePageContent() {
        return ContentManager.getHomePageContent(LanguagesManager.getSelectedLanguageCode());
    }

    public static void setSectionsCategoryItems(String languageCode, int versionNumber, String outletCode, SectionsResponseDetailsSectionsContent content, int guestId) {
        if (content != null) {
            if (content.sections == null) {
                content.sections = new ArrayList();
            }
            if (content.categoryItems == null) {
                content.categoryItems = new ArrayList();
            }
            if (TextUtils.isEmpty((CharSequence)outletCode)) {
                outletCode = "0";
            }
            for (Section section : content.sections) {
                section.propertyCode = ContentManager.getPropertyCode();
                section.outletCode = outletCode;
                if (section.categories == null || section.categories.size() <= 0) continue;
                for (Category cat : section.categories) {
                    cat.sectionCode = section.code;
                    if (cat.subCategories != null && cat.subCategories.size() > 0) {
                        for (SubCategory subcat : cat.subCategories) {
                            for (CategoryItem item : content.categoryItems) {
                                if (!item.categoryCode.equals(subcat.code)) continue;
                                item.outletCode = outletCode;
                                item.sectionCode = section.code;
                            }
                        }
                        continue;
                    }
                    for (CategoryItem item : content.categoryItems) {
                        if (!item.categoryCode.equals(cat.code)) continue;
                        item.outletCode = outletCode;
                        item.sectionCode = section.code;
                        item.fromPrice = item.getBasePrice();
                    }
                }
            }
            if (outletCode.equals("0")) {
                if (guestId == 0) {
                    mStandardSectionsMap.put(languageCode, content.sections);
                } else {
                    mGuestSectionsMap.put(languageCode, content.sections);
                }
            }
        }
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertSectionsCategoryItems(ContentManager.getPropertyCode(), languageCode, versionNumber, outletCode, content, guestId);
    }

    public static ArrayList<CategoryItem> getCategoryItems(String outletCode, String categoryCode) {
        ArrayList<CategoryItem> items = mCategoryItemsMap.get(categoryCode);
        if (items != null) {
            return items;
        }
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        items = dataCacheHelper.getCategoryItems(outletCode, categoryCode);
        if (items != null) {
            mCategoryItemsMap.put(categoryCode, items);
        }
        return items;
    }

    public static void setOutlets(String languageCode, int versionNumber, OutletsResponseDetailsOutletsContent content) {
        if (content != null && content.outlets != null && content.outlets.size() > 0) {
            mOutletsMap.put(languageCode, content.outlets);
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            dataCacheHelper.insertOutlets(ContentManager.getPropertyCode(), languageCode, versionNumber, content);
            ContentManager.setContentVersionNumber(versionNumber);
        }
    }

    public static ArrayList<Outlet> getOutlets() {
        ArrayList<Outlet> outlets = mOutletsMap.get(LanguagesManager.getSelectedLanguageCode());
        if (outlets != null) {
            return outlets;
        }
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        outlets = dataCacheHelper.getOutlets();
        if (outlets == null) {
            Intent serviceIntent = new Intent(mAppContext, ContentIntentService.class);
            serviceIntent.putExtra("ACTION", "getOutlets");
            mAppContext.startService(serviceIntent);
        } else if (outlets.size() > 0) {
            Collections.sort(outlets, new OutletsComparator());
        }
        return outlets;
    }

    public static Outlet getOutlet(String code) {
        ArrayList<Outlet> outlets = ContentManager.getOutlets();
        if (outlets != null) {
            for (Outlet o : outlets) {
                if (!o.code.equals(code)) continue;
                return o;
            }
        }
        Intent serviceIntent = new Intent(mAppContext, ContentIntentService.class);
        serviceIntent.putExtra("ACTION", "getOutletContent");
        serviceIntent.putExtra("OUTLET_CODE", code);
        mAppContext.startService(serviceIntent);
        return null;
    }

    public static void setOutletSettings(String propertyCode, int versionNumber, ArrayList<OutletSettings> outletSettings) {
        if (outletSettings != null && outletSettings.size() > 0) {
            if (mOutletSettingsMap == null) {
                mOutletSettingsMap = new HashMap<String, OutletSettings>();
            }
            mOutletSettingsMap.clear();
            for (OutletSettings settings : outletSettings) {
                ContentManager.setOutletSettings(propertyCode, versionNumber, settings.code, settings);
            }
        }
    }

    public static void setOutletSettings(String propertyCode, int versionNumber, String outletCode, OutletSettings outletSettings) {
        if (mOutletSettingsMap == null) {
            mOutletSettingsMap = new HashMap<String, OutletSettings>();
        }
        mOutletSettingsMap.put(outletCode, outletSettings);
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertOutletSettings(propertyCode, versionNumber, outletCode, outletSettings);
    }

    public static OutletSettings getOutletSettings(String outletCode) {
        OutletSettings settings = mOutletSettingsMap.get(outletCode);
        if (settings != null) {
            return settings;
        }
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        settings = dataCacheHelper.getOutletSettings(outletCode);
        mOutletSettingsMap.put(outletCode, settings);
        return settings;
    }

    public static void setOutletDeliveryAreas(String propertyCode, String languageCode, int versionNumber, String outletCode, OutletDeliveryLocationsResponseDetailsLocationsContent content) {
        if (content != null) {
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            dataCacheHelper.insertDeliveryAreas(propertyCode, languageCode, versionNumber, outletCode, content);
        }
    }

    public static ArrayList<DeliveryLocationArea> getOutletDeliveryAreas(String outletCode) {
        ArrayList<DeliveryLocationArea> items = mOutletDeliveryLocationAreasMap.get(outletCode);
        if (items != null) {
            return items;
        }
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        items = dataCacheHelper.getOutletDeliveryAreas(outletCode);
        mOutletDeliveryLocationAreasMap.put(outletCode, items);
        return items;
    }

    public static void insertGuestProfile(GuestProfileResponseDetailsProfileContent content) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertGuestProfile(content);
    }

    public static GuestProfileResponseDetailsProfileContent getGuestProfile() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getGuestProfile();
    }

    public static void saveUser(User user) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.saveUser(user);
    }

    public static User getUser() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getUser();
    }

    static void deleteUser() {
        GuestManager.setUser(null);
        mConversations = null;
        mOrders = null;
        mGuestSectionsMap = new HashMap<String, ArrayList<Section>>();
        mHomePageContentByGuestData = new HashMap<String, HomePageResponseDetailsHomepageContent>();
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.deleteUser();
        dataCacheHelper.clearGuestData();
    }

    public static void setCartSettings(String propertyCode, int versionNumber, HotelCartSettingsContent content) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertCartSettings(propertyCode, versionNumber, content);
    }

    public static void setCMSSettings(String propertyCode, int versionNumber, HotelCMSSettingsContent content) {
        PropertyManager.mHotelCMSSettings = content;
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertCMSSettings(propertyCode, versionNumber, content);
    }

    public static HotelCMSSettingsContent getCMSSettings() {
        if (PropertyManager.mHotelCMSSettings == null) {
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            PropertyManager.mHotelCMSSettings = dataCacheHelper.getCMSSettings();
        }
        return PropertyManager.mHotelCMSSettings;
    }

    public static JsonObject getMobileConfigurationSettings() {
        try {
            if (PropertyManager.mHotelCMSSettings == null) {
                DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
                PropertyManager.mHotelCMSSettings = dataCacheHelper.getCMSSettings();
            }
            return (JsonObject)PropertyManager.mHotelCMSSettings.mobileConfigurationSettings;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static int getConversationsPollingFrequencyInMinutes() {
        if (PropertyManager.mHotelCMSSettings == null) {
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            PropertyManager.mHotelCMSSettings = dataCacheHelper.getCMSSettings();
        }
        if (PropertyManager.mHotelCMSSettings != null && PropertyManager.mHotelCMSSettings.messagePollingInterval > 0) {
            return PropertyManager.mHotelCMSSettings.messagePollingInterval;
        }
        return 1;
    }

    static int getContentPollingFrequencyInMinutes() {
        int defaultIntervalTime = 15;
        try {
            JsonObject syncSettings;
            JsonObject config;
            JsonObject settings = ContentManager.getMobileConfigurationSettings();
            if (settings != null && (config = (JsonObject)settings.get("config")) != null && (syncSettings = (JsonObject)config.get("syncSettings")) != null) {
                int intervalInMinutes = syncSettings.get("versionPollingIntervalInMins").getAsInt();
                return intervalInMinutes < 1 ? 1 : intervalInMinutes;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultIntervalTime;
    }

    static int getWeatherPollingFrequencyInMinutes() {
        int defaultIntervalTime = 15;
        try {
            JsonObject syncSettings;
            JsonObject config;
            JsonObject settings = ContentManager.getMobileConfigurationSettings();
            if (settings != null && (config = (JsonObject)settings.get("config")) != null && (syncSettings = (JsonObject)config.get("syncSettings")) != null) {
                int intervalInMinutes = syncSettings.get("weatherPollingIntervalInMins").getAsInt();
                return intervalInMinutes < 1 ? 1 : intervalInMinutes;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultIntervalTime;
    }

    static int getRoomCheckInPollingFrequencyInMinutes() {
        int defaultIntervalTime = 5;
        try {
            JsonObject syncSettings;
            JsonObject config;
            JsonObject settings = ContentManager.getMobileConfigurationSettings();
            if (settings != null && (config = (JsonObject)settings.get("config")) != null && (syncSettings = (JsonObject)config.get("syncSettings")) != null) {
                int intervalInMinutes = syncSettings.get("roomCheckInPollingIntervalInMins").getAsInt();
                return intervalInMinutes < 1 ? 1 : intervalInMinutes;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultIntervalTime;
    }

    public static void setPropertySettings(String propertyCode, int versionNumber, HotelPropertySettingsContent content) {
        PropertyManager.mPropertySettings = content;
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertPropertySettings(propertyCode, versionNumber, content);
        ContentManager.setPropertySettingsInMemory();
    }

    public static HotelPropertySettingsContent getPropertySettings() {
        if (PropertyManager.mPropertySettings == null) {
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            PropertyManager.mPropertySettings = dataCacheHelper.getPropertySettings();
            ContentManager.setPropertySettingsInMemory();
        }
        return PropertyManager.mPropertySettings;
    }

    private static void setPropertySettingsInMemory() {
        if (PropertyManager.mPropertySettings != null) {
            PropertyManager.mPropertyName = PropertyManager.mPropertySettings.hotelName;
            PropertyManager.mPropertyCityName = PropertyManager.mPropertySettings.hotelCityName;
            PropertyManager.mCurrentLocationLat = PropertyManager.mPropertySettings.latitude;
            PropertyManager.mCurrentLocationLng = PropertyManager.mPropertySettings.longitude;
            PropertyManager.mDefaultCurrencySymbol = PropertyManager.mPropertySettings.currencySymbol;
            PropertyManager.mTimeZone = PropertyManager.mPropertySettings.timezone;
            if (PropertyManager.mTimeZone != null) {
                TimeZone hotelTZ = TimeZone.getTimeZone(PropertyManager.mTimeZone);
                TimeZone.setDefault(hotelTZ);
            }
            if ((PropertyManager.mNumberOfDecimals = PropertyManager.mPropertySettings.numberOfDecimals) < 0) {
                PropertyManager.mNumberOfDecimals = 2;
            }
            PropertyManager.mMetricsFormat = PropertyManager.mPropertySettings.metricsFormat;
        }
    }

    static void saveCart(String outletCode, ShoppingCart content) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.saveCart(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), outletCode, content);
    }

    static void clearCart(String outletCode) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.clearCart(outletCode);
    }

    static ArrayList<ShoppingCart> restoreCart() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getAllCarts();
    }

    public static void saveForecast(ForecastResponseDetailsForecastContent content) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.insertForecast(content);
    }

    public static ForecastResponseDetailsForecastContent getForecast() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getForecast();
    }

    public static Category getCategory(String outletCode, String code) {
        DebugLog.d(TAG, "getCategory: " + code);
        ArrayList<Section> sections = ContentManager.getAllSections();
        if (sections != null) {
            for (Section s : sections) {
                if (outletCode != null && !s.outletCode.equals(outletCode) || s.categories == null || s.categories.size() <= 0) continue;
                for (Category category : s.categories) {
                    if (!category.code.equals(code)) continue;
                    return category;
                }
            }
        }
        return null;
    }

    public static CategoryItem getCategoryItem(String code, String outletCode) {
        DebugLog.d(TAG, "getCategoryItem: " + code);
        if (mCategoryItemsByCodeMap.get(code) != null) {
            return mCategoryItemsByCodeMap.get(code);
        }
        ArrayList<CategoryItem> items = ContentManager.getAllCategoryItems();
        CategoryItem singleItemFound = null;
        if (items != null) {
            for (CategoryItem item : items) {
                mCategoryItemsByCodeMap.put(item.code, item);
                if (item.code == null || !item.code.equals(code)) continue;
                singleItemFound = item;
                if (item.outletCode == null) {
                    item.outletCode = "0";
                }
                if (!item.outletCode.equals(outletCode)) continue;
                return item;
            }
        }
        return singleItemFound;
    }

    public static ArrayList<Section> getSections(String outletCode) {
        return ContentManager.getSections(outletCode, LanguagesManager.getSelectedLanguageCode());
    }

    /*
     * WARNING - void declaration
     */
    static ArrayList<Section> getSections(String outletCode, String langCode) {
        ArrayList<Object> combinedSections = new ArrayList();
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        if (outletCode == null) {
            ArrayList<Section> standardSections = mStandardSectionsMap.get(langCode);
            if (standardSections == null) {
                standardSections = dataCacheHelper.getOutletSections(null, langCode);
                mStandardSectionsMap.put(langCode, standardSections);
            }
            if (standardSections != null) {
                combinedSections.addAll(standardSections);
                if (GuestManager.isSignedIn()) {
                    void var5_7;
                    ArrayList<Section> arrayList = mGuestSectionsMap.get(langCode);
                    if (arrayList == null) {
                        ArrayList<Section> arrayList2 = dataCacheHelper.getGuestSections(langCode);
                    }
                    if (var5_7 != null) {
                        mGuestSectionsMap.put(langCode, (ArrayList<Section>)var5_7);
                        combinedSections.addAll((Collection<Object>)var5_7);
                    } else {
                        int guestId;
                        GuestProfileResponseDetailsProfileContent guestProfile = ContentManager.getGuestProfile();
                        if (guestProfile != null && (guestId = guestProfile.guestId) > 0) {
                            if (ContentManager.isGV()) {
                                RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
                                if (assetContent != null) {
                                    GuestManager.getGuestContent(assetContent, guestId);
                                }
                            } else {
                                GuestManager.getGuestContent(guestId);
                            }
                        }
                    }
                }
            }
        } else {
            combinedSections = dataCacheHelper.getOutletSections(outletCode, langCode);
        }
        if (combinedSections != null && combinedSections.size() > 0) {
            Collections.sort(combinedSections, new SectionsComparator());
            for (Section section : combinedSections) {
                if (section.categories == null || section.categories.size() <= 0) continue;
                Collections.sort(section.categories, new CategoriesComparator());
                for (Category cat : section.categories) {
                    if (cat.subCategories == null || cat.subCategories.size() <= 0) continue;
                    Collections.sort(cat.subCategories, new SubCategoriesComparator());
                }
            }
            return combinedSections;
        }
        DebugLog.d(TAG, "Calling the server to get content for language " + langCode);
        Intent serviceIntent = new Intent(mAppContext, ContentIntentService.class);
        serviceIntent.putExtra("ACTION", "doUpdateLanguage");
        serviceIntent.putExtra("LANGUAGE_CODE", langCode);
        mAppContext.startService(serviceIntent);
        return null;
    }

    public static Section getSection(String code) {
        if (mSectionsByCodeMap.get(code) != null) {
            return mSectionsByCodeMap.get(code);
        }
        ArrayList<Section> sections = ContentManager.getSections(null);
        if (sections != null) {
            for (Section s : sections) {
                mSectionsByCodeMap.put(s.code, s);
                if (!s.code.equals(code)) continue;
                return s;
            }
        }
        if ((sections = ContentManager.getAllSections()) != null) {
            for (Section s : sections) {
                mSectionsByCodeMap.put(s.code, s);
                if (!s.code.equals(code)) continue;
                return s;
            }
        }
        return null;
    }

    private static ArrayList<Section> getAllSections() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getAllSections();
    }

    private static ArrayList<CategoryItem> getAllCategoryItems() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getAllCategoryItems();
    }

    public static void saveGuestConversations(ConversationsResponseDetailsContent content) {
        mConversations = content.conversations;
        try {
            if (mConversations != null && mConversations.size() > 0) {
                for (Conversation c : mConversations) {
                    if (c.messages == null || c.messages.size() <= 0) continue;
                    Collections.sort(c.messages, new MessagesDateTimeComparator());
                }
                Collections.sort(mConversations, new ConversationsDateTimeComparator());
            }
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            dataCacheHelper.saveGuestConversations(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<Conversation> getGuestConversations() {
        if (mConversations != null) {
            return mConversations;
        }
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        mConversations = dataCacheHelper.getGuestConversations();
        return mConversations;
    }

    static int getNumberOfUnreadMessages() {
        int value = 0;
        if (mConversations == null) {
            ContentManager.getGuestConversations();
        }
        if (mConversations != null && mConversations.size() > 0) {
            for (Conversation c : mConversations) {
                value += c.getUnreadMessages();
            }
        }
        return value;
    }

    public static void saveGuestOrderHistory(OrderHistoryResponseDetailsGetOrdersContent content) {
        if (content != null) {
            mOrders = ContentManager.getNonVerifiedGuestOrderHistory();
            if (mOrders == null) {
                mOrders = new ArrayList();
            }
            mOrders.addAll(content.orders);
            Collections.sort(mOrders, new OrderHistoryDateTimeComparator());
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            dataCacheHelper.saveGuestOrderHistory(content);
        }
    }

    public static void clearNonVerifiedGuestOrderHistory() {
        ContentManager.saveNonVerifiedGuestOrderHistory(null);
    }

    public static void saveNonVerifiedGuestOrderHistory(OrderHistoryResponseDetailsGetOrdersContent content) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.saveNonVerifiedGuestOrderHistory(content);
        mOrders = null;
    }

    public static ArrayList<OrderHistoryItem> getGuestOrderHistory() {
        if (mOrders != null) {
            return mOrders;
        }
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        mOrders = dataCacheHelper.getGuestOrderHistory();
        Collections.sort(mOrders, new OrderHistoryDateTimeComparator());
        return mOrders;
    }

    private static ArrayList<OrderHistoryItem> getNonVerifiedGuestOrderHistory() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getNonVerifiedGuestOrderHistory();
    }

    static void saveNonVerifiedGuestFields(String outletCode, ArrayList<NonVerifiedGuestField> content) {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        dataCacheHelper.saveNonVerifiedGuestFields(ContentManager.getPropertyCode(), LanguagesManager.getSelectedLanguageCode(), ContentManager.getContentVersionNumber(), outletCode, content);
    }

    static Map<String, ArrayList<NonVerifiedGuestField>> restoreNonVerifiedGuestFields() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.getAllNonVerifiedGuestFields();
    }

    public static void saveNonVerifiedOrder(ShoppingCart cart, String orderReference) {
        if (cart != null && cart.items != null) {
            OrderHistoryItem orderHistoryItem = new OrderHistoryItem();
            orderHistoryItem.id = orderReference;
            orderHistoryItem.code = null;
            orderHistoryItem.outletCode = cart.outletCode;
            orderHistoryItem.outletName = cart.outletName;
            orderHistoryItem.serviceCharge = cart.serviceCharge;
            orderHistoryItem.tax = cart.tax;
            orderHistoryItem.deliveryCharge = cart.deliveryCharge;
            orderHistoryItem.total = cart.total;
            orderHistoryItem.guestComment = cart.comments;
            if (CartManager.getDeliveryTime(cart.outletCode) != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.getDefault());
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                orderHistoryItem.deliveryDateTimeUtc = dateFormat.format(CartManager.getDeliveryTime(cart.outletCode));
                orderHistoryItem.createdDateTimeUtc = dateFormat.format(new Date());
            }
            if (CartManager.mDeliveryLocationMap.get(orderHistoryItem.outletCode) != null) {
                orderHistoryItem.deliveryLocation = CartManager.mDeliveryLocationMap.get((Object)orderHistoryItem.outletCode).name;
            } else if (CartManager.getDeliveryLocationOption(cart.outletCode) == 1) {
                orderHistoryItem.deliveryLocation = TranslationUtils.getTranslatedString("valet_shared_label.my_room");
            } else if (CartManager.getDeliveryLocationOption(cart.outletCode) == 2) {
                orderHistoryItem.deliveryLocation = TranslationUtils.getTranslatedString("valet_product_label.pick_up");
            }
            orderHistoryItem.guestComment = cart.comments;
            orderHistoryItem.status = null;
            orderHistoryItem.items = new ArrayList();
            for (ShoppingCartItem shoppingCartItem : cart.items) {
                if (shoppingCartItem == null || shoppingCartItem.item == null) continue;
                OrderItem item = new OrderItem();
                item.code = shoppingCartItem.item.code;
                item.price = shoppingCartItem.item.price;
                item.quantity = shoppingCartItem.quantity;
                item.name = shoppingCartItem.item.name;
                item.type = shoppingCartItem.item.type;
                item.comments = shoppingCartItem.comments;
                if (shoppingCartItem.item.modifiers != null && shoppingCartItem.item.modifiers.size() > 0) {
                    item.modifiers = new ArrayList();
                    for (Modifier shoppingCartItemModifier : shoppingCartItem.item.modifiers) {
                        OrderItemModifier orderItemModifier = new OrderItemModifier();
                        orderItemModifier.code = shoppingCartItemModifier.code;
                        orderItemModifier.name = shoppingCartItemModifier.name;
                        orderItemModifier.options = new ArrayList();
                        if (shoppingCartItemModifier.type != null && shoppingCartItemModifier.type.toLowerCase().contains("text") && !TextUtils.isEmpty((CharSequence)shoppingCartItemModifier.value)) {
                            OrderItemModifierOption orderItemModifierOption = new OrderItemModifierOption();
                            orderItemModifierOption.name = shoppingCartItemModifier.value;
                            orderItemModifier.options.add(orderItemModifierOption);
                        } else {
                            orderItemModifier.orderItemCode = shoppingCartItemModifier.parentModifierOptionCode;
                            if (shoppingCartItemModifier.modifierOptions != null && shoppingCartItemModifier.modifierOptions.size() > 0) {
                                for (ModifierOption shoppingCartItemModifierOption : shoppingCartItemModifier.modifierOptions) {
                                    if (shoppingCartItemModifierOption.subModifiers != null && shoppingCartItemModifierOption.subModifiers.size() > 0) {
                                        for (SubModifier sm : shoppingCartItemModifierOption.subModifiers) {
                                            if (sm.modifierOptions == null || sm.modifierOptions.size() <= 0) continue;
                                            for (ModifierOption smo : sm.modifierOptions) {
                                                if (smo.quantity <= 0) continue;
                                                OrderItemModifierOption orderItemModifierOption = new OrderItemModifierOption();
                                                orderItemModifierOption.code = shoppingCartItemModifierOption.code;
                                                orderItemModifierOption.name = shoppingCartItemModifierOption.name;
                                                orderItemModifierOption.price = shoppingCartItemModifierOption.price;
                                                orderItemModifierOption.orderItemModifierCode = shoppingCartItemModifierOption.modifierOptionCode;
                                                if (orderItemModifierOption.subModifiers == null) {
                                                    orderItemModifierOption.subModifiers = new ArrayList();
                                                }
                                                OrderItemSubModifier subModifier = new OrderItemSubModifier();
                                                subModifier.code = sm.code;
                                                subModifier.name = sm.name;
                                                subModifier.orderItemCode = smo.code;
                                                subModifier.options = new ArrayList();
                                                for (int i = 0; i < smo.quantity; ++i) {
                                                    OrderItemModifierOption subModifierOption = new OrderItemModifierOption();
                                                    subModifierOption.code = smo.code;
                                                    subModifierOption.name = smo.name;
                                                    subModifierOption.price = smo.price;
                                                    subModifier.options.add(subModifierOption);
                                                }
                                                orderItemModifierOption.subModifiers.add(subModifier);
                                            }
                                        }
                                    }
                                    if (shoppingCartItemModifierOption.quantity <= 0) continue;
                                    for (int i = 0; i < shoppingCartItemModifierOption.quantity; ++i) {
                                        OrderItemModifierOption orderItemModifierOption = new OrderItemModifierOption();
                                        orderItemModifierOption.code = shoppingCartItemModifierOption.code;
                                        orderItemModifierOption.name = shoppingCartItemModifierOption.name;
                                        orderItemModifierOption.price = shoppingCartItemModifierOption.price;
                                        orderItemModifierOption.orderItemModifierCode = shoppingCartItemModifierOption.modifierOptionCode;
                                        orderItemModifier.options.add(orderItemModifierOption);
                                    }
                                }
                            }
                        }
                        item.modifiers.add(orderItemModifier);
                    }
                }
                orderHistoryItem.items.add(item);
            }
            if (mOrders == null) {
                mOrders = new ArrayList();
            }
            mOrders.add(0, orderHistoryItem);
            ArrayList<OrderHistoryItem> orders = ContentManager.getNonVerifiedGuestOrderHistory();
            if (orders == null) {
                orders = new ArrayList();
            }
            orders.add(0, orderHistoryItem);
            OrderHistoryResponseDetailsGetOrdersContent content = new OrderHistoryResponseDetailsGetOrdersContent();
            content.orders = orders;
            ContentManager.saveNonVerifiedGuestOrderHistory(content);
        }
    }

    public static void saveNonVerifiedServiceRequest(ServiceRequestDetails data, String serviceRequestId) {
        if (data != null && data.item != null && ServiceManager.getServiceItem() != null) {
            OrderHistoryItem orderHistoryItem = new OrderHistoryItem();
            orderHistoryItem.id = serviceRequestId;
            orderHistoryItem.code = ServiceManager.getServiceItem().code;
            orderHistoryItem.outletCode = ServiceManager.getServiceItem().outletCode;
            if (ContentManager.getOutlet(ServiceManager.getServiceItem().outletCode) != null) {
                orderHistoryItem.outletName = ContentManager.getOutlet((String)ServiceManager.getServiceItem().outletCode).name;
            }
            orderHistoryItem.serviceCharge = 0.0f;
            orderHistoryItem.deliveryCharge = 0.0f;
            orderHistoryItem.tax = 0.0f;
            orderHistoryItem.total = ServiceManager.getServiceItem().getPrice();
            orderHistoryItem.guestComment = data.item.comment;
            Date deliveryTime = new Date();
            if (ServiceManager.getDeliveryTime() != null) {
                deliveryTime = ServiceManager.getDeliveryTime();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.getDefault());
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            orderHistoryItem.deliveryDateTimeUtc = dateFormat.format(deliveryTime);
            orderHistoryItem.createdDateTimeUtc = dateFormat.format(new Date());
            orderHistoryItem.deliveryLocation = TranslationUtils.getTranslatedString("valet_shared_label.my_room");
            orderHistoryItem.guestComment = data.item.comment;
            orderHistoryItem.status = null;
            orderHistoryItem.items = new ArrayList();
            OrderItem item = new OrderItem();
            item.code = ServiceManager.getServiceItem().code;
            item.price = ServiceManager.getServiceItem().price;
            item.quantity = 1;
            item.name = ServiceManager.getServiceItem().name;
            item.type = ServiceManager.getServiceItem().type;
            item.comments = "";
            if (ServiceManager.getServiceItem().modifiers != null && ServiceManager.getServiceItem().modifiers.size() > 0) {
                item.modifiers = new ArrayList();
                for (Modifier shoppingCartItemModifier : ServiceManager.getServiceItem().modifiers) {
                    OrderItemModifier orderItemModifier = new OrderItemModifier();
                    orderItemModifier.code = shoppingCartItemModifier.code;
                    orderItemModifier.name = shoppingCartItemModifier.name;
                    orderItemModifier.options = new ArrayList();
                    if (shoppingCartItemModifier.type != null && shoppingCartItemModifier.type.toLowerCase().contains("text") && !TextUtils.isEmpty((CharSequence)shoppingCartItemModifier.value)) {
                        OrderItemModifierOption orderItemModifierOption = new OrderItemModifierOption();
                        orderItemModifierOption.name = shoppingCartItemModifier.value;
                        orderItemModifier.options.add(orderItemModifierOption);
                    } else {
                        orderItemModifier.orderItemCode = shoppingCartItemModifier.parentModifierOptionCode;
                        if (shoppingCartItemModifier.modifierOptions != null && shoppingCartItemModifier.modifierOptions.size() > 0) {
                            for (ModifierOption shoppingCartItemModifierOption : shoppingCartItemModifier.modifierOptions) {
                                if (shoppingCartItemModifierOption.quantity <= 0) continue;
                                for (int i = 0; i < shoppingCartItemModifierOption.quantity; ++i) {
                                    OrderItemModifierOption orderItemModifierOption = new OrderItemModifierOption();
                                    orderItemModifierOption.code = shoppingCartItemModifierOption.code;
                                    orderItemModifierOption.name = shoppingCartItemModifierOption.name;
                                    orderItemModifierOption.price = shoppingCartItemModifierOption.price;
                                    orderItemModifierOption.orderItemModifierCode = shoppingCartItemModifierOption.modifierOptionCode;
                                    orderItemModifier.options.add(orderItemModifierOption);
                                }
                            }
                        }
                    }
                    item.modifiers.add(orderItemModifier);
                }
            }
            orderHistoryItem.items.add(item);
            if (mOrders == null) {
                mOrders = new ArrayList();
            }
            mOrders.add(0, orderHistoryItem);
            ArrayList<OrderHistoryItem> orders = ContentManager.getNonVerifiedGuestOrderHistory();
            if (orders == null) {
                orders = new ArrayList();
            }
            orders.add(0, orderHistoryItem);
            OrderHistoryResponseDetailsGetOrdersContent content = new OrderHistoryResponseDetailsGetOrdersContent();
            content.orders = orders;
            ContentManager.saveNonVerifiedGuestOrderHistory(content);
        }
    }
}

