/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.gson.JsonObject;
import com.irisvalet.android.apps.mobilevalethelper.BaseManager;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.ForecastResponseDetailsForecastContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.RegisterAssetResponseDetailsAssetContent;
import com.irisvalet.android.apps.mobilevalethelper.database.DataCacheHelper;
import com.irisvalet.android.apps.mobilevalethelper.library.ContentManagerListener.ContentManagerListener;
import com.irisvalet.android.apps.mobilevalethelper.library.GuestAlarmListener;
import com.irisvalet.android.apps.mobilevalethelper.object.OutletSettings;
import com.irisvalet.android.apps.mobilevalethelper.object.User;
import com.irisvalet.android.apps.mobilevalethelper.receiver.ContentSyncAlarmReceiver;
import com.irisvalet.android.apps.mobilevalethelper.receiver.GuestAlarmAlarmReceiver;
import com.irisvalet.android.apps.mobilevalethelper.receiver.GuestClockAlarmReceiver;
import com.irisvalet.android.apps.mobilevalethelper.receiver.GuestConversationsAlarmReceiver;
import com.irisvalet.android.apps.mobilevalethelper.receiver.GuestWelcomeMessageReceiver;
import com.irisvalet.android.apps.mobilevalethelper.receiver.RoomCheckInAlarmReceiver;
import com.irisvalet.android.apps.mobilevalethelper.receiver.WeatherAlarmReceiver;
import com.irisvalet.android.apps.mobilevalethelper.service.AssetApiIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.ContentIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.GeneralApiIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.GuestApiIntentService;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.util.Calendar;
import java.util.Date;

public class GuestManager
extends BaseManager {
    private static final String TAG = "GuestManager";
    private static String mAPIManagementKey = null;
    private static String mEnvName = null;
    private static User mUser = null;
    private static ContentManagerListener contentManagerListener = null;
    private static GuestAlarmListener guestAlarmListener = null;
    private static final int weatherAlertId = 703;
    private static final int contentSyncAlertId = 704;
    private static final int guestClockAlertId = 705;
    private static final int guestAlarmAlertId = 706;
    private static final int guestConversationsAlertId = 702;
    private static AlarmManager mRoomCheckInAlarm = null;
    private static AlarmManager mGuestClockManager = null;
    private static AlarmManager mGuestAlarmManager = null;
    private static AlarmManager weatherAlarmManager = null;
    private static AlarmManager contentSyncAlarmManager = null;
    private static AlarmManager guestConversationsAlarmManager = null;
    private static AlarmManager alarmGuestWelcomeMessageAlarmMgr = null;
    private static PendingIntent guestConversationsPendingIntent = null;
    private static PendingIntent roomCheckInPendingIntent = null;
    private static PendingIntent alarmGuestWelcomeMessageAlarmIntent = null;
    private static boolean alarmSet = false;
    private static Date alarmTime = null;
    private static boolean mHttpLevelLoggingEnabled = false;

    public static void initialize(Context context, String environment, String apiManagementKey, String propertyCode, String appToken, APP_TYPE appType, boolean isGV) throws Exception {
        mAppContext = context.getApplicationContext();
        if (TextUtils.isEmpty((CharSequence)apiManagementKey)) {
            throw new Exception("Invalid apiManagementKey");
        }
        if (TextUtils.isEmpty((CharSequence)propertyCode)) {
            throw new Exception("Invalid property code");
        }
        GuestManager.setAPIManagementKey(apiManagementKey);
        GuestManager.setEnv(environment);
        ContentManager.initialize(mAppContext, propertyCode, appToken, appType, isGV);
        GuestManager.setFnb(appType == APP_TYPE.FnB_APP);
        GuestManager.setGV(isGV);
        GuestManager.setHttpLevelLogging(false);
        if (isGV) {
            GuestManager.initiateSync(ContentManager.getContentPollingFrequencyInMinutes());
        }
    }

    public static void onLowMemory() {
        ContentManager.onLowMemory();
    }

    private static void initiateSync(int intervalInMinutes) {
        if (mAppContext == null) {
            return;
        }
        if (contentSyncAlarmManager == null) {
            Intent intent = new Intent(mAppContext, ContentSyncAlarmReceiver.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)mAppContext, (int)704, (Intent)intent, (int)0x8000000);
            contentSyncAlarmManager = (AlarmManager)mAppContext.getSystemService("alarm");
            contentSyncAlarmManager.setInexactRepeating(1, System.currentTimeMillis() + (long)(intervalInMinutes * 60 * 1000), (long)(intervalInMinutes * 60 * 1000), pendingIntent);
        }
    }

    public static void initializeContent() {
        Intent serviceIntent = new Intent(mAppContext, ContentIntentService.class);
        serviceIntent.putExtra("ACTION", "SessionInitialise");
        mAppContext.startService(serviceIntent);
        GuestManager.getWeather();
    }

    public static void setHttpLevelLogging(boolean value) {
        mHttpLevelLoggingEnabled = value;
    }

    public static boolean getHttpLevelLogging() {
        return false;
    }

    public static User getUser() {
        if (mUser == null) {
            mUser = ContentManager.getUser();
        }
        return mUser;
    }

    private static void setAPIManagementKey(String key) {
        mAPIManagementKey = key;
        GuestManager.SaveStringPreferences("APIManagementKey", key);
    }

    public static String getAPIManagementKey() {
        return mAPIManagementKey != null ? mAPIManagementKey : GuestManager.getStringPreferences("APIManagementKey");
    }

    private static void setEnv(String environment) {
        mEnvName = environment;
        GuestManager.SaveStringPreferences("ENVIRONMENT_NAME", environment);
    }

    private static String getEnv() {
        return mEnvName != null ? mEnvName : GuestManager.getStringPreferences("ENVIRONMENT_NAME");
    }

    public static String getEnvPath() {
        return GuestManager.getEnv().toLowerCase().replace("production", "");
    }

    public static String getBaseURL() {
        return "https://apimanagement.iris.net/";
    }

    public static boolean isGV() {
        return ContentManager.isGV();
    }

    private static void setGV(boolean value) {
        ContentManager.setGV(value);
    }

    static boolean isFnb() {
        return ContentManager.isFnB();
    }

    private static void setFnb(boolean value) {
        ContentManager.setFnB(value);
    }

    public static void setUser(User user) {
        mUser = user;
    }

    public static boolean isUserExists() {
        DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
        return dataCacheHelper.isUserExists();
    }

    public static String getPropertyCode() {
        return ContentManager.getPropertyCode();
    }

    public static String getProductName() {
        try {
            if (GuestManager.isGV()) {
                if (GuestManager.isFnb()) {
                    return "guest_table";
                }
                return "guest_room";
            }
            return ContentManager.getAppType();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static String getPackageName() {
        try {
            return mAppContext.getPackageName();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static String getAppVersion() {
        try {
            PackageInfo pInfo = mAppContext.getPackageManager().getPackageInfo(mAppContext.getPackageName(), 0);
            return pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return "unknown";
        }
    }

    public static String getBuildNumber() {
        try {
            PackageInfo pInfo = mAppContext.getPackageManager().getPackageInfo(mAppContext.getPackageName(), 0);
            return Integer.toString(pInfo.versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            return "unknown";
        }
    }

    public static String getDeviceManufacturer() {
        try {
            return Build.MANUFACTURER;
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static String getDeviceModel() {
        try {
            return Build.MODEL;
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static String getOSVersion() {
        try {
            return Build.VERSION.RELEASE;
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static void clearGuestData() {
        mUser = null;
        ContentManager.deleteUser();
    }

    public static String getGuestTitle() {
        if (mUser != null && GuestManager.mUser.title != null) {
            return GuestManager.mUser.title;
        }
        return "";
    }

    public static String getGuestFirstName() {
        if (mUser != null && GuestManager.mUser.firstName != null) {
            return GuestManager.mUser.firstName;
        }
        return "";
    }

    public static String getGuestLastName() {
        if (mUser != null && GuestManager.mUser.lastName != null) {
            return GuestManager.mUser.lastName;
        }
        return "";
    }

    public static String getGuestFullName() {
        return (GuestManager.getGuestFirstName() + " " + GuestManager.getGuestLastName()).trim();
    }

    public static String getGuestFullNameWithTitle() {
        return (GuestManager.getGuestTitle() + " " + GuestManager.getGuestFirstName() + " " + GuestManager.getGuestLastName()).trim();
    }

    public static String getRoomNumber() {
        if (mUser != null && GuestManager.mUser.roomNumber != null) {
            return GuestManager.mUser.roomNumber;
        }
        return "";
    }

    public static void signOut() {
        GuestManager.setUser(null);
        GuestManager.clearGuestData();
    }

    public static boolean isSignedIn() {
        return GuestManager.getUser() != null;
    }

    public static String getPropertyPIN() {
        try {
            String value;
            JsonObject FnBSettings;
            JsonObject config;
            JsonObject settings = ContentManager.getMobileConfigurationSettings();
            if (settings != null && (config = (JsonObject)settings.get("config")) != null && (FnBSettings = (JsonObject)config.get("FnBSettings")) != null && !TextUtils.isEmpty((CharSequence)(value = FnBSettings.get("PIN").getAsString()))) {
                return value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "4747";
    }

    public static void onConnectionFailed() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onConnectionFailed();
    }

    public static void onAppTokenMissing() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onAppTokenMissing();
    }

    public static void onSessionInitializationError(String message) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onSessionInitializationError(message);
    }

    public static void onDownloadProgressUpdate(String message) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onDownloadProgressUpdate(message);
    }

    public static void onContentReady() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onContentReady();
    }

    public static void onOutletContentReady() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onOutletContentReady();
    }

    public static void onContentFailed(String message) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onContentFailed(message);
    }

    public static void onContentVersionValid() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onContentVersionValid();
    }

    public static void onHomePageContentReady() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onHomePageContentReady();
    }

    public static void onWeatherUpdated() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onWeatherForecastUpdates();
    }

    public static void onGuestSignedInSuccess() {
        GuestManager.onGuestCheckedInSuccess();
    }

    public static void onGuestCheckedInSuccess() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onGuestSignedInSuccess();
        if (GuestManager.isGV()) {
            GuestManager.removeRoomCheckInAlarm();
            GuestManager.scheduleGuestConversationsAlarm(ContentManager.getConversationsPollingFrequencyInMinutes());
        }
    }

    public static void onCheckedInSuccess() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onCheckInSuccess();
    }

    public static void onCheckedInFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        if (error != null && error.equals("InvalidReservation")) {
            GuestManager.clearGuestData();
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onCheckInFailed(error);
    }

    public static void guestCheckout(Context context) {
        Intent intent = new Intent(context, GuestApiIntentService.class);
        intent.putExtra("ACTION", "runCheckoutRequest");
        context.startService(intent);
    }

    public static void onCheckoutSuccess() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onCheckoutSuccess();
        GuestManager.clearGuestData();
    }

    public static void onCheckoutFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        if (error != null && error.equals("IdentityTokenExpired")) {
            GuestManager.clearGuestData();
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onCheckoutFailed(error);
    }

    public static void onGuestCheckedOut() {
        if (mAppContext == null) {
            return;
        }
        GuestManager.clearGuestData();
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onGuestCheckedOut();
        if (GuestManager.isGV()) {
            GuestManager.scheduleRoomCheckInAlarm(ContentManager.getRoomCheckInPollingFrequencyInMinutes());
            GuestManager.removeGuestConversationsAlarm();
        }
    }

    public static void onGuestSignedInFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        if (error != null && error.equals("InvalidLoginCredentials")) {
            GuestManager.clearGuestData();
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onGuestSignedInFailed(error);
        if (GuestManager.isGV()) {
            GuestManager.removeGuestConversationsAlarm();
        }
    }

    public static void onDevicePairingSuccess(String roomNumber) {
        if (mAppContext == null) {
            return;
        }
        if (GuestManager.isGV()) {
            GuestManager.scheduleRoomCheckInAlarm(ContentManager.getRoomCheckInPollingFrequencyInMinutes());
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onDevicePairingSuccess(roomNumber);
    }

    public static void onDevicePairingFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onDevicePairingFailed(error);
    }

    public static void onDevicePairingRevoked(String error) {
        if (mAppContext == null) {
            return;
        }
        GuestManager.clearGuestData();
        ContentManager.deleteAssetRegistration();
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onDevicePairingRevoked(error);
    }

    public static void onGuestConversationsSuccess(int unread) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onGuestConversationsSuccess();
        if (unread > 0) {
            contentManagerListener.notifyNewMessages(unread);
        }
    }

    public static void onNewMessageNotification() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onNewMessageNotification();
    }

    public static void onGuestConversationsFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onGuestConversationsFailed(error);
    }

    public static void onWelcomeMessageAlarmTriggered() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onWelcomeMessageAlarmTriggered();
    }

    public static void onGuestOrderHistorySuccess() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onGuestOrderHistorySuccess();
    }

    public static void onGuestOrderHistoryFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onGuestOrderHistoryFailed(error);
    }

    public static void onCreateConversationSuccess() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onCreateConversationSuccess();
    }

    public static void onCreateConversationFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onCreateConversationFailed(error);
    }

    public static void onSendMessageSuccess() {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onSendMessageSuccess();
    }

    public static void onSendMessageFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onSendMessageFailed(error);
    }

    public static void onSectionEncryptedURLReceived(String url) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onSectionEncryptedURLReceived(url);
    }

    public static void onSectionEncryptedURLFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onSectionEncryptedURLFailed(error);
    }

    public static void runRoomCheckIn(RegisterAssetResponseDetailsAssetContent assetContent) {
        Intent intent = new Intent(mAppContext, AssetApiIntentService.class);
        intent.putExtra("ACTION", "initializeSessionByAssetKey");
        intent.putExtra("DEVICE_ID", assetContent.assetId);
        intent.putExtra("ASSET_KEY", assetContent.assetKey);
        intent.putExtra("ROOM", assetContent.roomNumber);
        mAppContext.startService(intent);
    }

    public static ForecastResponseDetailsForecastContent getForecast() {
        ForecastResponseDetailsForecastContent forecast = ContentManager.getForecast();
        if (forecast == null) {
            GuestManager.getWeather();
        }
        return forecast;
    }

    private static void getWeather() {
        if (ContentManager.getContentSessionToken() != null) {
            Intent serviceIntent = new Intent(mAppContext, GeneralApiIntentService.class);
            serviceIntent.putExtra("ACTION", "getForecast");
            mAppContext.startService(serviceIntent);
        }
    }

    public static void onWeatherDataFailed() {
    }

    public static OutletSettings getOutletSettings(String outletCode) {
        OutletSettings settings = ContentManager.getOutletSettings(outletCode);
        if (settings != null) {
            return settings;
        }
        Intent serviceIntent = new Intent(mAppContext, ContentIntentService.class);
        if (outletCode == null) {
            serviceIntent.putExtra("ACTION", "SessionInitialise");
        } else {
            serviceIntent.putExtra("OUTLET_CODE", outletCode);
            serviceIntent.putExtra("ACTION", "getOutletContent");
        }
        mAppContext.startService(serviceIntent);
        return null;
    }

    public static void guestSignIn(String strName, String strRoom) {
        Intent intent = new Intent(mAppContext, GuestApiIntentService.class);
        intent.putExtra("ACTION", "guestLoginRequest");
        intent.putExtra("LAST_NAME", strName);
        intent.putExtra("ROOM", strRoom);
        mAppContext.startService(intent);
    }

    public static void guestCheckIn(Context context, String lastName, String reservationNumber) {
        Intent intent = new Intent(context, GuestApiIntentService.class);
        intent.putExtra("ACTION", "runCheckInRequest");
        intent.putExtra("LAST_NAME", lastName);
        intent.putExtra("RESERVATION_NUMBER", reservationNumber);
        context.startService(intent);
    }

    public static void pairDeviceToRoom(String deviceId, String room, String pin) {
        Intent intent = new Intent(mAppContext, AssetApiIntentService.class);
        intent.putExtra("ACTION", "pairDeviceToRoom");
        intent.putExtra("DEVICE_ID", deviceId);
        intent.putExtra("ROOM", room);
        intent.putExtra("PIN", pin);
        mAppContext.startService(intent);
    }

    public static void checkAssetData(RegisterAssetResponseDetailsAssetContent assetContent) {
        Intent intent = new Intent(mAppContext, AssetApiIntentService.class);
        intent.putExtra("ACTION", "initializeSessionByAssetKey");
        intent.putExtra("DEVICE_ID", assetContent.assetId);
        intent.putExtra("ASSET_KEY", assetContent.assetKey);
        intent.putExtra("ROOM", assetContent.roomNumber);
        mAppContext.startService(intent);
    }

    public static void checkGuestCheckInStatus(RegisterAssetResponseDetailsAssetContent assetContent) {
        Intent intent = new Intent(mAppContext, AssetApiIntentService.class);
        intent.putExtra("ACTION", "runGetGuestProfile");
        intent.putExtra("DEVICE_ID", assetContent.assetId);
        intent.putExtra("ASSET_KEY", assetContent.assetKey);
        intent.putExtra("ROOM", assetContent.roomNumber);
        mAppContext.startService(intent);
    }

    public static void checkGuestCheckInStatus() {
        Intent intent = new Intent(mAppContext, GuestApiIntentService.class);
        intent.putExtra("ACTION", "runGetGuestProfile");
        intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
        intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
        mAppContext.startService(intent);
    }

    static void getGuestContent(RegisterAssetResponseDetailsAssetContent assetContent, int guestId) {
        Intent intent = new Intent(mAppContext, AssetApiIntentService.class);
        intent.putExtra("ACTION", "getGuestContent");
        intent.putExtra("DEVICE_ID", assetContent.assetId);
        intent.putExtra("ASSET_KEY", assetContent.assetKey);
        intent.putExtra("ROOM", assetContent.roomNumber);
        intent.putExtra("GUEST_ID", guestId);
        mAppContext.startService(intent);
    }

    static void getGuestContent(int guestId) {
        Intent intent = new Intent(mAppContext, GuestApiIntentService.class);
        intent.putExtra("ACTION", "getGuestContent");
        intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
        intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
        intent.putExtra("GUEST_ID", guestId);
        mAppContext.startService(intent);
    }

    public static void checkGuestConversations(Context context) {
        Intent intent = new Intent(context, GuestApiIntentService.class);
        intent.putExtra("ACTION", "getConversations");
        intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
        intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
        mAppContext.startService(intent);
    }

    public static void getConversations() {
        Intent intent;
        if (!ContentManager.isGV()) {
            if (!GuestManager.isSignedIn()) {
                if (mAppContext == null) {
                    return;
                }
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onSendMessageFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, GuestApiIntentService.class);
            intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
            intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
        } else {
            RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
            if (assetContent == null) {
                if (mAppContext == null) {
                    return;
                }
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onSendMessageFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, AssetApiIntentService.class);
            intent.putExtra("DEVICE_ID", assetContent.assetId);
            intent.putExtra("ASSET_KEY", assetContent.assetKey);
            intent.putExtra("ROOM", assetContent.roomNumber);
        }
        intent.putExtra("ACTION", "getConversations");
        mAppContext.startService(intent);
    }

    public static void markMessageAsRead(String messageCode) {
        Intent intent;
        if (!ContentManager.isGV()) {
            if (!GuestManager.isSignedIn()) {
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onSendMessageFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, GuestApiIntentService.class);
            intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
            intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
        } else {
            RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
            if (assetContent == null) {
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onSendMessageFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, AssetApiIntentService.class);
            intent.putExtra("DEVICE_ID", assetContent.assetId);
            intent.putExtra("ASSET_KEY", assetContent.assetKey);
            intent.putExtra("ROOM", assetContent.roomNumber);
        }
        intent.putExtra("ACTION", "markMessageAsRead");
        intent.putExtra("MESSAGE_CODE", messageCode);
        mAppContext.startService(intent);
    }

    public static void sendMessage(String outletCode, String conversationCode, String messageContent) {
        Intent intent;
        if (!ContentManager.isGV()) {
            if (!GuestManager.isSignedIn()) {
                if (mAppContext == null) {
                    return;
                }
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onSendMessageFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, GuestApiIntentService.class);
            intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
            intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
        } else {
            RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
            if (assetContent == null) {
                if (mAppContext == null) {
                    return;
                }
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onSendMessageFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, AssetApiIntentService.class);
            intent.putExtra("DEVICE_ID", assetContent.assetId);
            intent.putExtra("ASSET_KEY", assetContent.assetKey);
            intent.putExtra("ROOM", assetContent.roomNumber);
        }
        if (conversationCode == null) {
            intent.putExtra("ACTION", "createConversation");
        } else {
            intent.putExtra("ACTION", "sendMessage");
        }
        intent.putExtra("CONVERSATION_CODE", conversationCode);
        intent.putExtra("OUTLET_CODE", outletCode);
        intent.putExtra("MESSAGE_CONTENT", messageContent);
        mAppContext.startService(intent);
    }

    public static void onMessageFailed(String error) {
        if (mAppContext == null) {
            return;
        }
        contentManagerListener = (ContentManagerListener)mAppContext;
        contentManagerListener.onSendMessageFailed(error);
    }

    public static int getNumberOfUnreadMessages() {
        if (!GuestManager.isSignedIn()) {
            return 0;
        }
        return ContentManager.getNumberOfUnreadMessages();
    }

    public static void getOrderHistory() {
        Intent intent;
        if (!ContentManager.isGV()) {
            if (!GuestManager.isSignedIn()) {
                if (mAppContext == null) {
                    return;
                }
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onGuestOrderHistoryFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, GuestApiIntentService.class);
            intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
            intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
        } else {
            RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
            if (assetContent == null) {
                if (mAppContext == null) {
                    return;
                }
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onGuestOrderHistoryFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, AssetApiIntentService.class);
            intent.putExtra("DEVICE_ID", assetContent.assetId);
            intent.putExtra("ASSET_KEY", assetContent.assetKey);
            intent.putExtra("ROOM", assetContent.roomNumber);
        }
        intent.putExtra("ACTION", "getOrderHistory");
        mAppContext.startService(intent);
    }

    public static void getSectionEncryptedURL(String sectionCode) {
        Intent intent;
        if (!ContentManager.isGV()) {
            if (!GuestManager.isSignedIn()) {
                if (mAppContext == null) {
                    return;
                }
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onSectionEncryptedURLFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, GuestApiIntentService.class);
            intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
            intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
        } else {
            RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
            if (assetContent == null) {
                if (mAppContext == null) {
                    return;
                }
                contentManagerListener = (ContentManagerListener)mAppContext;
                contentManagerListener.onGuestOrderHistoryFailed("Guest not logged in");
                return;
            }
            intent = new Intent(mAppContext, AssetApiIntentService.class);
            intent.putExtra("DEVICE_ID", assetContent.assetId);
            intent.putExtra("ASSET_KEY", assetContent.assetKey);
            intent.putExtra("ROOM", assetContent.roomNumber);
        }
        intent.putExtra("SECTION_CODE", sectionCode);
        intent.putExtra("ACTION", "getSectionEncryptedURL");
        mAppContext.startService(intent);
    }

    public static void scheduleGuestWelcomeMessageAlarm(int intervalInHours) {
        if (alarmGuestWelcomeMessageAlarmMgr != null) {
            alarmGuestWelcomeMessageAlarmMgr.cancel(alarmGuestWelcomeMessageAlarmIntent);
        }
        alarmGuestWelcomeMessageAlarmMgr = (AlarmManager)mAppContext.getSystemService("alarm");
        Intent intent = new Intent(mAppContext, GuestWelcomeMessageReceiver.class);
        alarmGuestWelcomeMessageAlarmIntent = PendingIntent.getBroadcast((Context)mAppContext, (int)0, (Intent)intent, (int)0);
        Calendar calendar = Calendar.getInstance();
        int currentHour = calendar.get(11);
        int next6Hour = currentHour < 6 ? 5 : (currentHour < 12 ? 11 : (currentHour < 18 ? 17 : 23));
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, next6Hour);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        if (alarmGuestWelcomeMessageAlarmMgr != null) {
            alarmGuestWelcomeMessageAlarmMgr.setRepeating(0, calendar.getTimeInMillis(), (long)(3600000 * intervalInHours), alarmGuestWelcomeMessageAlarmIntent);
        }
    }

    public static void registerWeatherAlarm() {
        if (mAppContext == null) {
            return;
        }
        if (GuestManager.isGV()) {
            Intent intent = new Intent(mAppContext, WeatherAlarmReceiver.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)mAppContext, (int)703, (Intent)intent, (int)0x8000000);
            if (weatherAlarmManager != null) {
                weatherAlarmManager.cancel(pendingIntent);
            }
            weatherAlarmManager = (AlarmManager)mAppContext.getSystemService("alarm");
            int intervalInMinutes = ContentManager.getWeatherPollingFrequencyInMinutes();
            weatherAlarmManager.setInexactRepeating(1, System.currentTimeMillis(), (long)(intervalInMinutes * 60 * 1000), pendingIntent);
        }
    }

    private static void scheduleGuestConversationsAlarm(int intervalInMinutes) {
        if (mAppContext == null) {
            return;
        }
        if (guestConversationsAlarmManager == null) {
            Intent intent = new Intent(mAppContext, GuestConversationsAlarmReceiver.class);
            guestConversationsPendingIntent = PendingIntent.getBroadcast((Context)mAppContext, (int)702, (Intent)intent, (int)0x8000000);
            guestConversationsAlarmManager = (AlarmManager)mAppContext.getSystemService("alarm");
            guestConversationsAlarmManager.setRepeating(1, System.currentTimeMillis(), (long)(intervalInMinutes * 60 * 1000), guestConversationsPendingIntent);
        }
    }

    private static void removeGuestConversationsAlarm() {
        if (guestConversationsAlarmManager != null) {
            guestConversationsAlarmManager.cancel(guestConversationsPendingIntent);
            guestConversationsAlarmManager = null;
            guestConversationsPendingIntent = null;
        }
    }

    private static void scheduleRoomCheckInAlarm(int intervalInMinutes) {
        if (mAppContext == null) {
            return;
        }
        if (mRoomCheckInAlarm == null && (mRoomCheckInAlarm = (AlarmManager)mAppContext.getSystemService("alarm")) != null) {
            Intent intent = new Intent(mAppContext, RoomCheckInAlarmReceiver.class);
            roomCheckInPendingIntent = PendingIntent.getBroadcast((Context)mAppContext, (int)0, (Intent)intent, (int)0);
            mRoomCheckInAlarm.setRepeating(1, SystemClock.elapsedRealtime(), (long)(intervalInMinutes * 60 * 1000), roomCheckInPendingIntent);
        }
    }

    private static void removeRoomCheckInAlarm() {
        if (mRoomCheckInAlarm != null) {
            mRoomCheckInAlarm.cancel(roomCheckInPendingIntent);
            mRoomCheckInAlarm = null;
            roomCheckInPendingIntent = null;
        }
    }

    public static void createClock() {
        if (mGuestClockManager == null) {
            mGuestClockManager = (AlarmManager)mAppContext.getSystemService("alarm");
            Intent intent = new Intent(mAppContext, GuestClockAlarmReceiver.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)mAppContext, (int)705, (Intent)intent, (int)0x8000000);
            int interval = 60000;
            Date now = new Date();
            long triggerAtMillis = now.getTime() - now.getTime() % (long)interval;
            mGuestClockManager.setRepeating(1, triggerAtMillis, (long)interval, pendingIntent);
        }
    }

    public static boolean isAlarmSet() {
        return alarmSet;
    }

    public static Date getAlarmTime() {
        return alarmTime;
    }

    public static void setGuestAlarm(boolean setOn, Date alarmTime) {
        if (mGuestAlarmManager == null) {
            mGuestAlarmManager = (AlarmManager)mAppContext.getSystemService("alarm");
        }
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        Intent intent = new Intent(mAppContext, GuestAlarmAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)mAppContext, (int)706, (Intent)intent, (int)0x8000000);
        if (setOn) {
            GuestManager.alarmTime = alarmTime;
            if (mGuestAlarmManager != null) {
                mGuestAlarmManager.set(1, alarmTime.getTime(), pendingIntent);
            }
        } else {
            GuestManager.alarmTime = null;
            if (mGuestAlarmManager != null) {
                mGuestAlarmManager.cancel(pendingIntent);
            }
        }
        alarmSet = setOn;
    }

    public static void updateGuestClock() {
        if (mAppContext == null) {
            return;
        }
        guestAlarmListener = (GuestAlarmListener)mAppContext;
        guestAlarmListener.onGuestClockUpdate();
    }

    public static void runGuestAlarm() {
        DebugLog.d(TAG, "runGuestAlarm " + new Date().toString());
        if (mAppContext == null) {
            return;
        }
        guestAlarmListener = (GuestAlarmListener)mAppContext;
        guestAlarmListener.onGuestAlarmTriggered();
    }

    public static enum APP_TYPE {
        GUEST_MOBILE_APP,
        GUEST_ROOM_APP,
        KIOSK_APP,
        BRAND_APP,
        PROPERTY_APP,
        FnB_APP,
        Associate_APP,
        Custom1,
        Custom2,
        Custom3,
        Custom4,
        Custom5,
        Other;

    }
}

