/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper;

import com.google.gson.Gson;
import com.irisvalet.android.apps.mobilevalethelper.BaseManager;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HomePageResponseDetailsHomepageContent;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.HotelLanguagesSettingsContent;
import com.irisvalet.android.apps.mobilevalethelper.database.DataCacheHelper;
import com.irisvalet.android.apps.mobilevalethelper.library.TranslationManagerListener.TranslationManagerListener;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.DeliveryLocationArea;
import com.irisvalet.android.apps.mobilevalethelper.object.Language;
import com.irisvalet.android.apps.mobilevalethelper.object.Section;
import com.irisvalet.android.apps.mobilevalethelper.utils.DebugLog;
import java.util.ArrayList;
import java.util.HashMap;

public class LanguagesManager
extends BaseManager {
    private static final String TAG = "LanguagesManager";
    private static Language mSelectedLanguage = null;
    private static Language mDefaultLanguage = null;
    private static ArrayList<Language> mLanguages = null;
    private static TranslationManagerListener translationsManager;

    public static void setLanguages(String propertyCode, int versionNumber, HotelLanguagesSettingsContent languages) {
        mLanguages = languages.languages;
        if (mLanguages != null) {
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            dataCacheHelper.insertLanguages(propertyCode, versionNumber, languages);
            LanguagesManager.findDefaultLanguage();
        }
    }

    public static ArrayList<Language> getLanguages() {
        if (mLanguages == null || mDefaultLanguage == null) {
            DataCacheHelper dataCacheHelper = new DataCacheHelper(mAppContext);
            mLanguages = dataCacheHelper.getLanguagesSettings();
        }
        return mLanguages == null ? new ArrayList() : mLanguages;
    }

    public static Language getLanguage(String languageCode) {
        mLanguages = LanguagesManager.getLanguages();
        if (mLanguages != null) {
            for (Language l : mLanguages) {
                if (!l.code.equals(languageCode)) continue;
                return l;
            }
        }
        return null;
    }

    private static void findDefaultLanguage() {
        mLanguages = LanguagesManager.getLanguages();
        if (mLanguages != null && mLanguages.size() > 0) {
            mDefaultLanguage = mLanguages.get(0);
            for (Language language : mLanguages) {
                if (!language.isDefault) continue;
                mDefaultLanguage = language;
                break;
            }
        }
        if (mSelectedLanguage != null) {
            LanguagesManager.SaveStringPreferences("SELECTED_LANGUAGE", mSelectedLanguage.toString());
        }
    }

    public static void setDefaultLanguage() {
        if (mDefaultLanguage != null) {
            mSelectedLanguage = mDefaultLanguage;
        } else {
            LanguagesManager.findDefaultLanguage();
        }
        if (mSelectedLanguage != null) {
            LanguagesManager.SaveStringPreferences("SELECTED_LANGUAGE", mSelectedLanguage.toString());
        }
    }

    public static Language getDefaultLanguage() {
        if (mDefaultLanguage == null) {
            LanguagesManager.findDefaultLanguage();
        }
        return mDefaultLanguage;
    }

    public static void resetLanguage() {
        mLanguages = null;
        mDefaultLanguage = null;
        mSelectedLanguage = null;
        LanguagesManager.SaveStringPreferences("SELECTED_LANGUAGE", null);
    }

    public static void setSelectedLanguage(Language lang) {
        if (lang == null) {
            return;
        }
        DebugLog.d(TAG, "setSelectedLanguage: " + lang.code);
        ArrayList<Section> sections = ContentManager.getSections(null, lang.code);
        HomePageResponseDetailsHomepageContent homePageContent = ContentManager.getHomePageContent(lang.code);
        if (homePageContent != null && sections != null && sections.size() > 0) {
            ContentManager.resetContentSessionToken();
            ContentManager.mCategoryItemsMap = new HashMap<String, ArrayList<CategoryItem>>();
            ContentManager.mOutletDeliveryLocationAreasMap = new HashMap<String, ArrayList<DeliveryLocationArea>>();
            mSelectedLanguage = lang;
            LanguagesManager.SaveStringPreferences("SELECTED_LANGUAGE", lang.toString());
            translationsManager = (TranslationManagerListener)mAppContext.getApplicationContext();
            translationsManager.onUpdateLanguageSettingsSucceeded(mSelectedLanguage);
        }
    }

    public static Language getSelectedLanguage() {
        if (mSelectedLanguage == null) {
            Gson gson = new Gson();
            try {
                mSelectedLanguage = (Language)gson.fromJson(LanguagesManager.getStringPreferences("SELECTED_LANGUAGE"), Language.class);
                if (mSelectedLanguage != null) {
                    return mSelectedLanguage;
                }
                mSelectedLanguage = mDefaultLanguage;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mSelectedLanguage;
    }

    public static String getSelectedLanguageCode() {
        if (LanguagesManager.getSelectedLanguage() != null) {
            return LanguagesManager.mSelectedLanguage.code;
        }
        mSelectedLanguage = LanguagesManager.getDefaultLanguage();
        if (mSelectedLanguage != null) {
            return LanguagesManager.mSelectedLanguage.code;
        }
        return null;
    }

    public static void onUpdateLanguageSettingsSucceeded() {
        translationsManager = (TranslationManagerListener)mAppContext;
        translationsManager.onUpdateLanguageSettingsSucceeded(mSelectedLanguage);
    }

    public static void onUpdateLanguageSettingsFailed() {
        translationsManager = (TranslationManagerListener)mAppContext;
        translationsManager.onUpdateLanguageSettingsFailed();
    }
}

