/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.irisvalet.android.apps.mobilevalethelper.ContentManager;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.Responses.RegisterAssetResponseDetailsAssetContent;
import com.irisvalet.android.apps.mobilevalethelper.library.ServiceManagerListener;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.Modifier;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import com.irisvalet.android.apps.mobilevalethelper.object.NonVerifiedGuestField;
import com.irisvalet.android.apps.mobilevalethelper.object.OutletSettings;
import com.irisvalet.android.apps.mobilevalethelper.service.AssetApiIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.GuestApiIntentService;
import com.irisvalet.android.apps.mobilevalethelper.service.NonGuestApiIntentService;
import com.irisvalet.android.apps.mobilevalethelper.utils.TranslationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ServiceManager {
    private static final String TAG = "ServiceManager";
    private static ServiceManagerListener serviceManagerListener = null;
    private static CategoryItem mServiceItem = null;
    private static Date mDeliveryTime = null;
    private static OutletSettings mOutletSettings = null;
    private static String mDeliveryLocationCode = null;
    private static String mComments = null;
    public static boolean mIsASAP = true;
    private static Map<String, ArrayList<NonVerifiedGuestField>> mNonVerifiedGuestFieldsMap = new HashMap<String, ArrayList<NonVerifiedGuestField>>();

    public static Date getDeliveryTime() {
        if (mDeliveryTime == null) {
            mDeliveryTime = new Date();
        }
        return mDeliveryTime;
    }

    public static void setOutletSettings(OutletSettings settings) {
        mOutletSettings = settings;
    }

    public static OutletSettings getOutletSettings() {
        return mOutletSettings;
    }

    public static String getDeliveryLocationCode() {
        return mDeliveryLocationCode;
    }

    public static void setServiceItem(CategoryItem item) {
        mServiceItem = item;
    }

    public static CategoryItem getServiceItem() {
        return mServiceItem;
    }

    public static void clear() {
        mServiceItem = null;
        mDeliveryTime = null;
        mOutletSettings = null;
        mDeliveryLocationCode = null;
        mComments = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void submitServiceRequest(Context context, String outletCode, CategoryItem item, boolean isASAP, Date deliveryTime, String comments) {
        Intent intent;
        block9: {
            if (context.getApplicationContext() == null) {
                return;
            }
            serviceManagerListener = (ServiceManagerListener)context;
            int mandatoryMissingModifierIndex = ServiceManager.checkMandatoryModifiers(item);
            if (mandatoryMissingModifierIndex >= 0) {
                serviceManagerListener.onPostServiceRequestFailed(102, mandatoryMissingModifierIndex, item);
                return;
            }
            if (item == null) {
                ServiceManager.onPostServiceRequestFailed(context, "Unknown error");
                return;
            }
            mServiceItem = item;
            mDeliveryTime = deliveryTime;
            mComments = comments;
            mIsASAP = isASAP;
            if (!ContentManager.isGV()) {
                if (!GuestManager.isSignedIn()) {
                    OutletSettings settings = ContentManager.getOutletSettings(outletCode);
                    if (settings != null && settings.allowNonVerifiedGuests) {
                        intent = new Intent(context, NonGuestApiIntentService.class);
                        break block9;
                    } else {
                        ServiceManager.onPostServiceRequestFailed(context, TranslationUtils.getTranslatedString("valet_shared_message.invalid_credentials"));
                        return;
                    }
                }
                intent = new Intent(context, GuestApiIntentService.class);
                intent.putExtra("LAST_NAME", GuestManager.getUser().lastName);
                intent.putExtra("ROOM", GuestManager.getUser().roomNumber);
            } else {
                RegisterAssetResponseDetailsAssetContent assetContent = ContentManager.getAssetRegistration();
                if (assetContent == null) {
                    ServiceManager.onPostServiceRequestFailed(context, TranslationUtils.getTranslatedString("valet_shared_message.invalid_credentials"));
                    return;
                }
                intent = new Intent(context, AssetApiIntentService.class);
                intent.putExtra("DEVICE_ID", assetContent.assetId);
                intent.putExtra("ASSET_KEY", assetContent.assetKey);
                intent.putExtra("ROOM", assetContent.roomNumber);
            }
        }
        intent.putExtra("OUTLET_CODE", outletCode);
        intent.putExtra("GUEST_COMMENTS", mComments);
        intent.putExtra("ACTION", "placeGuestServiceRequest");
        context.startService(intent);
    }

    private static int checkMandatoryModifiers(CategoryItem item) {
        if (item != null && item.modifiers != null && item.modifiers.size() > 0) {
            int index = 0;
            for (Modifier m : item.modifiers) {
                if (m != null && m.type != null) {
                    if (m.type.equalsIgnoreCase("text") && m.isRequired) {
                        if (TextUtils.isEmpty((CharSequence)m.value)) {
                            return index;
                        }
                    } else if ((m.type.equalsIgnoreCase("select") || m.type.toLowerCase().contains("multi")) && m.isRequired && m.modifierOptions != null && m.modifierOptions.size() > 0) {
                        boolean modifierSelected = false;
                        for (ModifierOption o : m.modifierOptions) {
                            if (o.quantity <= 0) continue;
                            modifierSelected = true;
                            break;
                        }
                        if (!modifierSelected) {
                            return index;
                        }
                    }
                }
                ++index;
            }
        }
        return -1;
    }

    public static void onPostServiceRequestSuccess(Context context, boolean isNonVerifiedGuest) {
        serviceManagerListener = (ServiceManagerListener)context;
        serviceManagerListener.onPostServiceRequestSuccess(isNonVerifiedGuest);
    }

    public static void onPostServiceRequestFailed(Context context, String error) {
        serviceManagerListener = (ServiceManagerListener)context;
        serviceManagerListener.onPostServiceRequestFailed(error);
    }

    public static void onNonVerifiedOrderSucceed(Context context) {
        serviceManagerListener = (ServiceManagerListener)context;
        serviceManagerListener.onNonVerifiedOrderSucceed();
    }

    public static ArrayList<NonVerifiedGuestField> getNonVerifiedGuestsFields(String outletCode) {
        ServiceManager.restoreNonVerifiedGuestFields();
        if (mNonVerifiedGuestFieldsMap.size() > 0) {
            return mNonVerifiedGuestFieldsMap.get(outletCode);
        }
        return null;
    }

    public static void setNonVerifiedGuestsFields(String outletCode, ArrayList<NonVerifiedGuestField> nonVerifiedGuestFields) {
        mNonVerifiedGuestFieldsMap.put(outletCode, nonVerifiedGuestFields);
        ServiceManager.saveNonVerifiedGuestFields(outletCode);
    }

    private static void saveNonVerifiedGuestFields(String outletCode) {
        ArrayList<NonVerifiedGuestField> nonVerifiedGuestFields;
        if (mNonVerifiedGuestFieldsMap.size() > 0 && (nonVerifiedGuestFields = mNonVerifiedGuestFieldsMap.get(outletCode)) != null) {
            ContentManager.saveNonVerifiedGuestFields(outletCode, nonVerifiedGuestFields);
        }
    }

    private static void restoreNonVerifiedGuestFields() {
        if (mNonVerifiedGuestFieldsMap == null || mNonVerifiedGuestFieldsMap.size() == 0) {
            mNonVerifiedGuestFieldsMap = ContentManager.restoreNonVerifiedGuestFields();
        }
    }
}

