/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.PropertyManager;
import com.irisvalet.android.apps.mobilevalethelper.object.BaseObject;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.Modifier;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import com.irisvalet.android.apps.mobilevalethelper.object.PaymentRecord;
import com.irisvalet.android.apps.mobilevalethelper.object.ShoppingCartItem;
import java.util.ArrayList;

public class ShoppingCart
extends BaseObject {
    private static final String TAG = "ShoppingCart";
    @SerializedName(value="items")
    public ArrayList<ShoppingCartItem> items;
    @SerializedName(value="comments")
    public String comments;
    @SerializedName(value="tax")
    public float tax = 0.0f;
    @SerializedName(value="serviceCharge")
    public float serviceCharge = 0.0f;
    @SerializedName(value="deliveryCharge")
    public float deliveryCharge = 0.0f;
    @SerializedName(value="total")
    public float total = 0.0f;
    @SerializedName(value="propertyCode")
    public String propertyCode;
    @SerializedName(value="outletCode")
    public String outletCode = null;
    @SerializedName(value="outletName")
    public String outletName = null;
    @SerializedName(value="paymentType")
    public int paymentType;
    @SerializedName(value="paymentRecords")
    public ArrayList<PaymentRecord> paymentRecords;

    ShoppingCart(String propertyCode) {
        this.propertyCode = propertyCode;
        this.items = new ArrayList();
    }

    protected boolean add(ShoppingCartItem newItem, int quantity, int cartPosition, String comments) {
        boolean result = true;
        String sameItemId = null;
        if (TextUtils.isEmpty((CharSequence)comments)) {
            sameItemId = this.getSameItemIdInCart(newItem.item);
        }
        if (sameItemId == null) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(cartPosition, newItem);
        } else {
            result = this.update(sameItemId, quantity);
        }
        this.calculateTotal();
        return result;
    }

    private boolean update(String sameItemId, int quantity) {
        boolean result = true;
        if (this.items != null && this.items.size() > 0) {
            for (ShoppingCartItem item : this.items) {
                if (!item.id.equals(sameItemId)) continue;
                result = item.quantity + quantity <= 10;
                item.quantity = Math.min(item.quantity + quantity, 10);
                break;
            }
            this.calculateTotal();
        }
        return result;
    }

    void update(ShoppingCartItem itemToUpdate, int quantity) {
        if (this.items != null && this.items.size() > 0) {
            for (ShoppingCartItem item : this.items) {
                if (!item.id.equals(itemToUpdate.id)) continue;
                item.quantity = Math.min(quantity, 10);
                break;
            }
            this.calculateTotal();
        }
    }

    void remove(ShoppingCartItem item) {
        if (item != null && this.items != null && this.items.size() > 0) {
            this.items.remove(item);
            if (this.items.size() == 0) {
                this.items = null;
            }
            this.countItems();
            this.calculateTotal();
        }
    }

    private String getSameItemIdInCart(CategoryItem newItem) {
        if (this.items == null || this.items.size() == 0) {
            return null;
        }
        String sameItemId = null;
        try {
            sameItemId = this.isSameItemInCart(newItem);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sameItemId;
    }

    private String isSameItemInCart(CategoryItem newItem) {
        for (ShoppingCartItem item : this.items) {
            if (!item.item.code.equals(newItem.code) || !TextUtils.isEmpty((CharSequence)item.comments)) continue;
            if (!(newItem.modifiers != null && newItem.modifiers.size() != 0 || item.item.modifiers != null && item.item.modifiers.size() != 0)) {
                return item.id;
            }
            if ((newItem.modifiers == null || newItem.modifiers.size() == 0) && item.item.modifiers != null && item.item.modifiers.size() > 0) {
                return null;
            }
            if (newItem.modifiers != null && newItem.modifiers.size() > 0 && (item.item.modifiers == null || item.item.modifiers.size() == 0)) {
                return null;
            }
            if (this.isSameModifiers(item.item.modifiers, newItem.modifiers)) {
                return item.id;
            }
            return null;
        }
        return null;
    }

    private boolean isSameModifiers(ArrayList<Modifier> itemModifiers, ArrayList<Modifier> newItemModifiers) {
        try {
            for (Modifier m : itemModifiers) {
                if (m.modifierOptions == null) continue;
                boolean modifierFound = false;
                for (Modifier newM : newItemModifiers) {
                    if (newM.modifierOptions == null || !m.code.equals(newM.code)) continue;
                    modifierFound = true;
                    boolean moFound = false;
                    for (ModifierOption mo : m.modifierOptions) {
                        if (mo.subModifiers != null && mo.subModifiers.size() > 0) {
                            return false;
                        }
                        for (ModifierOption newMO : newM.modifierOptions) {
                            if (!mo.code.equals(newMO.code)) continue;
                            moFound = true;
                            if (mo.quantity == newMO.quantity) continue;
                            return false;
                        }
                    }
                    if (moFound) continue;
                    return false;
                }
                if (modifierFound) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void calculateTotal() {
        float totalBeforeTax = 0.0f;
        if (this.items != null && this.items.size() > 0) {
            for (ShoppingCartItem item : this.items) {
                item.price = 0.0f;
                if (item.item != null && item.quantity > 0) {
                    item.price = item.item.getPrice();
                }
                totalBeforeTax += item.price * (float)item.quantity;
            }
            if (totalBeforeTax > 0.0f) {
                this.total = totalBeforeTax + this.tax + this.serviceCharge + this.deliveryCharge;
            }
        } else {
            this.tax = 0.0f;
            this.serviceCharge = 0.0f;
            this.deliveryCharge = 0.0f;
            this.total = 0.0f;
        }
    }

    int countItems() {
        int count = 0;
        if (this.items != null && this.items.size() > 0) {
            for (ShoppingCartItem item : this.items) {
                count += item.quantity;
            }
        } else {
            this.tax = 0.0f;
            this.serviceCharge = 0.0f;
            this.deliveryCharge = 0.0f;
            this.total = 0.0f;
        }
        return count;
    }

    public String parsePaymentRecords() {
        try {
            if (this.paymentRecords != null && this.paymentRecords.size() > 0) {
                StringBuilder builder = new StringBuilder("");
                for (PaymentRecord record : this.paymentRecords) {
                    if (record == null || TextUtils.isEmpty((CharSequence)record.paymentReference)) continue;
                    String value = PropertyManager.getDefaultCurrencySymbol() + PropertyManager.formatDecimalValue(record.valuePaid);
                    String tips = PropertyManager.getDefaultCurrencySymbol() + PropertyManager.formatDecimalValue(record.valueTips);
                    String line = "Ref: " + record.paymentReference + ", Paid: " + value + ", Tips: " + tips + "|";
                    builder.append(line);
                }
                String result = builder.toString();
                if (result.length() > 99) {
                    result = result.substring(0, 99);
                }
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

