/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.api;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import com.irisvalet.android.apps.mobilevalethelper.api.ApiOkHttpInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ApiClient {
    private static Retrofit retrofit = null;
    private static String baseURL = null;
    private static HttpLoggingInterceptor.Level logLevel = HttpLoggingInterceptor.Level.BODY;

    public static Retrofit getClient() {
        if (baseURL == null) {
            baseURL = GuestManager.getBaseURL();
        }
        if (retrofit == null) {
            OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
            if (GuestManager.getHttpLevelLogging()) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(logLevel);
                httpClient.addInterceptor((Interceptor)logging);
            }
            httpClient.addInterceptor((Interceptor)new ApiOkHttpInterceptor()).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).hostnameVerifier((s, sslSession) -> true);
            Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setPrettyPrinting().create();
            try {
                retrofit = new Retrofit.Builder().baseUrl(baseURL).client(httpClient.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retrofit;
    }
}

