/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.api;

import androidx.annotation.NonNull;
import com.irisvalet.android.apps.mobilevalethelper.GuestManager;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ApiOkHttpInterceptor
implements Interceptor {
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        String apim_key = GuestManager.getAPIManagementKey();
        String property_code = GuestManager.getPropertyCode().toLowerCase().replace(" ", "_");
        String product_name = GuestManager.getProductName().toLowerCase().replace(" ", "_");
        String package_name = GuestManager.getPackageName().replace(" ", "_");
        String app_version = GuestManager.getAppVersion().toLowerCase().replace(" ", "_");
        String build_number = GuestManager.getBuildNumber().toLowerCase().replace(" ", "_");
        String device_manufacturer = GuestManager.getDeviceManufacturer().toLowerCase().replace(" ", "_");
        String device_model = GuestManager.getDeviceModel().toLowerCase().replace(" ", "_");
        String os_version = GuestManager.getOSVersion().toLowerCase().replace(" ", "_");
        Request newRequest = originalRequest.newBuilder().addHeader("Ocp-Apim-Trace", "false").addHeader("Ocp-Apim-Subscription-Key", apim_key).addHeader("iris_property_code", property_code).addHeader("iris_product_name", product_name).addHeader("iris_package_name", package_name).addHeader("iris_platform", "android").addHeader("iris_app_version", app_version).addHeader("iris_build_number", build_number).addHeader("iris_device_manufacturer", device_manufacturer).addHeader("iris_device_model", device_model).addHeader("iris_os_version", os_version).build();
        return chain.proceed(newRequest);
    }
}

