/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.api.Requests;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.irisvalet.android.apps.mobilevalethelper.api.Requests.ServiceRequestItemOption;
import com.irisvalet.android.apps.mobilevalethelper.object.CategoryItem;
import com.irisvalet.android.apps.mobilevalethelper.object.Modifier;
import com.irisvalet.android.apps.mobilevalethelper.object.ModifierOption;
import java.util.ArrayList;

public class ServiceRequestItem {
    @SerializedName(value="categoryItemCode")
    public String categoryItemCode = null;
    @SerializedName(value="comment")
    public String comment = null;
    @SerializedName(value="quantity")
    public int quantity = 1;
    @SerializedName(value="posItemCode")
    public String posItemCode = null;
    @SerializedName(value="options")
    public ArrayList<ServiceRequestItemOption> options = new ArrayList();

    public ServiceRequestItem() {
    }

    public ServiceRequestItem(CategoryItem item) {
        if (item != null) {
            this.categoryItemCode = item.code;
            if (item.modifiers != null && item.modifiers.size() > 0) {
                for (Modifier m : item.modifiers) {
                    if (m.type != null && m.type.equalsIgnoreCase("text")) {
                        if (TextUtils.isEmpty((CharSequence)m.value)) continue;
                        this.options.add(new ServiceRequestItemOption(m.code, m.value));
                        continue;
                    }
                    if (m.type == null || !m.type.equalsIgnoreCase("select") && !m.type.toLowerCase().contains("multi") || m.modifierOptions == null || m.modifierOptions.size() <= 0) continue;
                    for (ModifierOption mo : m.modifierOptions) {
                        if (mo.quantity <= 0 || TextUtils.isEmpty((CharSequence)mo.code)) continue;
                        this.options.add(new ServiceRequestItemOption(m.code, mo.code));
                    }
                }
            }
        }
    }
}

