/*
 * Decompiled with CFR 0.152.
 */
package com.irisvalet.android.apps.mobilevalethelper.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.irisvalet.android.apps.mobilevalethelper.database.tables.DataContentTable;

public class BaseDatabaseHelper
extends SQLiteOpenHelper {
    public static final String TAG = "BaseDatabaseHelper";
    public static final String DATABASE_NAME = "NATIVE_MOBILE_VALET_DB.db";
    private static final int DATABASE_VERSION = 13;
    private static BaseDatabaseHelper mInstance = null;

    BaseDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 13);
    }

    public void initInstance(Context context) {
        if (mInstance == null) {
            mInstance = new BaseDatabaseHelper(context);
        }
    }

    public static BaseDatabaseHelper getInstance() {
        return mInstance;
    }

    public void onCreate(SQLiteDatabase database) {
        DataContentTable.onCreate(database);
    }

    public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        this.dropOldTables(database);
        DataContentTable.onUpgrade(database, oldVersion, newVersion);
        this.onCreate(database);
    }

    private void dropOldTables(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS CategoriesTable");
        db.execSQL("DROP TABLE IF EXISTS CategoryItemsTable");
        db.execSQL("DROP TABLE IF EXISTS ConfigurationTable");
        db.execSQL("DROP TABLE IF EXISTS OutletsTable");
        db.execSQL("DROP TABLE IF EXISTS SectionsTable");
        db.execSQL("DROP TABLE IF EXISTS SubCategoriesTable");
    }
}

